/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.microtime;

import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.microtime.DateFormatUtils;
import io.questdb.std.str.StringSink;

public final class Timestamps {
    public static final long DAY_MICROS = 86400000000L;
    public static final long HOUR_MICROS = 3600000000L;
    public static final long MINUTE_MICROS = 60000000L;
    public static final long SECOND_MICROS = 1000000L;
    public static final int SECOND_MILLIS = 1000;
    public static final int MILLI_MICROS = 1000;
    public static final int STATE_INIT = 0;
    public static final int STATE_UTC = 1;
    public static final int STATE_GMT = 2;
    public static final int STATE_HOUR = 3;
    public static final int STATE_DELIM = 4;
    public static final int STATE_MINUTE = 5;
    public static final int STATE_END = 6;
    public static final int STATE_SIGN = 7;
    public static final TimestampFloorMethod FLOOR_DD = Timestamps::floorDD;
    public static final TimestampAddMethod ADD_DD = Timestamps::addDays;
    private static final long AVG_YEAR_MICROS = 31556952000000L;
    private static final long YEAR_MICROS = 31536000000000L;
    private static final long LEAP_YEAR_MICROS = 31622400000000L;
    private static final long HALF_YEAR_MICROS = 15778476000000L;
    private static final long EPOCH_MICROS = 62167195440000000L;
    private static final long HALF_EPOCH_MICROS = 31083597720000000L;
    private static final int DAY_HOURS = 24;
    private static final int HOUR_MINUTES = 60;
    private static final int MINUTE_SECONDS = 60;
    private static final int DAYS_0000_TO_1970 = 719527;
    public static final TimestampFloorMethod FLOOR_YYYY = Timestamps::floorYYYY;
    private static final int[] DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long[] MIN_MONTH_OF_YEAR_MICROS = new long[12];
    private static final long[] MAX_MONTH_OF_YEAR_MICROS = new long[12];
    public static final TimestampFloorMethod FLOOR_MM = Timestamps::floorMM;
    public static final TimestampAddMethod ADD_MM = Timestamps::addMonths;
    public static final TimestampAddMethod ADD_YYYY = Timestamps::addYear;
    private static final char BEFORE_ZERO = '/';
    private static final char AFTER_NINE = ':';

    private Timestamps() {
    }

    public static long addDays(long micros, int days) {
        return micros + (long)days * 86400000000L;
    }

    public static long addHours(long micros, int hours) {
        return micros + (long)hours * 3600000000L;
    }

    public static long addMonths(long micros, int months) {
        int _y;
        boolean l;
        if (months == 0) {
            return micros;
        }
        int y = Timestamps.getYear(micros);
        int m = Timestamps.getMonthOfYear(micros, y, l = Timestamps.isLeapYear(y));
        int _m = m - 1 + months;
        if (_m > -1) {
            _y = y + _m / 12;
            _m = _m % 12 + 1;
        } else {
            _y = y + _m / 12 - 1;
            if ((_m = -_m % 12) == 0) {
                _m = 12;
            }
            if ((_m = 12 - _m + 1) == 1) {
                ++_y;
            }
        }
        int _d = Timestamps.getDayOfMonth(micros, y, m, l);
        int maxDay = Timestamps.getDaysPerMonth(_m, Timestamps.isLeapYear(_y));
        if (_d > maxDay) {
            _d = maxDay;
        }
        return Timestamps.toMicros(_y, _m, _d) + Timestamps.getTimeMicros(micros) + (long)(micros < 0L ? 1 : 0);
    }

    public static long addPeriod(long lo, char type, int period) throws NumericException {
        switch (type) {
            case 's': {
                return lo + (long)period * 1000000L;
            }
            case 'm': {
                return lo + (long)period * 60000000L;
            }
            case 'h': {
                return Timestamps.addHours(lo, period);
            }
            case 'd': {
                return Timestamps.addDays(lo, period);
            }
            case 'M': {
                return Timestamps.addMonths(lo, period);
            }
            case 'y': {
                return Timestamps.addYear(lo, period);
            }
        }
        throw NumericException.INSTANCE;
    }

    public static long addYear(long micros, int years) {
        if (years == 0) {
            return micros;
        }
        int y = Timestamps.getYear(micros);
        boolean leap1 = Timestamps.isLeapYear(y);
        boolean leap2 = Timestamps.isLeapYear(y + years);
        int m = Timestamps.getMonthOfYear(micros, y, leap1);
        return Timestamps.yearMicros(y + years, leap2) + Timestamps.monthOfYearMicros(m, leap2) + (long)(Timestamps.getDayOfMonth(micros, y, m, leap1) - 1) * 86400000000L + Timestamps.getTimeMicros(micros) + (long)(micros < 0L ? 1 : 0);
    }

    public static long ceilDD(long micros) {
        int y = Timestamps.getYear(micros);
        boolean l = Timestamps.isLeapYear(y);
        int m = Timestamps.getMonthOfYear(micros, y, l);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(m, l) + (long)(Timestamps.getDayOfMonth(micros, y, m, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L;
    }

    public static long ceilMM(long micros) {
        int y = Timestamps.getYear(micros);
        boolean l = Timestamps.isLeapYear(y);
        int m = Timestamps.getMonthOfYear(micros, y, l);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(m, l) + (long)(Timestamps.getDaysPerMonth(m, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L;
    }

    public static long ceilYYYY(long micros) {
        int y = Timestamps.getYear(micros);
        boolean l = Timestamps.isLeapYear(y);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(12, l) + (long)(DAYS_PER_MONTH[11] - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L;
    }

    public static long endOfYear(int year) {
        return Timestamps.toMicros(year, 12, 31, 23, 59) + 59000L + 999999L;
    }

    public static long floorDD(long micros) {
        return micros - Timestamps.getTimeMicros(micros);
    }

    public static long floorHH(long micros) {
        return micros - micros % 3600000000L;
    }

    public static long floorMI(long micros) {
        return micros - micros % 60000000L;
    }

    public static long floorMM(long micros) {
        int y = Timestamps.getYear(micros);
        boolean l = Timestamps.isLeapYear(y);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(Timestamps.getMonthOfYear(micros, y, l), l);
    }

    public static long floorYYYY(long micros) {
        int y = Timestamps.getYear(micros);
        return Timestamps.yearMicros(y, Timestamps.isLeapYear(y));
    }

    public static int getDayOfMonth(long micros, int year, int month, boolean leap) {
        long yearMicros = Timestamps.yearMicros(year, leap);
        return (int)((micros - (yearMicros += Timestamps.monthOfYearMicros(month, leap))) / 86400000000L) + 1;
    }

    public static int getDayOfWeek(long micros) {
        long d;
        if (micros > -1L) {
            d = micros / 86400000000L;
        } else {
            d = (micros - 86399999999L) / 86400000000L;
            if (d < -3L) {
                return 7 + (int)((d + 4L) % 7L);
            }
        }
        return 1 + (int)((d + 3L) % 7L);
    }

    public static int getDayOfWeekSundayFirst(long micros) {
        long d;
        if (micros > -1L) {
            d = micros / 86400000000L;
        } else {
            d = (micros - 86399999999L) / 86400000000L;
            if (d < -4L) {
                return 7 + (int)((d + 5L) % 7L);
            }
        }
        return 1 + (int)((d + 4L) % 7L);
    }

    public static long getDaysBetween(long a, long b) {
        if (b < a) {
            return Timestamps.getDaysBetween(b, a);
        }
        return (b - a) / 86400000000L;
    }

    public static int getDaysPerMonth(int m, boolean leap) {
        return leap & m == 2 ? 29 : DAYS_PER_MONTH[m - 1];
    }

    public static int getHourOfDay(long micros) {
        if (micros > -1L) {
            return (int)(micros / 3600000000L % 24L);
        }
        return 23 + (int)((micros + 1L) / 3600000000L % 24L);
    }

    public static int getMicrosOfSecond(long micros) {
        if (micros > -1L) {
            return (int)(micros % 1000L);
        }
        return 999 + (int)((micros + 1L) % 1000L);
    }

    public static int getMillisOfSecond(long micros) {
        if (micros > -1L) {
            return (int)(micros / 1000L % 1000L);
        }
        return 999 + (int)((micros + 1L) / 1000L % 1000L);
    }

    public static int getMinuteOfHour(long micros) {
        if (micros > -1L) {
            return (int)(micros / 60000000L % 60L);
        }
        return 59 + (int)((micros + 1L) / 60000000L % 60L);
    }

    public static int getMonthOfYear(long micros, int year, boolean leap) {
        int i = (int)((micros - Timestamps.yearMicros(year, leap)) / 1000L >> 10);
        return leap ? (i < 15356250 ? (i < 7678125 ? (i < 2615625 ? 1 : (i < 5062500 ? 2 : 3)) : (i < 10209375 ? 4 : (i < 12825000 ? 5 : 6))) : (i < 23118750 ? (i < 17971875 ? 7 : (i < 20587500 ? 8 : 9)) : (i < 25734375 ? 10 : (i < 28265625 ? 11 : 12)))) : (i < 15271875 ? (i < 7593750 ? (i < 2615625 ? 1 : (i < 4978125 ? 2 : 3)) : (i < 10125000 ? 4 : (i < 12740625 ? 5 : 6))) : (i < 23034375 ? (i < 17887500 ? 7 : (i < 20503125 ? 8 : 9)) : (i < 25650000 ? 10 : (i < 28181250 ? 11 : 12))));
    }

    public static long getMonthsBetween(long a, long b) {
        if (b < a) {
            return Timestamps.getMonthsBetween(b, a);
        }
        int aYear = Timestamps.getYear(a);
        int bYear = Timestamps.getYear(b);
        boolean aLeap = Timestamps.isLeapYear(aYear);
        boolean bLeap = Timestamps.isLeapYear(bYear);
        int aMonth = Timestamps.getMonthOfYear(a, aYear, aLeap);
        int bMonth = Timestamps.getMonthOfYear(b, bYear, bLeap);
        long aResidual = a - Timestamps.yearMicros(aYear, aLeap) - Timestamps.monthOfYearMicros(aMonth, aLeap);
        long bResidual = b - Timestamps.yearMicros(bYear, bLeap) - Timestamps.monthOfYearMicros(bMonth, bLeap);
        long months = 12 * (bYear - aYear) + (bMonth - aMonth);
        if (aResidual > bResidual) {
            return months - 1L;
        }
        return months;
    }

    public static int getSecondOfMinute(long micros) {
        if (micros > -1L) {
            return (int)(micros / 1000000L % 60L);
        }
        return 59 + (int)((micros + 1L) / 1000000L % 60L);
    }

    public static int getYear(long micros) {
        boolean leap;
        int year;
        long yearStart;
        long diff;
        long mid = (micros >> 1) + 31083597720000000L;
        if (mid < 0L) {
            mid = mid - 15778476000000L + 1L;
        }
        if ((diff = micros - (yearStart = Timestamps.yearMicros(year = (int)(mid / 15778476000000L), leap = Timestamps.isLeapYear(year)))) < 0L) {
            --year;
        } else if (diff >= 31536000000000L && (yearStart += leap ? 31622400000000L : 31536000000000L) <= micros) {
            ++year;
        }
        return year;
    }

    public static long getYearsBetween(long a, long b) {
        if (b < a) {
            return Timestamps.getYearsBetween(b, a);
        }
        int aYear = Timestamps.getYear(a);
        int bYear = Timestamps.getYear(b);
        boolean aLeap = Timestamps.isLeapYear(aYear);
        boolean bLeap = Timestamps.isLeapYear(bYear);
        long aResidual = a - Timestamps.yearMicros(aYear, aLeap);
        long bResidual = b - Timestamps.yearMicros(bYear, bLeap);
        long months = bYear - aYear;
        if (aResidual > bResidual) {
            return months - 1L;
        }
        return months;
    }

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static long monthOfYearMicros(int month, boolean leap) {
        return leap ? MAX_MONTH_OF_YEAR_MICROS[month - 1] : MIN_MONTH_OF_YEAR_MICROS[month - 1];
    }

    public static long nextOrSameDayOfWeek(long millis, int dow) {
        int thisDow = Timestamps.getDayOfWeek(millis);
        if (thisDow == dow) {
            return millis;
        }
        if (thisDow < dow) {
            return millis + (long)(dow - thisDow) * 86400000000L;
        }
        return millis + (long)(7 - (thisDow - dow)) * 86400000000L;
    }

    public static long parseOffset(CharSequence in, int lo, int hi) {
        int minute;
        int hour;
        boolean negative;
        int state;
        int p;
        block34: {
            p = lo;
            state = 0;
            negative = false;
            hour = 0;
            minute = 0;
            try {
                while (p < hi) {
                    char c = in.charAt(p);
                    switch (state) {
                        case 0: {
                            switch (c) {
                                case 'U': 
                                case 'u': {
                                    state = 1;
                                    break;
                                }
                                case 'G': 
                                case 'g': {
                                    state = 2;
                                    break;
                                }
                                case 'Z': 
                                case 'z': {
                                    state = 6;
                                    break;
                                }
                                case '+': {
                                    negative = false;
                                    state = 3;
                                    break;
                                }
                                case '-': {
                                    negative = true;
                                    state = 3;
                                    break;
                                }
                                default: {
                                    if (Timestamps.isDigit(c)) {
                                        state = 3;
                                        --p;
                                        break;
                                    }
                                    return Long.MIN_VALUE;
                                }
                            }
                            ++p;
                            break;
                        }
                        case 1: {
                            if (p > hi - 2 || Chars.noMatch(in, p, p + 2, "tc", 0, 2)) {
                                return Long.MIN_VALUE;
                            }
                            state = 7;
                            p += 2;
                            break;
                        }
                        case 2: {
                            if (p > hi - 2 || Chars.noMatch(in, p, p + 2, "mt", 0, 2)) {
                                return Long.MIN_VALUE;
                            }
                            state = 7;
                            p += 2;
                            break;
                        }
                        case 7: {
                            switch (c) {
                                case '+': {
                                    negative = false;
                                    break;
                                }
                                case '-': {
                                    negative = true;
                                    break;
                                }
                                default: {
                                    return Long.MIN_VALUE;
                                }
                            }
                            ++p;
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (!Timestamps.isDigit(c) || p >= hi - 1) {
                                return Long.MIN_VALUE;
                            }
                            hour = Numbers.parseInt(in, p, p + 2);
                            state = 4;
                            p += 2;
                            break;
                        }
                        case 4: {
                            if (c == ':') {
                                state = 5;
                                ++p;
                                break;
                            }
                            if (Timestamps.isDigit(c)) {
                                state = 5;
                                break;
                            }
                            return Long.MIN_VALUE;
                        }
                        case 5: {
                            if (!Timestamps.isDigit(c) || p >= hi - 1) {
                                return Long.MIN_VALUE;
                            }
                            minute = Numbers.parseInt(in, p, p + 2);
                            p += 2;
                            state = 6;
                            break block34;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected state");
                        }
                    }
                }
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }
        switch (state) {
            case 4: 
            case 6: {
                if (hour > 23 || minute > 59) {
                    return Long.MIN_VALUE;
                }
                int min = hour * 60 + minute;
                return Numbers.encodeLowHighInts(negative ? -min : min, p - lo);
            }
        }
        return Long.MIN_VALUE;
    }

    public static long previousOrSameDayOfWeek(long micros, int dow) {
        int thisDow = Timestamps.getDayOfWeek(micros);
        if (thisDow == dow) {
            return micros;
        }
        if (thisDow < dow) {
            return micros - (long)(7 + (thisDow - dow)) * 86400000000L;
        }
        return micros - (long)(thisDow - dow) * 86400000000L;
    }

    public static long toMicros(int y, int m, int d, int h, int mi) {
        return Timestamps.toMicros(y, Timestamps.isLeapYear(y), m, d, h, mi);
    }

    public static long toMicros(int y, boolean leap, int m, int d, int h, int mi) {
        return Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(m, leap) + (long)(d - 1) * 86400000000L + (long)h * 3600000000L + (long)mi * 60000000L;
    }

    public static String toString(long micros) {
        StringSink sink = Misc.getThreadLocalBuilder();
        DateFormatUtils.appendDateTime(sink, micros);
        return ((Object)sink).toString();
    }

    public static long yearMicros(int year, boolean leap) {
        int leapYears = year / 100;
        if (year < 0) {
            leapYears = (year + 3 >> 2) - leapYears + (leapYears + 3 >> 2) - 1;
        } else {
            leapYears = (year >> 2) - leapYears + (leapYears >> 2);
            if (leap) {
                --leapYears;
            }
        }
        return ((long)year * 365L + (long)(leapYears - 719527)) * 86400000000L;
    }

    private static boolean isDigit(char c) {
        return c > '/' && c < ':';
    }

    private static long getTimeMicros(long micros) {
        return micros < 0L ? 86399999999L + micros % 86400000000L : micros % 86400000000L;
    }

    private static long toMicros(int y, int m, int d) {
        boolean l = Timestamps.isLeapYear(y);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(m, l) + (long)(d - 1) * 86400000000L;
    }

    static {
        long minSum = 0L;
        long maxSum = 0L;
        for (int i = 0; i < 11; ++i) {
            Timestamps.MIN_MONTH_OF_YEAR_MICROS[i + 1] = minSum += (long)DAYS_PER_MONTH[i] * 86400000000L;
            Timestamps.MAX_MONTH_OF_YEAR_MICROS[i + 1] = maxSum += (long)Timestamps.getDaysPerMonth(i + 1, true) * 86400000000L;
        }
    }

    @FunctionalInterface
    public static interface TimestampAddMethod {
        public long calculate(long var1, int var3);
    }

    @FunctionalInterface
    public static interface TimestampFloorMethod {
        public long floor(long var1);
    }
}

