/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.time;

import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.time.DateFormat;
import io.questdb.std.time.DateFormatCompiler;
import java.util.function.Function;

public class DateFormatFactory {
    private static final ThreadLocal<DateFormatCompiler> tlCompiler = ThreadLocal.withInitial(DateFormatCompiler::new);
    private static final Function<CharSequence, DateFormat> mapper = DateFormatFactory::map;
    private final ConcurrentHashMap<DateFormat> cache = new ConcurrentHashMap();

    private static DateFormat map(CharSequence value) {
        return tlCompiler.get().compile(value);
    }

    public DateFormat get(CharSequence pattern) {
        return this.cache.computeIfAbsent(pattern, mapper);
    }
}

