/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.time;

import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.CharSink;
import io.questdb.std.time.DateFormat;
import io.questdb.std.time.DateFormatCompiler;
import io.questdb.std.time.DateLocale;
import io.questdb.std.time.DateLocaleFactory;
import io.questdb.std.time.Dates;

public class DateFormatUtils {
    public static final int HOUR_24 = 2;
    public static final int HOUR_PM = 1;
    public static final int HOUR_AM = 0;
    public static final DateFormat UTC_FORMAT;
    public static final String UTC_PATTERN = "yyyy-MM-ddTHH:mm:ss.SSSz";
    public static final DateLocale defaultLocale;
    public static final DateFormat PG_DATE_FORMAT;
    public static final DateFormat PG_DATE_Z_FORMAT;
    public static final DateFormat PG_DATE_TIME_Z_FORMAT;
    private static final DateFormat FMT4;
    private static final DateFormat HTTP_FORMAT;
    static long referenceYear;
    static int thisCenturyLimit;
    static int thisCenturyLow;
    static int prevCenturyLow;
    private static long newYear;

    public static void append0(CharSink sink, int val) {
        if (Math.abs(val) < 10) {
            sink.put('0');
        }
        Numbers.append(sink, val);
    }

    public static void append00(CharSink sink, int val) {
        int v = Math.abs(val);
        if (v < 10) {
            sink.put('0').put('0');
        } else if (v < 100) {
            sink.put('0');
        }
        Numbers.append(sink, val);
    }

    public static void append000(CharSink sink, int val) {
        int v = Math.abs(val);
        if (v < 10) {
            sink.put('0').put('0').put('0');
        } else if (v < 100) {
            sink.put('0').put('0');
        } else if (v < 1000) {
            sink.put('0');
        }
        Numbers.append(sink, val);
    }

    public static void appendDateTime(CharSink sink, long millis) {
        if (millis == Long.MIN_VALUE) {
            return;
        }
        UTC_FORMAT.format(millis, defaultLocale, "Z", sink);
    }

    public static void formatDashYYYYMMDD(CharSink sink, long millis) {
        int y = Dates.getYear(millis);
        boolean l = Dates.isLeapYear(y);
        int m = Dates.getMonthOfYear(millis, y, l);
        Numbers.append(sink, y);
        DateFormatUtils.append0(sink.put('-'), m);
        DateFormatUtils.append0(sink.put('-'), Dates.getDayOfMonth(millis, y, m, l));
    }

    public static void formatHTTP(CharSink sink, long millis) {
        HTTP_FORMAT.format(millis, defaultLocale, "GMT", sink);
    }

    public static void formatMMMDYYYY(CharSink sink, long millis) {
        FMT4.format(millis, defaultLocale, "Z", sink);
    }

    public static void formatYYYYMM(CharSink sink, long millis) {
        int y = Dates.getYear(millis);
        int m = Dates.getMonthOfYear(millis, y, Dates.isLeapYear(y));
        Numbers.append(sink, y);
        DateFormatUtils.append0(sink.put('-'), m);
    }

    public static long getReferenceYear() {
        return referenceYear;
    }

    public static long parseDateTime(CharSequence seq) throws NumericException {
        return UTC_FORMAT.parse(seq, 0, seq.length(), defaultLocale);
    }

    public static void updateReferenceYear(long millis) {
        referenceYear = millis;
        int referenceYear = Dates.getYear(millis);
        int centuryOffset = referenceYear % 100;
        thisCenturyLimit = centuryOffset + 20;
        if (thisCenturyLimit > 100) {
            thisCenturyLimit %= 100;
            thisCenturyLow = referenceYear - centuryOffset + 100;
        } else {
            thisCenturyLow = referenceYear - centuryOffset;
        }
        prevCenturyLow = thisCenturyLow - 100;
        newYear = Dates.endOfYear(referenceYear);
    }

    static void appendAmPm(CharSink sink, int hour, DateLocale locale) {
        if (hour < 12) {
            sink.put(locale.getAMPM(0));
        } else {
            sink.put(locale.getAMPM(1));
        }
    }

    static void assertChar(char c, CharSequence in, int pos, int hi) throws NumericException {
        DateFormatUtils.assertRemaining(pos, hi);
        if (in.charAt(pos) != c) {
            throw NumericException.INSTANCE;
        }
    }

    static int assertString(CharSequence delimiter, int len, CharSequence in, int pos, int hi) throws NumericException {
        if (delimiter.charAt(0) == '\'' && delimiter.charAt(len - 1) == '\'') {
            DateFormatUtils.assertRemaining(pos + len - 3, hi);
            if (!Chars.equals(delimiter, 1, len - 1, in, pos, pos + len - 2)) {
                throw NumericException.INSTANCE;
            }
            return pos + len - 2;
        }
        DateFormatUtils.assertRemaining(pos + len - 1, hi);
        if (!Chars.equals(delimiter, in, pos, pos + len)) {
            throw NumericException.INSTANCE;
        }
        return pos + len;
    }

    static void assertRemaining(int pos, int hi) throws NumericException {
        if (pos < hi) {
            return;
        }
        throw NumericException.INSTANCE;
    }

    static void assertNoTail(int pos, int hi) throws NumericException {
        if (pos < hi) {
            throw NumericException.INSTANCE;
        }
    }

    static long compute(DateLocale locale, int era, int year, int month, int day, int hour, int minute, int second, int millis, int timezone, long offset, int hourType) throws NumericException {
        if (era == 0) {
            year = -(year - 1);
        }
        boolean leap = Dates.isLeapYear(year);
        if (month < 1 || month > 12) {
            throw NumericException.INSTANCE;
        }
        switch (hourType) {
            case 1: {
                hour += 12;
            }
            case 2: {
                if (hour >= 0 && hour <= 23) break;
                throw NumericException.INSTANCE;
            }
            default: {
                if (hour >= 0 && hour <= 11) break;
                throw NumericException.INSTANCE;
            }
        }
        if (day < 1 || day > Dates.getDaysPerMonth(month, leap)) {
            throw NumericException.INSTANCE;
        }
        if (minute < 0 || minute > 59) {
            throw NumericException.INSTANCE;
        }
        if (second < 0 || second > 59) {
            throw NumericException.INSTANCE;
        }
        long datetime = Dates.yearMillis(year, leap) + Dates.monthOfYearMillis(month, leap) + (long)(day - 1) * 86400000L + (long)hour * 3600000L + (long)minute * 60000L + (long)second * 1000L + (long)millis;
        if (timezone > -1) {
            datetime -= locale.getZoneRules(timezone).getOffset(datetime, year, leap);
        } else if (offset > Long.MIN_VALUE) {
            datetime -= offset;
        }
        return datetime;
    }

    static long parseYearGreedy(CharSequence in, int pos, int hi) throws NumericException {
        long l = Numbers.parseIntSafely(in, pos, hi);
        int len = Numbers.decodeHighInt(l);
        int year = len == 2 ? DateFormatUtils.adjustYear(Numbers.decodeLowInt(l)) : Numbers.decodeLowInt(l);
        return Numbers.encodeLowHighInts(year, len);
    }

    static int adjustYear(int year) {
        return (year < thisCenturyLimit ? thisCenturyLow : prevCenturyLow) + year;
    }

    static void appendHour12(CharSink sink, int hour) {
        if (hour < 12) {
            sink.put(hour);
        } else {
            sink.put(hour - 12);
        }
    }

    static void appendHour12Padded(CharSink sink, int hour) {
        if (hour < 12) {
            DateFormatUtils.append0(sink, hour);
        } else {
            DateFormatUtils.append0(sink, hour - 12);
        }
    }

    static void appendHour121Padded(CharSink sink, int hour) {
        if (hour < 12) {
            DateFormatUtils.append0(sink, hour + 1);
        } else {
            DateFormatUtils.append0(sink, hour - 11);
        }
    }

    static void appendHour121(CharSink sink, int hour) {
        if (hour < 12) {
            sink.put(hour + 1);
        } else {
            sink.put(hour - 11);
        }
    }

    static void appendEra(CharSink sink, int year, DateLocale locale) {
        if (year < 0) {
            sink.put(locale.getEra(0));
        } else {
            sink.put(locale.getEra(1));
        }
    }

    static {
        defaultLocale = DateLocaleFactory.INSTANCE.getDefaultDateLocale();
        DateFormatUtils.updateReferenceYear(System.currentTimeMillis());
        DateFormatCompiler compiler = new DateFormatCompiler();
        UTC_FORMAT = compiler.compile(UTC_PATTERN);
        HTTP_FORMAT = compiler.compile("E, d MMM yyyy HH:mm:ss Z");
        FMT4 = compiler.compile("MMM d yyyy");
        PG_DATE_FORMAT = compiler.compile("yyyy-MM-dd");
        PG_DATE_Z_FORMAT = compiler.compile("yyyy-MM-dd z");
        PG_DATE_TIME_Z_FORMAT = compiler.compile("yyyy-MM-dd HH:mm:ss.SSSz");
    }
}

