/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.time;

import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.time.DateLocale;
import io.questdb.std.time.TimeZoneRuleFactory;
import java.text.DateFormatSymbols;
import java.util.Locale;

public class DateLocaleFactory {
    public static final DateLocaleFactory INSTANCE = new DateLocaleFactory(TimeZoneRuleFactory.INSTANCE);
    private final CharSequenceObjHashMap<DateLocale> dateLocales = new CharSequenceObjHashMap();
    private final DateLocale defaultDateLocale;

    public DateLocaleFactory(TimeZoneRuleFactory timeZoneRuleFactory) {
        CharSequenceHashSet cache = new CharSequenceHashSet();
        for (Locale l : Locale.getAvailableLocales()) {
            String tag = l.toLanguageTag();
            if ("und".equals(tag)) {
                tag = "";
            }
            this.dateLocales.put(tag, new DateLocale(new DateFormatSymbols(l), timeZoneRuleFactory, cache));
            cache.clear();
        }
        this.defaultDateLocale = this.dateLocales.get(Locale.getDefault().toLanguageTag());
    }

    public DateLocale getDateLocale(CharSequence id) {
        return this.dateLocales.get(id);
    }

    public DateLocale getDefaultDateLocale() {
        return this.defaultDateLocale;
    }
}

