/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.time;

import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.time.Dates;
import io.questdb.std.time.FixedTimeZoneRule;
import io.questdb.std.time.TimeZoneRules;
import io.questdb.std.time.TimeZoneRulesImpl;
import java.time.ZoneId;
import java.util.Map;

public class TimeZoneRuleFactory {
    public static final TimeZoneRuleFactory INSTANCE = new TimeZoneRuleFactory();
    private final CharSequenceIntHashMap ruleMap = new CharSequenceIntHashMap();
    private final ObjList<TimeZoneRules> ruleList = new ObjList();

    public TimeZoneRuleFactory() {
        int index = 0;
        for (String string : ZoneId.getAvailableZoneIds()) {
            this.ruleList.add(new TimeZoneRulesImpl(ZoneId.of(string).getRules()));
            this.ruleMap.put(string, index++);
        }
        for (Map.Entry entry : ZoneId.SHORT_IDS.entrySet()) {
            String key = (String)entry.getKey();
            String alias = (String)entry.getValue();
            int i = this.ruleMap.get(key);
            if (i != -1) continue;
            i = this.ruleMap.get(alias);
            if (i == -1) {
                long offset = Dates.parseOffset(alias, 0, alias.length());
                if (offset == Long.MIN_VALUE) continue;
                this.ruleList.add(new FixedTimeZoneRule((long)Numbers.decodeLowInt(offset) * 60000L));
                this.ruleMap.put(key, index++);
                continue;
            }
            this.ruleMap.put(key, i);
        }
    }

    public int getTimeZoneRulesIndex(CharSequence id) {
        return this.ruleMap.get(id);
    }

    public TimeZoneRules getTimeZoneRulesQuick(int index) {
        return this.ruleList.getQuick(index);
    }
}

