/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.BootstrapEnv;
import com.questdb.FactoryEventLogger;
import com.questdb.ServerConfiguration;
import com.questdb.log.LogFactory;
import com.questdb.log.LogFileWriter;
import com.questdb.log.LogWriterConfig;
import com.questdb.log.LogWriterFactory;
import com.questdb.mp.Job;
import com.questdb.net.http.HttpServer;
import com.questdb.net.http.SimpleUrlMatcher;
import com.questdb.net.http.handlers.CsvHandler;
import com.questdb.net.http.handlers.ExistenceCheckHandler;
import com.questdb.net.http.handlers.ImportHandler;
import com.questdb.net.http.handlers.QueryHandler;
import com.questdb.net.http.handlers.StaticContentHandler;
import com.questdb.parser.typeprobe.TypeProbeCollection;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Files;
import com.questdb.std.Misc;
import com.questdb.std.ObjHashSet;
import com.questdb.std.Os;
import com.questdb.std.microtime.MicrosecondClockImpl;
import com.questdb.std.str.StringSink;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocaleFactory;
import com.questdb.store.factory.Factory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.misc.Signal;

class BootstrapMain {
    BootstrapMain() {
    }

    public static void main(String[] args) throws Exception {
        System.err.printf("QuestDB HTTP Server %s%nCopyright (C) Appsicle 2014-2017, all rights reserved.%n%n", BootstrapMain.getVersion());
        if (args.length < 1) {
            System.err.println("Root directory name expected");
            return;
        }
        if (Os.type == -2) {
            System.err.println("QuestDB requires 64-bit JVM");
            return;
        }
        CharSequenceObjHashMap<String> optHash = BootstrapMain.hashArgs(args);
        String dir = optHash.get("-d");
        BootstrapMain.extractSite(dir, optHash.get("-f") != null);
        File conf = new File(dir, "conf/questdb.conf");
        if (!conf.exists()) {
            System.err.println("Configuration file does not exist: " + conf);
            return;
        }
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration(conf);
        BootstrapMain.configureLoggers(env.configuration);
        env.dateFormatFactory = new DateFormatFactory();
        env.dateLocaleFactory = DateLocaleFactory.INSTANCE;
        env.typeProbeCollection = new TypeProbeCollection(new File(dir, "conf/date.formats").getAbsolutePath(), env.dateFormatFactory, env.dateLocaleFactory);
        env.factory = new Factory(env.configuration.getDbPath().getAbsolutePath(), env.configuration.getDbPoolIdleTimeout(), env.configuration.getDbReaderPoolSize(), env.configuration.getDbPoolIdleCheckInterval());
        env.matcher = new SimpleUrlMatcher();
        env.matcher.put("/imp", new ImportHandler(env));
        env.matcher.put("/exec", new QueryHandler(env));
        env.matcher.put("/exp", new CsvHandler(env));
        env.matcher.put("/chk", new ExistenceCheckHandler(env));
        env.matcher.setDefaultHandler(new StaticContentHandler(env));
        HttpServer server = new HttpServer(env);
        FactoryEventLogger factoryEventLogger = new FactoryEventLogger(env.factory, 10000000L, 5000L, MicrosecondClockImpl.INSTANCE);
        ObjHashSet<Job> jobs = server.getJobs();
        jobs.addAll(LogFactory.INSTANCE.getJobs());
        jobs.add(factoryEventLogger);
        env.factory.exportJobs(jobs);
        StringSink welcome = Misc.getThreadLocalBuilder();
        if (!server.start()) {
            welcome.put("Could not bind socket ").put(env.configuration.getHttpIP()).put(':').put(env.configuration.getHttpPort());
            welcome.put(". Already running?");
            System.err.println(welcome);
            System.out.println(new Date() + " QuestDB failed to start");
        } else {
            welcome.put("Listening on ").put(env.configuration.getHttpIP()).put(':').put(env.configuration.getHttpPort());
            if (env.configuration.getSslConfig().isSecure()) {
                welcome.put(" [HTTPS]");
            } else {
                welcome.put(" [HTTP plain]");
            }
            System.err.println(welcome);
            System.out.println(new Date() + " QuestDB is running");
            if (Os.type != 3 && optHash.get("-n") == null) {
                Signal.handle(new Signal("HUP"), signal -> {});
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.out.println(new Date() + " QuestDB is shutting down");
                server.halt();
                factoryEventLogger.close();
                env.factory.close();
            }));
        }
    }

    private static String getVersion() throws IOException {
        Enumeration<URL> resources = BootstrapMain.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream is = resources.nextElement().openStream();
            Throwable throwable = null;
            try {
                Manifest manifest = new Manifest(is);
                Attributes attributes = manifest.getMainAttributes();
                if (!"org.questdb".equals(attributes.getValue("Implementation-Vendor-Id"))) continue;
                String string = manifest.getMainAttributes().getValue("Implementation-Version");
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return "[DEVELOPMENT]";
    }

    private static CharSequenceObjHashMap<String> hashArgs(String[] args) {
        CharSequenceObjHashMap<String> optHash = new CharSequenceObjHashMap<String>();
        String flag = null;
        for (String s : args) {
            if (s.startsWith("-")) {
                if (flag != null) {
                    optHash.put(flag, "");
                }
                flag = s;
                continue;
            }
            if (flag != null) {
                optHash.put(flag, s);
                flag = null;
                continue;
            }
            System.err.println("Unknown arg: " + s);
            System.exit(55);
        }
        if (flag != null) {
            optHash.put(flag, "");
        }
        return optHash;
    }

    private static void configureLoggers(ServerConfiguration configuration) {
        LogWriterFactory factory = (ring, seq, level) -> {
            LogFileWriter w = new LogFileWriter(ring, seq, level);
            w.setLocation(configuration.getAccessLog().getAbsolutePath());
            return w;
        };
        LogFactory.INSTANCE.add(new LogWriterConfig("access", 7, factory));
        LogFactory.INSTANCE.add(new LogWriterConfig(System.getProperty("ebug") != null ? 7 : 6, factory));
        LogFactory.INSTANCE.bind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractSite(String dir, boolean force) throws URISyntaxException, IOException {
        int sourceLen;
        Path source;
        System.out.println("Preparing content...");
        URL url = HttpServer.class.getResource("/site/");
        String[] components = url.toURI().toString().split("!");
        FileSystem fs = null;
        if (components.length > 1) {
            fs = FileSystems.newFileSystem(URI.create(components[0]), new HashMap());
            source = fs.getPath(components[1], new String[0]);
            sourceLen = source.toAbsolutePath().toString().length();
        } else {
            source = Paths.get(url.toURI());
            sourceLen = source.toAbsolutePath().toString().length() + 1;
        }
        try {
            File pub;
            final Path target = Paths.get(dir, new String[0]);
            EnumSet<FileVisitOption> walkOptions = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            final CopyOption[] copyOptions = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
            if (force && (pub = new File(dir, "public")).exists()) {
                Files.delete(pub);
            }
            java.nio.file.Files.walkFileTree(source, walkOptions, Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){
                private boolean skip = true;

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (this.skip) {
                        this.skip = false;
                    } else {
                        try {
                            java.nio.file.Files.copy(dir, this.toDestination(dir), copyOptions);
                            System.out.println("Extracted " + dir);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        }
                        catch (IOException x) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    java.nio.file.Files.copy(file, this.toDestination(file), copyOptions);
                    System.out.println("Extracted " + file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                private Path toDestination(Path path) {
                    Path tmp = path.toAbsolutePath();
                    return target.resolve(tmp.toString().substring(sourceLen));
                }
            });
        }
        finally {
            if (fs != null) {
                fs.close();
            }
        }
    }
}

