/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.MPSequence;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SCSequence;
import com.questdb.mp.SynchronizedJob;
import com.questdb.std.ObjectFactory;
import com.questdb.std.Os;
import com.questdb.std.ex.JournalException;
import com.questdb.std.microtime.MicrosecondClock;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.configuration.JournalStructure;
import java.io.Closeable;

public class FactoryEventLogger
extends SynchronizedJob
implements Closeable {
    private static final Log LOG = LogFactory.getLog(FactoryEventLogger.class);
    private static final int PID = Os.getPid();
    private static final JournalStructure STRUCTURE = new JournalStructure("$mon_factory").$int("pid").$byte("factoryType").$long("thread").$sym("name").buckets(64).$short("event").$short("segment").$short("position").$ts().partitionBy(0).recordCountHint(10000).$();
    private final Factory factory;
    private final JournalWriter writer;
    private final RingQueue<FactoryEvent> eventQueue = new RingQueue(FactoryEvent.access$000(), 16);
    private final MPSequence pubSeq = new MPSequence(this.eventQueue.getCapacity());
    private final SCSequence subSeq = new SCSequence();
    private final long commitBatchSize;
    private final long commitInterval;
    private final MicrosecondClock clock;
    private long lastEventTimestamp = -1L;

    public FactoryEventLogger(Factory factory, long commitBatchSize, long commitInterval, MicrosecondClock clock) throws JournalException {
        this.factory = factory;
        this.commitBatchSize = commitBatchSize;
        this.commitInterval = commitInterval;
        this.clock = clock;
        this.writer = factory.writer(STRUCTURE);
        this.pubSeq.then(this.subSeq).then(this.pubSeq);
        this.factory.setEventListener((factoryType, thread, name, event, segment, position) -> {
            long cursor = this.pubSeq.next();
            if (cursor < 0L) {
                return false;
            }
            FactoryEvent ev = this.eventQueue.get(cursor);
            ev.factoryType = factoryType;
            ev.thread = thread;
            ev.name = name;
            ev.event = event;
            ev.segment = segment;
            ev.position = position;
            this.pubSeq.done(cursor);
            return true;
        });
        LOG.info().$("FactoryEventLogger started").$();
    }

    @Override
    public void close() {
        this.factory.setEventListener(null);
        this.writer.close();
        LOG.info().$("FactoryEventLogger stopped").$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean runSerially() {
        long cursor = this.subSeq.next();
        try {
            if (cursor < 0L) {
                if (this.lastEventTimestamp > -1L && this.clock.getTicks() - this.lastEventTimestamp > this.commitInterval) {
                    this.lastEventTimestamp = -1L;
                    this.writer.commit();
                }
                return false;
            }
            long available = this.subSeq.available();
            try {
                long count = available - cursor;
                while (cursor < available) {
                    FactoryEvent ev = this.eventQueue.get(cursor++);
                    JournalEntryWriter ew = this.writer.entryWriter(this.clock.getTicks());
                    ew.putInt(0, PID);
                    ew.put(1, ev.factoryType);
                    ew.putLong(2, ev.thread);
                    ew.putSym(3, ev.name);
                    ew.putShort(4, ev.event);
                    ew.putShort(5, ev.segment);
                    ew.putShort(6, ev.position);
                    ew.append();
                }
                if (count > this.commitBatchSize) {
                    this.writer.commit();
                }
                this.lastEventTimestamp = this.clock.getTicks();
            }
            finally {
                this.subSeq.done(available - 1L);
            }
            return true;
        }
        catch (JournalException e) {
            LOG.error().$("Failed to log factory event: ").$(e).$();
            return false;
        }
    }

    private static class FactoryEvent {
        private static final ObjectFactory<FactoryEvent> FACTORY = FactoryEvent::new;
        private byte factoryType;
        private long thread;
        private String name;
        private short event;
        private short segment;
        private short position;

        private FactoryEvent() {
        }

        static /* synthetic */ ObjectFactory access$000() {
            return FACTORY;
        }
    }
}

