/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.common.NumericException;
import com.questdb.net.SslConfig;
import com.questdb.std.Numbers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class ServerConfiguration {
    private final SslConfig sslConfig = new SslConfig();
    private String httpIP = "0.0.0.0";
    private int httpPort = 9000;
    private int httpBufReqHeader = 65536;
    private int httpBufReqContent = 0x400000;
    private int httpBufReqMultipart = 1024;
    private int httpBufRespHeader = 1024;
    private int httpBufRespContent = 0x100000;
    private int httpThreads = 2;
    private int httpTimeout = 10000000;
    private int httpMaxConnections = 128;
    private int journalPoolSize = 128;
    private int httpQueueDepth = 1024;
    private int httpSoRcvSmall = 8192;
    private int httpSoRcvLarge = 0x400000;
    private int httpSoRetries = 1000000;
    private boolean httpAbortBrokenUploads = true;
    private String httpIndexFile = "index.html";
    private int httpImportMaxJsonStringLen = 65536;
    private int httpImportInitialTextBuf = 4096;
    private int httpImportMaxTextBuf = 0x400000;
    private int httpImportSampleSize = 100;
    private int dbAsOfDataPage = 0x400000;
    private int dbAsOfIndexPage = 0x100000;
    private int dbAsOfRowPage = 0x100000;
    private int dbSortKeyPage = 0x100000;
    private int dbSortDataPage = 0x400000;
    private int dbAggregatePage = 0x400000;
    private int dbHashKeyPage = 0x400000;
    private int dbHashDataPage = 0x800000;
    private int dbHashRowPage = 0x100000;
    private int dbSysViewPage = 65536;
    private int dbSysMetaSize = 65536;
    private int dbSysMaxMetaSize = 0x800000;
    private int dbCyclesBeforeCancel = 0x100000;
    private int dbAnalyticFuncPage = 0x200000;
    private int dbAnalyticWindowPage = 0x400000;
    private int dbFnVarianceMeans = 0x100000;
    private int dbFnVarianceData = 0x4000000;
    private long dbPoolIdleTimeout = 60000L;
    private long dbPoolIdleCheckInterval = 60000L;
    private int dbReaderPoolSize = 2;
    private File dbPath = new File("db");
    private File mimeTypes = new File("conf/mime.types");
    private File httpPublic = new File("public");
    private File accessLog = new File("log/access.log");
    private File errorLog = new File("log/error.log");

    public ServerConfiguration() {
    }

    public ServerConfiguration(File conf) throws Exception {
        long l;
        int n;
        Properties props = new Properties();
        File root = conf.getParentFile().getParentFile();
        try (FileInputStream fis = new FileInputStream(conf);){
            props.load(fis);
        }
        String s = props.getProperty("http.ip");
        if (s != null) {
            this.httpIP = s;
        }
        if ((n = this.parseInt(props, "http.port")) > -1) {
            this.httpPort = n;
        }
        if ((n = this.parseInt(props, "http.threads")) > -1) {
            this.httpThreads = n;
        }
        if ((n = this.parseInt(props, "http.timeout")) > -1) {
            this.httpTimeout = n;
        }
        if ((n = this.parseSize(props, "http.buf.req.header")) > -1) {
            this.httpBufReqHeader = n;
        }
        if ((n = this.parseInt(props, "http.max.connections")) > -1) {
            this.httpMaxConnections = n;
        }
        if ((n = this.parseInt(props, "http.queue.depth")) > -1) {
            this.httpQueueDepth = Numbers.ceilPow2(n);
        }
        if ((n = this.parseSize(props, "http.so.rcv.small")) > -1) {
            this.httpSoRcvSmall = n;
        }
        if ((n = this.parseSize(props, "http.so.rcv.large")) > -1) {
            this.httpSoRcvLarge = n;
        }
        if ((n = this.parseInt(props, "http.so.retries")) > -1) {
            this.httpSoRetries = n;
        }
        if ((s = props.getProperty("http.abort.broken.uploads")) != null) {
            if ("true".equals(s)) {
                this.httpAbortBrokenUploads = true;
            } else if ("false".equals(s)) {
                this.httpAbortBrokenUploads = false;
            } else {
                throw new IllegalArgumentException("http.abort.broken.uploads");
            }
        }
        if ((n = this.parseSize(props, "http.buf.req.content")) > -1) {
            this.httpBufReqContent = n;
        }
        if ((n = this.parseSize(props, "http.buf.req.multipart")) > -1) {
            this.httpBufReqMultipart = n;
        }
        if ((n = this.parseSize(props, "http.buf.resp.header")) > -1) {
            this.httpBufRespHeader = n;
        }
        if ((n = this.parseSize(props, "http.buf.resp.content")) > -1) {
            this.httpBufRespContent = n;
        }
        if ((s = props.getProperty("http.index.file")) != null) {
            this.httpIndexFile = s;
        }
        if ((n = this.parseInt(props, "http.import.max.json.string")) > -1) {
            this.httpImportMaxJsonStringLen = n;
        }
        if ((n = this.parseInt(props, "http.import.initial.text.buf")) > -1) {
            this.httpImportInitialTextBuf = n;
        }
        if ((n = this.parseInt(props, "http.import.max.text.buf")) > -1) {
            this.httpImportMaxTextBuf = n;
        }
        if ((n = this.parseInt(props, "http.import.sample.size")) > -1) {
            this.httpImportSampleSize = n;
        }
        this.dbPath = (s = props.getProperty("db.path")) != null ? this.mkdirs(this.normalize(root, new File(s))) : this.mkdirs(this.normalize(root, this.dbPath));
        n = this.parseSize(props, "db.max.pool.size");
        this.journalPoolSize = n > -1 ? n : this.httpMaxConnections;
        n = this.parseSize(props, "db.asof.datapage");
        if (n > -1) {
            this.dbAsOfDataPage = n;
        }
        if ((n = this.parseSize(props, "db.asof.indexpage")) > -1) {
            this.dbAsOfIndexPage = n;
        }
        if ((n = this.parseSize(props, "db.asof.rowpage")) > -1) {
            this.dbAsOfRowPage = n;
        }
        if ((n = this.parseSize(props, "db.sort.keypage")) > -1) {
            this.dbSortKeyPage = n;
        }
        if ((n = this.parseSize(props, "db.sort.datapage")) > -1) {
            this.dbSortDataPage = n;
        }
        if ((n = this.parseSize(props, "db.aggregate.page")) > -1) {
            this.dbAggregatePage = n;
        }
        if ((n = this.parseSize(props, "db.hash.keypage")) > -1) {
            this.dbHashKeyPage = n;
        }
        if ((n = this.parseSize(props, "db.hash.datapage")) > -1) {
            this.dbHashDataPage = n;
        }
        if ((n = this.parseSize(props, "db.hash.rowpage")) > -1) {
            this.dbHashRowPage = n;
        }
        if ((n = this.parseSize(props, "db.sys.viewpage")) > -1) {
            this.dbSysViewPage = n;
        }
        if ((n = this.parseSize(props, "db.sys.metasize")) > -1) {
            this.dbSysMetaSize = n;
        }
        if ((n = this.parseSize(props, "db.sys.maxmetasize")) > -1) {
            this.dbSysMaxMetaSize = n;
        }
        if ((n = this.parseInt(props, "db.cycles.before.cancel")) > -1) {
            this.dbCyclesBeforeCancel = Numbers.ceilPow2(n);
        }
        if ((n = this.parseSize(props, "db.analytic.func.page")) > -1) {
            this.dbAnalyticFuncPage = n;
        }
        if ((n = this.parseSize(props, "db.analytic.window.page")) > -1) {
            this.dbAnalyticWindowPage = n;
        }
        if ((n = this.parseSize(props, "db.fn.variance.means")) > -1) {
            this.dbFnVarianceMeans = n;
        }
        if ((n = this.parseSize(props, "db.fn.variance.data")) > -1) {
            this.dbFnVarianceData = n;
        }
        this.mimeTypes = (s = props.getProperty("mime.types")) != null ? this.normalize(root, new File(s)) : this.normalize(root, this.mimeTypes);
        s = props.getProperty("http.public");
        this.httpPublic = s != null ? this.mkdirs(this.normalize(root, new File(s))) : this.mkdirs(this.normalize(root, this.httpPublic));
        s = props.getProperty("http.log.access");
        this.accessLog = s != null ? this.normalize(root, new File(s)) : this.normalize(root, this.accessLog);
        this.mkdirs(this.accessLog.getParentFile());
        s = props.getProperty("http.log.error");
        this.errorLog = s != null ? this.normalize(root, new File(s)) : this.normalize(root, this.errorLog);
        this.mkdirs(this.accessLog.getParentFile());
        if (this.httpMaxConnections > this.httpQueueDepth) {
            throw new IllegalArgumentException("http.max.connections must be less than http.queue.depth");
        }
        this.sslConfig.setSecure("true".equals(props.getProperty("http.ssl.enabled")));
        if (this.sslConfig.isSecure()) {
            s = props.getProperty("http.ssl.keystore.location");
            if (s == null) {
                throw new IllegalArgumentException("http.ssl.keystore.location is undefined");
            }
            File keystore = this.normalize(root, new File(s));
            if (!keystore.exists()) {
                throw new IllegalArgumentException("http.ssl.keystore.location does not exist");
            }
            if (!keystore.isFile()) {
                throw new IllegalArgumentException("http.ssl.keystore.location is not a file");
            }
            try (FileInputStream is = new FileInputStream(keystore);){
                s = props.getProperty("http.ssl.keystore.password");
                this.sslConfig.setKeyStore(is, s == null ? "" : s);
            }
            this.sslConfig.setRequireClientAuth("true".equals(props.getProperty("http.ssl.auth")));
        }
        if ((l = this.parseLong(props, "db.pool.idle.timeout")) > -1L) {
            this.dbPoolIdleTimeout = l;
        }
        if ((l = this.parseLong(props, "db.pool.idle.check.interval")) > -1L) {
            this.dbPoolIdleCheckInterval = l;
        }
        if ((n = this.parseInt(props, "db.reader.pool.size")) > -1) {
            this.dbReaderPoolSize = n;
        }
    }

    public File getAccessLog() {
        return this.accessLog;
    }

    public int getDbAggregatePage() {
        return this.dbAggregatePage;
    }

    public int getDbAnalyticFuncPage() {
        return this.dbAnalyticFuncPage;
    }

    public int getDbAnalyticWindowPage() {
        return this.dbAnalyticWindowPage;
    }

    public int getDbAsOfDataPage() {
        return this.dbAsOfDataPage;
    }

    public int getDbAsOfIndexPage() {
        return this.dbAsOfIndexPage;
    }

    public int getDbAsOfRowPage() {
        return this.dbAsOfRowPage;
    }

    public int getDbCyclesBeforeCancel() {
        return this.dbCyclesBeforeCancel;
    }

    public int getDbFnVarianceData() {
        return this.dbFnVarianceData;
    }

    public int getDbFnVarianceMeans() {
        return this.dbFnVarianceMeans;
    }

    public int getDbHashDataPage() {
        return this.dbHashDataPage;
    }

    public int getDbHashKeyPage() {
        return this.dbHashKeyPage;
    }

    public int getDbHashRowPage() {
        return this.dbHashRowPage;
    }

    public File getDbPath() {
        return this.dbPath;
    }

    public long getDbPoolIdleCheckInterval() {
        return this.dbPoolIdleCheckInterval;
    }

    public long getDbPoolIdleTimeout() {
        return this.dbPoolIdleTimeout;
    }

    public int getDbReaderPoolSize() {
        return this.dbReaderPoolSize;
    }

    public int getDbSortDataPage() {
        return this.dbSortDataPage;
    }

    public int getDbSortKeyPage() {
        return this.dbSortKeyPage;
    }

    public int getDbSysMaxMetaSize() {
        return this.dbSysMaxMetaSize;
    }

    public int getDbSysMetaSize() {
        return this.dbSysMetaSize;
    }

    public int getDbSysViewPage() {
        return this.dbSysViewPage;
    }

    public File getErrorLog() {
        return this.errorLog;
    }

    public int getHttpBufReqContent() {
        return this.httpBufReqContent;
    }

    public int getHttpBufReqHeader() {
        return this.httpBufReqHeader;
    }

    public int getHttpBufReqMultipart() {
        return this.httpBufReqMultipart;
    }

    public int getHttpBufRespContent() {
        return this.httpBufRespContent;
    }

    public void setHttpBufRespContent(int httpBufRespContent) {
        this.httpBufRespContent = httpBufRespContent;
    }

    public int getHttpBufRespHeader() {
        return this.httpBufRespHeader;
    }

    public String getHttpIP() {
        return this.httpIP;
    }

    public int getHttpImportInitialTextBuf() {
        return this.httpImportInitialTextBuf;
    }

    public int getHttpImportMaxJsonStringLen() {
        return this.httpImportMaxJsonStringLen;
    }

    public int getHttpImportMaxTextBuf() {
        return this.httpImportMaxTextBuf;
    }

    public int getHttpImportSampleSize() {
        return this.httpImportSampleSize;
    }

    public String getHttpIndexFile() {
        return this.httpIndexFile;
    }

    public int getHttpMaxConnections() {
        return this.httpMaxConnections;
    }

    public void setHttpMaxConnections(int httpMaxConnections) {
        this.httpMaxConnections = httpMaxConnections;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public File getHttpPublic() {
        return this.httpPublic;
    }

    public int getHttpQueueDepth() {
        return this.httpQueueDepth;
    }

    public int getHttpSoRcvLarge() {
        return this.httpSoRcvLarge;
    }

    public int getHttpSoRcvSmall() {
        return this.httpSoRcvSmall;
    }

    public int getHttpSoRetries() {
        return this.httpSoRetries;
    }

    public void setHttpSoRetries(int httpSoRetries) {
        this.httpSoRetries = httpSoRetries;
    }

    public int getHttpThreads() {
        return this.httpThreads;
    }

    public void setHttpThreads(int httpThreads) {
        this.httpThreads = httpThreads;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public void setHttpTimeout(int httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public int getJournalPoolSize() {
        return this.journalPoolSize;
    }

    public File getMimeTypes() {
        return this.mimeTypes;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public boolean isHttpAbortBrokenUploads() {
        return this.httpAbortBrokenUploads;
    }

    public String toString() {
        return "ServerConfiguration{sslConfig=" + this.sslConfig + ", httpIP='" + this.httpIP + '\'' + ", httpPort=" + this.httpPort + ", httpBufReqHeader=" + this.httpBufReqHeader + ", httpBufReqContent=" + this.httpBufReqContent + ", httpBufReqMultipart=" + this.httpBufReqMultipart + ", httpBufRespHeader=" + this.httpBufRespHeader + ", httpBufRespContent=" + this.httpBufRespContent + ", httpThreads=" + this.httpThreads + ", httpTimeout=" + this.httpTimeout + ", httpMaxConnections=" + this.httpMaxConnections + ", journalPoolSize=" + this.journalPoolSize + ", httpQueueDepth=" + this.httpQueueDepth + ", httpSoRcvSmall=" + this.httpSoRcvSmall + ", httpSoRcvLarge=" + this.httpSoRcvLarge + ", httpSoRetries=" + this.httpSoRetries + ", dbAsOfDataPage=" + this.dbAsOfDataPage + ", dbAsOfIndexPage=" + this.dbAsOfIndexPage + ", dbAsOfRowPage=" + this.dbAsOfRowPage + ", dbSortKeyPage=" + this.dbSortKeyPage + ", dbSortDataPage=" + this.dbSortDataPage + ", dbAggregatePage=" + this.dbAggregatePage + ", dbPath=" + this.dbPath + ", mimeTypes=" + this.mimeTypes + ", httpPublic=" + this.httpPublic + ", accessLog=" + this.accessLog + ", errorLog=" + this.errorLog + '}';
    }

    private File mkdirs(File dir) throws IOException {
        if (!dir.exists()) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        return dir;
    }

    private File normalize(File root, File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(root, file.getPath());
    }

    private int parseInt(Properties props, String name) {
        String val = props.getProperty(name);
        if (val != null) {
            try {
                return Numbers.parseInt(val);
            }
            catch (NumericException e) {
                System.out.println(name + ": invalid value");
            }
        }
        return -1;
    }

    private long parseLong(Properties props, String name) {
        String val = props.getProperty(name);
        if (val != null) {
            try {
                return Numbers.parseLong(val);
            }
            catch (NumericException e) {
                System.out.println(name + ": invalid value");
            }
        }
        return -1L;
    }

    private int parseSize(Properties props, String name) {
        String val = props.getProperty(name);
        if (val != null) {
            try {
                return Numbers.ceilPow2(Numbers.parseIntSize(val));
            }
            catch (NumericException e) {
                System.out.println(name + ": invalid value");
            }
        }
        return -1;
    }
}

