/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.CairoException;
import com.questdb.cairo.VirtualMemory;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.FilesFacade;
import com.questdb.std.Os;
import com.questdb.std.str.LPSZ;

public class AppendMemory
extends VirtualMemory {
    private static final Log LOG = LogFactory.getLog(AppendMemory.class);
    private FilesFacade ff;
    private long fd = -1L;
    private long pageAddress = 0L;
    private long size;

    public AppendMemory(FilesFacade ff, LPSZ name, long pageSize) {
        this.of(ff, name, pageSize);
    }

    public AppendMemory() {
        this.size = 0L;
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void jumpTo(long offset) {
        this.updateSize();
        super.jumpTo(offset);
    }

    @Override
    protected long mapWritePage(int page) {
        long address;
        this.releaseCurrentPage();
        this.pageAddress = address = this.mapPage(page);
        return this.pageAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(boolean truncate) {
        long sz = this.getAppendOffset();
        this.releaseCurrentPage();
        super.close();
        if (this.fd != -1L) {
            try {
                if (truncate) {
                    if (this.ff.truncate(this.fd, sz)) {
                        LOG.info().$("truncated and closed [fd=").$(this.fd).$(']').$();
                    } else {
                        long n;
                        if (!this.ff.supportsTruncateMappedFiles() && this.ff.truncate(this.fd, ((n = sz / this.getMapPageSize()) + 1L) * this.getMapPageSize())) {
                            LOG.info().$("truncated and closed, second attempt [fd=").$(this.fd).$(']').$();
                            return;
                        }
                        LOG.info().$("closed without truncate [fd=").$(this.fd).$(", errno=").$(Os.errno()).$(']').$();
                    }
                } else {
                    LOG.info().$("closed [fd=").$(this.fd).$(']').$();
                }
            }
            finally {
                this.closeFd();
            }
        }
    }

    public final void setSize(long size) {
        this.size = size;
        this.jumpTo(size);
    }

    public long getFd() {
        return this.fd;
    }

    public final void of(FilesFacade ff, LPSZ name, long pageSize) {
        this.close();
        this.ff = ff;
        this.setPageSize(pageSize);
        this.fd = ff.openRW(name);
        if (this.fd == -1L) {
            throw CairoException.instance(ff.errno()).put("Cannot open ").put(name);
        }
        LOG.info().$("open ").$(name).$(" [fd=").$(this.fd).$(']').$();
    }

    public long size() {
        if (this.size < this.getAppendOffset()) {
            this.size = this.getAppendOffset();
        }
        return this.size;
    }

    @Override
    protected void release(int page, long address) {
        this.ff.munmap(address, this.getPageSize(page));
    }

    public void truncate() {
        if (this.fd == -1L) {
            return;
        }
        this.size = 0L;
        this.releaseCurrentPage();
        if (!this.ff.truncate(this.fd, this.getMapPageSize())) {
            throw CairoException.instance(Os.errno()).put("Cannot truncate fd=").put(this.fd).put(" to ").put(this.getMapPageSize()).put(" bytes");
        }
        this.pageAddress = this.mapPage(0);
        this.updateLimits(0, this.pageAddress);
    }

    private void closeFd() {
        this.ff.close(this.fd);
        this.fd = -1L;
    }

    private long mapPage(int page) {
        long target = this.pageOffset(page + 1);
        if (this.ff.length(this.fd) < target && !this.ff.truncate(this.fd, target)) {
            throw CairoException.instance(this.ff.errno()).put("Appender resize failed fd=").put(this.fd).put(", size=").put(target);
        }
        long offset = this.pageOffset(page);
        long address = this.ff.mmap(this.fd, this.getMapPageSize(), offset, 2);
        if (address == -1L) {
            throw CairoException.instance(this.ff.errno()).put("Cannot mmap(append) fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(this.getMapPageSize());
        }
        return address;
    }

    private void releaseCurrentPage() {
        if (this.pageAddress != 0L) {
            this.release(0, this.pageAddress);
            this.pageAddress = 0L;
        }
    }

    private void updateSize() {
        this.size = Math.max(this.size, this.getAppendOffset());
    }
}

