/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.std.Sinkable;
import com.questdb.std.ThreadLocal;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;

public class CairoException
extends RuntimeException
implements Sinkable {
    private static final ThreadLocal<CairoException> tlException = new ThreadLocal<CairoException>(CairoException::new);
    private final StringSink message = new StringSink();
    private int errno;

    public static CairoException instance(int errno) {
        CairoException ex = (CairoException)tlException.get();
        ex.message.clear();
        ex.errno = errno;
        return ex;
    }

    @Override
    public String getMessage() {
        return "[" + this.errno + "] " + this.message.toString();
    }

    public CairoException put(long value) {
        this.message.put(value);
        return this;
    }

    public CairoException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public CairoException put(char c) {
        this.message.put(c);
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[').put(this.errno).put("]: ").put(this.message);
    }
}

