/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableUtils;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.pool.PoolListener;
import com.questdb.cairo.pool.ReaderPool;
import com.questdb.cairo.pool.WriterPool;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.Job;
import com.questdb.mp.SynchronizedJob;
import com.questdb.std.FilesFacade;
import com.questdb.std.Misc;
import com.questdb.std.ObjHashSet;
import com.questdb.std.microtime.MicrosecondClock;
import com.questdb.std.str.Path;
import java.io.Closeable;

public class Engine
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Engine.class);
    private final WriterPool writerPool;
    private final ReaderPool readerPool;
    private final WriterMaintenanceJob writerMaintenanceJob;
    private final CairoConfiguration configuration;
    private final Path path = new Path();
    private final Path other = new Path();

    public Engine(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.writerPool = new WriterPool(configuration);
        this.readerPool = new ReaderPool(configuration);
        this.writerMaintenanceJob = new WriterMaintenanceJob(configuration);
    }

    @Override
    public void close() {
        Misc.free(this.writerPool);
        Misc.free(this.readerPool);
        Misc.free(this.path);
        Misc.free(this.other);
    }

    public void exportJobs(ObjHashSet<Job> jobs) {
        jobs.add(this.writerMaintenanceJob);
    }

    public int getBusyReaderCount() {
        return this.readerPool.getBusyCount();
    }

    public int getBusyWriterCount() {
        return this.writerPool.getBusyCount();
    }

    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    public PoolListener getPoolListener() {
        return this.writerPool.getPoolListener();
    }

    public void setPoolListener(PoolListener poolListener) {
        this.writerPool.setPoolListner(poolListener);
        this.readerPool.setPoolListner(poolListener);
    }

    public TableReader getReader(CharSequence tableName) {
        return this.readerPool.get(tableName);
    }

    public int getStatus(CharSequence tableName) {
        return TableUtils.exists(this.configuration.getFilesFacade(), this.path, this.configuration.getRoot(), tableName);
    }

    public TableWriter getWriter(CharSequence tableName) {
        return this.writerPool.get(tableName);
    }

    public boolean lock(CharSequence tableName) {
        if (this.writerPool.lock(tableName)) {
            boolean locked = this.readerPool.lock(tableName);
            if (locked) {
                return true;
            }
            this.writerPool.unlock(tableName);
        }
        return false;
    }

    public void remove(CharSequence tableName) {
        if (this.lock(tableName)) {
            try {
                this.path.of(this.configuration.getRoot()).concat(tableName).$();
                if (!this.configuration.getFilesFacade().rmdir(this.path)) {
                    int error = this.configuration.getFilesFacade().errno();
                    LOG.error().$("remove failed [tableName='").utf8(tableName).$("', error=").$(error).$(']').$();
                    throw CairoException.instance(error).put("Table remove failed");
                }
                return;
            }
            finally {
                this.unlock(tableName);
            }
        }
        throw CairoException.instance(this.configuration.getFilesFacade().errno()).put("Cannot lock ").put(tableName);
    }

    public void rename(CharSequence tableName, String newName) {
        if (this.lock(tableName)) {
            try {
                this.rename0(tableName, newName);
            }
            finally {
                this.unlock(tableName);
            }
        } else {
            LOG.error().$("cannot lock and rename [from='").$(tableName).$("', to='").$(newName).$("']").$();
            throw CairoException.instance(0).put("Cannot lock [table=").put(tableName).put(']');
        }
    }

    public void unlock(CharSequence tableName) {
        this.readerPool.unlock(tableName);
        this.writerPool.unlock(tableName);
    }

    private void rename0(CharSequence tableName, CharSequence to) {
        CharSequence root;
        FilesFacade ff = this.configuration.getFilesFacade();
        if (TableUtils.exists(ff, this.path, root = this.configuration.getRoot(), tableName) != 0) {
            LOG.error().$('\'').utf8(tableName).$("' does not exist. Rename failed.").$();
            throw CairoException.instance(0).put("Rename failed. Table '").put(tableName).put("' does not exist");
        }
        this.path.of(root).concat(tableName).$();
        this.other.of(root).concat(to).$();
        if (ff.exists(this.other)) {
            LOG.error().$("rename target exists [from='").$(tableName).$("', to='").$(this.other).$("']").$();
            throw CairoException.instance(0).put("Rename target exists");
        }
        if (!ff.rename(this.path, this.other)) {
            int error = ff.errno();
            LOG.error().$("rename failed [from='").$(this.path).$("', to='").$(this.other).$("', error=").$(error).$(']').$();
            throw CairoException.instance(error).put("Rename failed");
        }
    }

    private class WriterMaintenanceJob
    extends SynchronizedJob {
        private final MicrosecondClock clock;
        private final long checkInterval;
        private long last = 0L;

        public WriterMaintenanceJob(CairoConfiguration configuration) {
            this.clock = configuration.getClock();
            this.checkInterval = configuration.getIdleCheckInterval() * 1000L;
        }

        protected boolean doRun() {
            boolean w = Engine.this.writerPool.releaseInactive();
            boolean r = Engine.this.readerPool.releaseInactive();
            return w || r;
        }

        @Override
        protected boolean runSerially() {
            long t = this.clock.getTicks();
            if (this.last + this.checkInterval < t) {
                this.last = t;
                return this.doRun();
            }
            return false;
        }
    }
}

