/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.CairoException;
import com.questdb.cairo.ReadOnlyColumn;
import com.questdb.cairo.VirtualMemory;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.FilesFacade;
import com.questdb.std.str.LPSZ;

public class ReadOnlyMemory
extends VirtualMemory
implements ReadOnlyColumn {
    private static final Log LOG = LogFactory.getLog(ReadOnlyMemory.class);
    private FilesFacade ff;
    private long fd = -1L;
    private long size = 0L;
    private long lastPageSize;
    private int lastPageIndex;
    private long maxPageSize;

    public ReadOnlyMemory(FilesFacade ff, LPSZ name, long maxPageSize) {
        this.of(ff, name, maxPageSize);
    }

    public ReadOnlyMemory() {
    }

    @Override
    public void close() {
        super.close();
        if (this.fd != -1L) {
            this.ff.close(this.fd);
            LOG.info().$("closed [fd=").$(this.fd).$(']').$();
            this.fd = -1L;
        }
    }

    @Override
    protected long getPageAddress(int page) {
        long address = super.getPageAddress(page);
        if (address != 0L) {
            return address;
        }
        return this.mapPage(page);
    }

    @Override
    public void trackFileSize() {
        long size = this.ff.length(this.fd);
        if (size < this.size) {
            this.setInitialSize(size);
        } else if (size > this.size) {
            this.pages.ensureCapacity((int)(size / this.getMapPageSize() + 1L));
            if (this.lastPageSize < this.getMapPageSize()) {
                int lastIndex = this.pages.size() - 1;
                if (lastIndex > -1) {
                    long address = this.pages.getQuick(lastIndex);
                    if (address != 0L) {
                        this.release(lastIndex, address);
                        this.pages.setQuick(lastIndex, 0L);
                    }
                    this.clearHotPage();
                }
                this.lastPageIndex = 0;
                this.lastPageSize = this.getMapPageSize();
            }
            this.size = size;
        }
    }

    @Override
    protected long getPageSize(int page) {
        if (page == this.lastPageIndex) {
            return this.lastPageSize;
        }
        return super.getPageSize(page);
    }

    public void of(FilesFacade ff, LPSZ name, long maxPageSize) {
        this.close();
        this.ff = ff;
        boolean exists = ff.exists(name);
        if (!exists) {
            throw CairoException.instance(0).put("File not found: ").put(name);
        }
        this.fd = ff.openRO(name);
        if (this.fd == -1L) {
            throw CairoException.instance(ff.errno()).put("Cannot open file: ").put(name);
        }
        this.maxPageSize = maxPageSize;
        this.setInitialSize(ff.length(this.fd));
        LOG.info().$("open ").$(name).$(" [fd=").$(this.fd).$(']').$();
    }

    @Override
    protected void release(int page, long address) {
        if (address != 0L) {
            this.ff.munmap(address, this.getPageSize(page));
            if (page == this.lastPageIndex) {
                this.lastPageSize = this.getMapPageSize();
            }
        }
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    private long mapPage(int page) {
        long offset = this.pageOffset(page);
        long sz = this.size - offset;
        if (sz > 0L) {
            if (sz >= this.getMapPageSize()) {
                sz = this.getMapPageSize();
            } else {
                this.lastPageSize = sz;
                this.lastPageIndex = page;
            }
            long address = this.ff.mmap(this.fd, sz, offset, 1);
            if (address == -1L) {
                throw CairoException.instance(this.ff.errno()).put("Cannot mmap(read) fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(sz);
            }
            return this.cachePageAddress(page, address);
        }
        throw CairoException.instance(this.ff.errno()).put("Trying to map(read) page outside of file boundary. fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(sz);
    }

    private void setInitialSize(long size) {
        long targetPageSize = size > this.maxPageSize ? this.maxPageSize : Math.max(this.ff.getPageSize(), size / this.ff.getPageSize() * this.ff.getPageSize());
        if (targetPageSize != this.getMapPageSize()) {
            this.setPageSize(targetPageSize);
            this.pages.ensureCapacity((int)(size / this.getMapPageSize() + 1L));
            this.lastPageSize = targetPageSize < size ? targetPageSize : size;
        } else {
            this.lastPageSize = targetPageSize;
        }
        this.size = size;
    }
}

