/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.CairoException;
import com.questdb.cairo.VirtualMemory;
import com.questdb.std.FilesFacade;
import com.questdb.std.str.LPSZ;

public class ReadWriteMemory
extends VirtualMemory {
    private final FilesFacade ff;
    private long fd = -1L;
    private long size;

    public ReadWriteMemory(FilesFacade ff, LPSZ name, long maxPageSize, long size, long defaultPageSize) {
        this(ff);
        this.of(name, maxPageSize, size, defaultPageSize);
    }

    public ReadWriteMemory(FilesFacade ff) {
        this.ff = ff;
        this.size = 0L;
    }

    @Override
    public void close() {
        long size = this.size();
        super.close();
        if (this.fd != -1L) {
            this.ff.truncate(this.fd, size);
            this.ff.close(this.fd);
            this.fd = -1L;
        }
    }

    @Override
    public void jumpTo(long offset) {
        if (this.size < offset) {
            this.size = offset;
        }
        super.jumpTo(offset);
    }

    @Override
    protected long allocateNextPage(int page) {
        long address;
        long offset = this.pageOffset(page);
        long pageSize = this.getMapPageSize();
        if (this.ff.length(this.fd) < offset + pageSize) {
            this.ff.truncate(this.fd, offset + pageSize);
        }
        if ((address = this.ff.mmap(this.fd, pageSize, offset, 2)) == -1L) {
            throw CairoException.instance(this.ff.errno()).put("Cannot mmap(RW) fd=").put(this.fd).put(", offset").put(offset).put(", size").put(pageSize);
        }
        return address;
    }

    @Override
    protected long getPageAddress(int page) {
        return this.mapWritePage(page);
    }

    @Override
    protected void release(int page, long address) {
        this.ff.munmap(address, this.getPageSize(page));
    }

    public final void of(LPSZ name, long maxPageSize, long size, long defaultPageSize) {
        this.close();
        this.fd = this.ff.openRW(name);
        if (this.fd == -1L) {
            throw CairoException.instance(this.ff.errno()).put("Cannot open file: ").put(name);
        }
        this.configurePageSize(size, defaultPageSize, maxPageSize);
    }

    public long size() {
        if (this.size < this.getAppendOffset()) {
            this.size = this.getAppendOffset();
        }
        return this.size;
    }

    protected final void configurePageSize(long size, long defaultPageSize, long maxPageSize) {
        if (size > maxPageSize) {
            this.setPageSize(maxPageSize);
        } else {
            this.setPageSize(Math.max(defaultPageSize, size / this.ff.getPageSize() * this.ff.getPageSize()));
        }
        this.pages.ensureCapacity((int)(size / this.getMapPageSize() + 1L));
        this.size = size;
    }
}

