/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.CairoException;
import com.questdb.cairo.VirtualMemory;
import com.questdb.common.ColumnType;
import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.std.BinarySequence;
import com.questdb.std.Mutable;
import com.questdb.std.Unsafe;
import java.io.Closeable;

public class RecordChain
implements Closeable,
RecordCursor,
Mutable {
    private final long[] columnOffsets;
    private final VirtualMemory mem;
    private final int columnCount;
    private final RecordMetadata metadata;
    private final RecordChainRecord record = new RecordChainRecord();
    private final long varOffset;
    private final long fixOffset;
    private long recordOffset;
    private long varAppendOffset = 0L;
    private long nextRecordOffset = -1L;

    public RecordChain(RecordMetadata metadata, long pageSize) {
        this.mem = new VirtualMemory(pageSize);
        this.metadata = metadata;
        int count = metadata.getColumnCount();
        long varOffset = 0L;
        long fixOffset = 0L;
        this.columnOffsets = new long[count];
        block3: for (int i = 0; i < count; ++i) {
            int type = metadata.getColumnQuick(i).getType();
            switch (type) {
                case 7: 
                case 8: 
                case 9: {
                    this.columnOffsets[i] = varOffset;
                    varOffset += 8L;
                    continue block3;
                }
                default: {
                    this.columnOffsets[i] = fixOffset;
                    fixOffset += (long)ColumnType.sizeOf(type);
                }
            }
        }
        this.varOffset = varOffset;
        this.fixOffset = fixOffset;
        this.columnCount = count;
    }

    public long beginRecord(long prevOffset) {
        this.mem.jumpTo(this.varAppendOffset);
        this.mem.putLong(-1L);
        this.recordOffset = this.varAppendOffset;
        if (prevOffset != -1L) {
            this.mem.jumpTo(prevOffset);
            this.mem.putLong(this.recordOffset);
            this.mem.jumpTo(RecordChain.rowToDataOffset(this.recordOffset + this.varOffset));
        } else {
            this.mem.skip(this.varOffset);
        }
        this.varAppendOffset = RecordChain.rowToDataOffset(this.recordOffset + this.varOffset + this.fixOffset);
        return this.recordOffset;
    }

    @Override
    public void clear() {
        this.close();
    }

    @Override
    public void close() {
        this.mem.close();
        this.nextRecordOffset = -1L;
        this.varAppendOffset = 0L;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new RecordChainRecord();
    }

    @Override
    public StorageFacade getStorageFacade() {
        return null;
    }

    @Override
    public Record next() {
        long offset = this.nextRecordOffset;
        this.nextRecordOffset = this.mem.getLong(this.nextRecordOffset);
        return this.record.of(RecordChain.rowToDataOffset(offset));
    }

    public void putBin(BinarySequence value) {
        long offset = this.mem.getAppendOffset();
        if (value == null) {
            this.putNull(offset);
        } else {
            this.mem.jumpTo(RecordChain.rowToDataOffset(this.recordOffset));
            this.mem.putLong(this.varAppendOffset);
            this.recordOffset += 8L;
            this.mem.jumpTo(this.varAppendOffset);
            this.mem.putBin(value);
            this.varAppendOffset = this.mem.getAppendOffset();
            this.mem.jumpTo(offset);
        }
    }

    @Override
    public void releaseCursor() {
        this.close();
    }

    @Override
    public void toTop() {
        this.nextRecordOffset = this.mem.getAppendOffset() == 0L ? -1L : 0L;
    }

    @Override
    public boolean hasNext() {
        return this.nextRecordOffset != -1L;
    }

    public void putStr(CharSequence value) {
        long offset = this.mem.getAppendOffset();
        if (value == null) {
            this.putNull(offset);
        } else {
            this.mem.jumpTo(RecordChain.rowToDataOffset(this.recordOffset));
            this.mem.putLong(this.varAppendOffset);
            this.recordOffset += 8L;
            this.mem.jumpTo(this.varAppendOffset);
            this.mem.putStr(value);
            this.varAppendOffset = this.mem.getAppendOffset();
            this.mem.jumpTo(offset);
        }
    }

    @Override
    public Record recordAt(long row) {
        return this.record.of(RecordChain.rowToDataOffset(row));
    }

    public void putBool(boolean value) {
        this.mem.putBool(value);
    }

    public void putInt(int value) {
        this.mem.putInt(value);
    }

    public long putRecord(Record record, long prevRecordOffset) {
        long offset = this.beginRecord(prevRecordOffset);
        this.putRecord0(record);
        return offset;
    }

    @Override
    public void recordAt(Record record, long row) {
        ((RecordChainRecord)record).of(RecordChain.rowToDataOffset(row));
    }

    private static long rowToDataOffset(long row) {
        return row + 8L;
    }

    private void putByte(byte value) {
        this.mem.putByte(value);
    }

    private void putDate(long date) {
        this.putLong(date);
    }

    private void putDouble(double value) {
        this.mem.putDouble(value);
    }

    private void putFloat(float value) {
        this.mem.putFloat(value);
    }

    private void putLong(long value) {
        this.mem.putLong(value);
    }

    private void putNull(long offset) {
        this.mem.jumpTo(RecordChain.rowToDataOffset(this.recordOffset));
        this.mem.putLong(-1L);
        this.recordOffset += 8L;
        this.mem.jumpTo(offset);
    }

    private void putRecord0(Record record) {
        block13: for (int i = 0; i < this.columnCount; ++i) {
            switch (this.metadata.getColumnQuick(i).getType()) {
                case 0: {
                    this.putBool(record.getBool(i));
                    continue block13;
                }
                case 1: {
                    this.putByte(record.get(i));
                    continue block13;
                }
                case 2: {
                    this.putDouble(record.getDouble(i));
                    continue block13;
                }
                case 4: {
                    this.putInt(record.getInt(i));
                    continue block13;
                }
                case 5: {
                    this.putDate(record.getLong(i));
                    continue block13;
                }
                case 10: 
                case 12: {
                    this.putLong(record.getDate(i));
                    continue block13;
                }
                case 6: {
                    this.putShort(record.getShort(i));
                    continue block13;
                }
                case 8: {
                    this.putStr(record.getSym(i));
                    continue block13;
                }
                case 3: {
                    this.putFloat(record.getFloat(i));
                    continue block13;
                }
                case 7: {
                    this.putStr(record.getFlyweightStr(i));
                    continue block13;
                }
                case 9: {
                    this.putBin(record.getBin2(i));
                    continue block13;
                }
                default: {
                    throw CairoException.instance(0).put("Unsupported type: ").put(ColumnType.nameOf(this.metadata.getColumnQuick(i).getType())).put(" [").put(this.metadata.getColumnQuick(i).getType()).put(']');
                }
            }
        }
    }

    private void putShort(short value) {
        this.mem.putShort(value);
    }

    private class RecordChainRecord
    implements Record {
        long fixedOffset;
        long baseOffset;

        private RecordChainRecord() {
        }

        @Override
        public byte get(int col) {
            return RecordChain.this.mem.getByte(this.fixedWithColumnOffset(col));
        }

        @Override
        public BinarySequence getBin2(int col) {
            long offset = this.varWidthColumnOffset(col);
            return offset == -1L ? null : RecordChain.this.mem.getBin(offset);
        }

        @Override
        public long getBinLen(int col) {
            long offset = this.varWidthColumnOffset(col);
            return offset == -1L ? 0L : RecordChain.this.mem.getLong(offset);
        }

        @Override
        public boolean getBool(int col) {
            return RecordChain.this.mem.getBool(this.fixedWithColumnOffset(col));
        }

        @Override
        public long getDate(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col));
        }

        @Override
        public double getDouble(int col) {
            return RecordChain.this.mem.getDouble(this.fixedWithColumnOffset(col));
        }

        @Override
        public float getFloat(int col) {
            return RecordChain.this.mem.getFloat(this.fixedWithColumnOffset(col));
        }

        @Override
        public CharSequence getFlyweightStr(int col) {
            long offset = this.varWidthColumnOffset(col);
            return offset == -1L ? null : RecordChain.this.mem.getStr(offset);
        }

        @Override
        public CharSequence getFlyweightStrB(int col) {
            long offset = this.varWidthColumnOffset(col);
            return offset == -1L ? null : RecordChain.this.mem.getStr2(offset);
        }

        @Override
        public int getInt(int col) {
            return RecordChain.this.mem.getInt(this.fixedWithColumnOffset(col));
        }

        @Override
        public long getLong(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col));
        }

        @Override
        public long getRowId() {
            return this.baseOffset - 8L;
        }

        @Override
        public short getShort(int col) {
            return RecordChain.this.mem.getShort(this.fixedWithColumnOffset(col));
        }

        @Override
        public int getStrLen(int col) {
            long offset = this.varWidthColumnOffset(col);
            if (offset == -1L) {
                return 0;
            }
            return RecordChain.this.mem.getInt(offset);
        }

        @Override
        public CharSequence getSym(int col) {
            return this.getFlyweightStr(col);
        }

        private long fixedWithColumnOffset(int index) {
            return this.fixedOffset + Unsafe.arrayGet(RecordChain.this.columnOffsets, index);
        }

        private Record of(long offset) {
            this.baseOffset = offset;
            this.fixedOffset = offset + RecordChain.this.varOffset;
            return this;
        }

        private long varWidthColumnOffset(int index) {
            return RecordChain.this.mem.getLong(this.baseOffset + Unsafe.arrayGet(RecordChain.this.columnOffsets, index));
        }
    }
}

