/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.CairoException;
import com.questdb.cairo.NullColumn;
import com.questdb.cairo.ReadOnlyColumn;
import com.questdb.cairo.ReadOnlyMemory;
import com.questdb.cairo.TableReaderMetadata;
import com.questdb.cairo.TableUtils;
import com.questdb.common.NumericException;
import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.BinarySequence;
import com.questdb.std.Files;
import com.questdb.std.FilesFacade;
import com.questdb.std.LongList;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.Os;
import com.questdb.std.Rows;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.DateFormat;
import com.questdb.std.microtime.DateLocaleFactory;
import com.questdb.std.microtime.Dates;
import com.questdb.std.str.ImmutableCharSequence;
import com.questdb.std.str.NativeLPSZ;
import com.questdb.std.str.Path;
import java.io.Closeable;
import java.util.concurrent.locks.LockSupport;

public class TableReader
implements Closeable,
RecordCursor {
    private static final Log LOG = LogFactory.getLog(TableReader.class);
    private static final PartitionPathGenerator YEAR_GEN = (reader, partitionIndex) -> {
        TableUtils.fmtYear.format(Dates.addYear(reader.partitionMin, partitionIndex), DateLocaleFactory.INSTANCE.getDefaultDateLocale(), null, reader.path.put(Files.SEPARATOR));
        return reader.path.$();
    };
    private static final PartitionPathGenerator MONTH_GEN = (reader, partitionIndex) -> {
        TableUtils.fmtMonth.format(Dates.addMonths(reader.partitionMin, partitionIndex), DateLocaleFactory.INSTANCE.getDefaultDateLocale(), null, reader.path.put(Files.SEPARATOR));
        return reader.path.$();
    };
    private static final PartitionPathGenerator DAY_GEN = (reader, partitionIndex) -> {
        TableUtils.fmtDay.format(Dates.addDays(reader.partitionMin, partitionIndex), DateLocaleFactory.INSTANCE.getDefaultDateLocale(), null, reader.path.put(Files.SEPARATOR));
        return reader.path.$();
    };
    private static final PartitionPathGenerator DEFAULT_GEN = (reader, partitionIndex) -> reader.path.concat("default").$();
    private static final ReloadMethod PARTITIONED_RELOAD_METHOD = reader -> {
        assert (reader.timestampFloorMethod != null);
        long currentPartitionTimestamp = reader.timestampFloorMethod.floor(reader.maxTimestamp);
        boolean b = reader.readTxn();
        if (b) {
            assert (reader.intervalLengthMethod != null);
            int delta = (int)reader.intervalLengthMethod.calculate(currentPartitionTimestamp, reader.timestampFloorMethod.floor(reader.maxTimestamp));
            int partitionIndex = reader.partitionCount - 1;
            if (delta > 0) {
                reader.incrementPartitionCountBy(delta);
                Path path = reader.partitionPathGenerator.generate(reader, partitionIndex);
                try {
                    reader.reloadPartition(partitionIndex, TableReader.readPartitionSize(reader.ff, path.chopZ(), reader.tempMem8b));
                }
                finally {
                    path.trimTo(reader.rootLen);
                }
            } else {
                reader.reloadPartition(partitionIndex, reader.transientRowCount);
            }
            reader.reloadStruct();
            return true;
        }
        return false;
    };
    private static final ReloadMethod NON_PARTITIONED_RELOAD_METHOD = reader -> {
        if (reader.readTxn()) {
            reader.reloadPartition(0, reader.size);
            reader.reloadStruct();
            return true;
        }
        return false;
    };
    private final ColumnCopyStruct tempCopyStruct = new ColumnCopyStruct();
    private final FilesFacade ff;
    private final Path path;
    private final int rootLen;
    private final ReadOnlyMemory txMem;
    private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
    private final TableReaderMetadata metadata;
    private final LongList partitionSizes;
    private final TableRecord record = new TableRecord();
    private final PartitionPathGenerator partitionPathGenerator;
    private final ReloadMethod reloadMethod;
    private final TimestampFloorMethod timestampFloorMethod;
    private final IntervalLengthMethod intervalLengthMethod;
    private final CharSequence name;
    private LongList columnTops;
    private ObjList<ReadOnlyColumn> columns;
    private int columnCount;
    private int columnCountBits;
    private long transientRowCount;
    private long structVersion;
    private long prevStructVersion;
    private long size;
    private long txn = -1L;
    private long maxTimestamp;
    private int partitionCount;
    private long partitionMin;
    private long tempMem8b = Unsafe.malloc(8L);
    private int partitionIndex = 0;

    public TableReader(FilesFacade ff, CharSequence root, CharSequence name) {
        LOG.info().$("open '").utf8(name).$('\'').$();
        this.ff = ff;
        this.name = ImmutableCharSequence.of(name);
        this.path = new Path().of(root).concat(name);
        this.rootLen = this.path.length();
        try {
            this.failOnPendingTodo();
            this.txMem = this.openTxnFile();
            this.metadata = this.openMetaFile();
            this.columnCount = this.metadata.getColumnCount();
            this.columnCountBits = TableReader.getColumnBits(this.columnCount);
            this.readTxn();
            this.prevStructVersion = this.structVersion;
            switch (this.metadata.getPartitionBy()) {
                case 0: {
                    this.partitionPathGenerator = DAY_GEN;
                    this.reloadMethod = PARTITIONED_RELOAD_METHOD;
                    this.timestampFloorMethod = Dates::floorDD;
                    this.intervalLengthMethod = Dates::getDaysBetween;
                    this.partitionMin = this.findPartitionMinimum(TableUtils.fmtDay);
                    this.partitionCount = this.calculatePartitionCount();
                    break;
                }
                case 1: {
                    this.partitionPathGenerator = MONTH_GEN;
                    this.reloadMethod = PARTITIONED_RELOAD_METHOD;
                    this.timestampFloorMethod = Dates::floorMM;
                    this.intervalLengthMethod = Dates::getMonthsBetween;
                    this.partitionMin = this.findPartitionMinimum(TableUtils.fmtMonth);
                    this.partitionCount = this.calculatePartitionCount();
                    break;
                }
                case 2: {
                    this.partitionPathGenerator = YEAR_GEN;
                    this.reloadMethod = PARTITIONED_RELOAD_METHOD;
                    this.timestampFloorMethod = Dates::floorYYYY;
                    this.intervalLengthMethod = Dates::getYearsBetween;
                    this.partitionMin = this.findPartitionMinimum(TableUtils.fmtYear);
                    this.partitionCount = this.calculatePartitionCount();
                    break;
                }
                default: {
                    this.partitionPathGenerator = DEFAULT_GEN;
                    this.reloadMethod = NON_PARTITIONED_RELOAD_METHOD;
                    this.timestampFloorMethod = null;
                    this.intervalLengthMethod = null;
                    this.partitionCount = 1;
                }
            }
            int capacity = this.getColumnBase(this.partitionCount);
            this.columns = new ObjList(capacity);
            this.columns.setPos(capacity);
            this.partitionSizes = new LongList(this.partitionCount);
            this.partitionSizes.seed(this.partitionCount, -1L);
            this.columnTops = new LongList(capacity / 2);
            this.columnTops.setPos(capacity / 2);
        }
        catch (CairoException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            Misc.free(this.path);
            Misc.free(this.metadata);
            Misc.free(this.txMem);
            if (this.columns != null) {
                int n = this.columns.size();
                for (int i = 0; i < n; ++i) {
                    ReadOnlyColumn mem = this.columns.getQuick(i);
                    if (mem == null) continue;
                    mem.close();
                }
            }
            if (this.tempMem8b != 0L) {
                Unsafe.free(this.tempMem8b, 8L);
                this.tempMem8b = 0L;
            }
            LOG.info().$("closed '").utf8(this.name).$('\'').$();
        }
    }

    public void closeColumn(CharSequence columnName) {
        this.closeColumn(this.metadata.getColumnIndex(columnName));
    }

    public void closeColumn(int columnIndex) {
        assert (columnIndex > -1 && columnIndex < this.columnCount);
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = this.getColumnBase(partitionIndex);
            Misc.free(this.columns.getAndSetQuick(TableReader.getPrimaryColumnIndex(base, columnIndex), NullColumn.INSTANCE));
            Misc.free(this.columns.getAndSetQuick(TableReader.getSecondaryColumnIndex(base, columnIndex), NullColumn.INSTANCE));
        }
    }

    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public CharSequence getName() {
        return this.name;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new TableRecord();
    }

    @Override
    public StorageFacade getStorageFacade() {
        return null;
    }

    @Override
    public Record recordAt(long rowId) {
        this.record.columnBase = this.getColumnBase(Rows.toPartitionIndex(rowId));
        this.record.recordIndex = Rows.toLocalRowID(rowId);
        return this.record;
    }

    @Override
    public void recordAt(Record record, long rowId) {
        TableRecord rec = (TableRecord)record;
        rec.columnBase = this.getColumnBase(Rows.toPartitionIndex(rowId));
        rec.recordIndex = Rows.toLocalRowID(rowId);
    }

    @Override
    public void releaseCursor() {
    }

    @Override
    public void toTop() {
        this.partitionIndex = 0;
        this.record.maxRecordIndex = -1L;
        this.record.recordIndex = -1L;
    }

    @Override
    public boolean hasNext() {
        return this.record.recordIndex < this.record.maxRecordIndex || this.switchPartition();
    }

    @Override
    public Record next() {
        ++this.record.recordIndex;
        return this.record;
    }

    public boolean isOpen() {
        return this.tempMem8b != 0L;
    }

    public boolean reload() {
        return this.reloadMethod.reload(this);
    }

    public long size() {
        return this.size;
    }

    private static int getColumnBits(int columnCount) {
        return Numbers.msb(Numbers.ceilPow2(columnCount) * 2);
    }

    private static int getPrimaryColumnIndex(int base, int index) {
        return base + index * 2;
    }

    private static int getSecondaryColumnIndex(int base, int index) {
        return TableReader.getPrimaryColumnIndex(base, index) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readPartitionSize(FilesFacade ff, Path path, long tempMem) {
        int plen = path.length();
        try {
            if (ff.exists(path.concat("_archive").$())) {
                long fd = ff.openRO(path);
                if (fd == -1L) {
                    throw CairoException.instance(Os.errno()).put("Cannot open: ").put(path);
                }
                try {
                    if (ff.read(fd, tempMem, 8, 0L) != 8L) {
                        throw CairoException.instance(Os.errno()).put("Cannot read: ").put(path);
                    }
                    long l = Unsafe.getUnsafe().getLong(tempMem);
                    return l;
                }
                finally {
                    ff.close(fd);
                }
            }
            throw CairoException.instance(0).put("Doesn't exist: ").put(path);
        }
        finally {
            path.trimTo(plen);
        }
    }

    private static boolean isEntryToBeProcessed(long address, int index) {
        if (Unsafe.getUnsafe().getByte(address + (long)index) == -1) {
            return false;
        }
        Unsafe.getUnsafe().putByte(address + (long)index, (byte)-1);
        return true;
    }

    private int calculatePartitionCount() {
        if (this.partitionMin == Long.MAX_VALUE) {
            return 0;
        }
        return (int)(this.intervalLengthMethod.calculate(this.partitionMin, this.timestampFloorMethod.floor(this.maxTimestamp)) + 1L);
    }

    private void copyColumnsTo(ObjList<ReadOnlyColumn> columns, LongList columnTops, int base, int index) {
        if (this.tempCopyStruct.mem1 != null && !this.ff.exists(this.tempCopyStruct.mem1.getFd())) {
            Misc.free(this.tempCopyStruct.mem1);
            Misc.free(this.tempCopyStruct.mem2);
            this.fetchColumnsFrom(columns, columnTops, base, index);
            this.createColumnInstanceAt(this.path, columns, columnTops, index, base);
        } else {
            this.tempCopyStruct.mem1 = columns.getAndSetQuick(TableReader.getPrimaryColumnIndex(base, index), this.tempCopyStruct.mem1);
            this.tempCopyStruct.mem2 = columns.getAndSetQuick(TableReader.getSecondaryColumnIndex(base, index), this.tempCopyStruct.mem2);
            this.tempCopyStruct.top = columnTops.getAndSetQuick(base / 2 + index, this.tempCopyStruct.top);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createColumnInstanceAt(Path path, ObjList<ReadOnlyColumn> columns, LongList columnTops, int columnIndex, int columnBase) {
        int plen = path.length();
        try {
            String name = this.metadata.getColumnName(columnIndex);
            if (this.ff.exists(TableUtils.dFile(path.trimTo(plen), name))) {
                columns.setQuick(TableReader.getPrimaryColumnIndex(columnBase, columnIndex), new ReadOnlyMemory(this.ff, path, TableUtils.getMapPageSize(this.ff)));
                switch (this.metadata.getColumnQuick(columnIndex).getType()) {
                    case 7: 
                    case 8: 
                    case 9: {
                        columns.setQuick(TableReader.getSecondaryColumnIndex(columnBase, columnIndex), new ReadOnlyMemory(this.ff, TableUtils.iFile(path.trimTo(plen), name), TableUtils.getMapPageSize(this.ff)));
                        break;
                    }
                }
                columnTops.setQuick(columnBase / 2 + columnIndex, TableUtils.readColumnTop(this.ff, path.trimTo(plen), name, plen, this.tempMem8b));
            } else {
                columns.setQuick(TableReader.getPrimaryColumnIndex(columnBase, columnIndex), NullColumn.INSTANCE);
                columns.setQuick(TableReader.getSecondaryColumnIndex(columnBase, columnIndex), NullColumn.INSTANCE);
            }
        }
        finally {
            path.trimTo(plen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewColumnList(int columnCount, long address, int columnBits) {
        int capacity = this.partitionCount << columnBits;
        ObjList<ReadOnlyColumn> columns = new ObjList<ReadOnlyColumn>(capacity);
        LongList columnTops = new LongList();
        columns.setPos(capacity);
        columnTops.setPos(capacity / 2);
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = partitionIndex << columnBits;
            int oldBase = partitionIndex << this.columnCountBits;
            try {
                int i;
                Path path = this.partitionPathGenerator.generate(this, partitionIndex);
                for (i = 0; i < columnCount; ++i) {
                    int copyFrom = Unsafe.getUnsafe().getInt(address + (long)(i * 8)) - 1;
                    if (copyFrom > -1) {
                        this.fetchColumnsFrom(this.columns, this.columnTops, oldBase, copyFrom);
                        this.copyColumnsTo(columns, columnTops, base, i);
                        continue;
                    }
                    this.createColumnInstanceAt(path, columns, columnTops, i, base);
                }
                for (i = 0; i < this.columnCount; ++i) {
                    Misc.free(this.columns.getQuick(TableReader.getPrimaryColumnIndex(oldBase, i)));
                    Misc.free(this.columns.getQuick(TableReader.getSecondaryColumnIndex(oldBase, i)));
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        this.columns = columns;
        this.columnTops = columnTops;
        this.columnCountBits = columnBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReloadStruct() {
        long address = this.metadata.createTransitionIndex();
        try {
            this.metadata.applyTransitionIndex(address);
            int columnCount = Unsafe.getUnsafe().getInt(address + 4L);
            int columnCountBits = TableReader.getColumnBits(columnCount);
            if (columnCountBits > this.columnCountBits) {
                this.createNewColumnList(columnCount, address + 8L, columnCountBits);
            } else {
                this.reshuffleExistingColumnList(columnCount, address + 8L, address + 8L + (long)(columnCount * 8));
            }
            this.columnCount = columnCount;
        }
        finally {
            TableReaderMetadata.freeTransitionIndex(address);
        }
    }

    private void failOnPendingTodo() {
        try {
            if (this.ff.exists(this.path.concat("_todo").$())) {
                throw CairoException.instance(0).put("Table ").put(this.path.$()).put(" is pending recovery.");
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void fetchColumnsFrom(ObjList<ReadOnlyColumn> columns, LongList columnTops, int base, int index) {
        this.tempCopyStruct.mem1 = columns.getAndSetQuick(TableReader.getPrimaryColumnIndex(base, index), null);
        this.tempCopyStruct.mem2 = columns.getAndSetQuick(TableReader.getSecondaryColumnIndex(base, index), null);
        this.tempCopyStruct.top = columnTops.getQuick(base / 2 + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findPartitionMinimum(DateFormat partitionDirFmt) {
        long partitionMin;
        block9: {
            partitionMin = Long.MAX_VALUE;
            try {
                long p = this.ff.findFirst(this.path.$());
                if (p <= 0L) break block9;
                try {
                    do {
                        int type;
                        if ((type = this.ff.findType(p)) != 4 && type != 10) continue;
                        try {
                            long time = partitionDirFmt.parse(this.nativeLPSZ.of(this.ff.findName(p)), DateLocaleFactory.INSTANCE.getDefaultDateLocale());
                            if (time >= partitionMin) continue;
                            partitionMin = time;
                        }
                        catch (NumericException numericException) {
                            // empty catch block
                        }
                    } while (this.ff.findNext(p) > 0);
                }
                finally {
                    this.ff.findClose(p);
                }
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        return partitionMin;
    }

    private int getColumnBase(int partitionIndex) {
        return partitionIndex << this.columnCountBits;
    }

    private void incrementPartitionCountBy(int delta) {
        this.partitionSizes.seed(this.partitionCount, delta, -1L);
        this.partitionCount += delta;
        int capacity = this.getColumnBase(this.partitionCount);
        this.columns.setPos(capacity);
        this.columnTops.setPos(capacity / 2);
    }

    private TableReaderMetadata openMetaFile() {
        try {
            TableReaderMetadata tableReaderMetadata = new TableReaderMetadata(this.ff, this.path.concat("_meta").$());
            return tableReaderMetadata;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long openPartition(int partitionIndex, int columnBase, boolean last) {
        try {
            long partitionSize;
            Path path = this.partitionPathGenerator.generate(this, partitionIndex);
            if (this.ff.exists(path)) {
                path.chopZ();
                partitionSize = last ? this.transientRowCount : TableReader.readPartitionSize(this.ff, path, this.tempMem8b);
                LOG.info().$("open partition ").$(path.$()).$(" [size=").$(partitionSize).$(']').$();
                if (partitionSize > 0L) {
                    this.openPartitionColumns(path, columnBase);
                }
            } else {
                partitionSize = 0L;
            }
            this.partitionSizes.setQuick(partitionIndex, partitionSize);
            long l = partitionSize;
            return l;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void openPartitionColumns(Path path, int columnBase) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns.getQuick(TableReader.getPrimaryColumnIndex(columnBase, i)) != null) continue;
            this.createColumnInstanceAt(path, this.columns, this.columnTops, i, columnBase);
        }
    }

    private ReadOnlyMemory openTxnFile() {
        try {
            ReadOnlyMemory readOnlyMemory = new ReadOnlyMemory(this.ff, this.path.concat("_txn").$(), this.ff.getPageSize());
            return readOnlyMemory;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private boolean readTxn() {
        long structVersion;
        long maxTimestamp;
        long fixedRowCount;
        long transientRowCount;
        long txn;
        while (true) {
            if ((txn = this.txMem.getLong(0L)) == this.txn) {
                return false;
            }
            Unsafe.getUnsafe().loadFence();
            transientRowCount = this.txMem.getLong(8L);
            fixedRowCount = this.txMem.getLong(16L);
            maxTimestamp = this.txMem.getLong(24L);
            structVersion = this.txMem.getLong(32L);
            Unsafe.getUnsafe().loadFence();
            if (txn == this.txMem.getLong(0L)) break;
            LockSupport.parkNanos(1L);
        }
        this.txn = txn;
        this.transientRowCount = transientRowCount;
        this.size = fixedRowCount + transientRowCount;
        this.maxTimestamp = maxTimestamp;
        this.structVersion = structVersion;
        return true;
    }

    private void reloadPartition(int partitionIndex, long size) {
        if (this.partitionSizes.getQuick(partitionIndex) > -1L) {
            int columnBase = this.getColumnBase(partitionIndex);
            for (int i = 0; i < this.columnCount; ++i) {
                this.columns.getQuick(TableReader.getPrimaryColumnIndex(columnBase, i)).trackFileSize();
                ReadOnlyColumn mem2 = this.columns.getQuick(TableReader.getSecondaryColumnIndex(columnBase, i));
                if (mem2 == null) continue;
                mem2.trackFileSize();
            }
            this.partitionSizes.setQuick(partitionIndex, size);
        }
    }

    private void reloadStruct() {
        if (this.prevStructVersion != this.structVersion) {
            this.doReloadStruct();
            this.prevStructVersion = this.structVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reshuffleExistingColumnList(int columnCount, long address, long stateAddress) {
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = this.getColumnBase(partitionIndex);
            try {
                Path path = this.partitionPathGenerator.generate(this, partitionIndex);
                Unsafe.getUnsafe().setMemory(stateAddress, columnCount, (byte)0);
                for (int i = 0; i < columnCount; ++i) {
                    int copyFrom;
                    if (!TableReader.isEntryToBeProcessed(stateAddress, i) || (copyFrom = Unsafe.getUnsafe().getInt(address + (long)(i * 8)) - 1) == i) continue;
                    if (copyFrom > -1) {
                        this.fetchColumnsFrom(this.columns, this.columnTops, base, copyFrom);
                        this.copyColumnsTo(this.columns, this.columnTops, base, i);
                        int copyTo = Unsafe.getUnsafe().getInt(address + (long)(i * 8) + 4L) - 1;
                        while (copyTo > -1 && TableReader.isEntryToBeProcessed(stateAddress, copyTo)) {
                            this.copyColumnsTo(this.columns, this.columnTops, base, copyTo);
                            copyTo = Unsafe.getUnsafe().getInt(address + (long)((copyTo - 1) * 8) + 4L);
                        }
                        Misc.free(this.tempCopyStruct.mem1);
                        Misc.free(this.tempCopyStruct.mem2);
                        continue;
                    }
                    this.createColumnInstanceAt(path, this.columns, this.columnTops, i, base);
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private boolean switchPartition() {
        while (this.partitionIndex < this.partitionCount) {
            int columnBase = this.getColumnBase(this.partitionIndex);
            long partitionSize = this.partitionSizes.getQuick(this.partitionIndex);
            if (partitionSize == -1L) {
                partitionSize = this.openPartition(this.partitionIndex++, columnBase, this.partitionIndex == this.partitionCount);
            } else {
                ++this.partitionIndex;
            }
            if (partitionSize == 0L) continue;
            this.record.maxRecordIndex = partitionSize - 1L;
            this.record.recordIndex = -1L;
            this.record.columnBase = columnBase;
            return true;
        }
        return false;
    }

    private class TableRecord
    implements Record {
        protected int columnBase;
        protected long recordIndex = 0L;
        protected long maxRecordIndex = -1L;

        private TableRecord() {
        }

        @Override
        public byte get(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return 0;
            }
            return this.colA(col).getByte(index);
        }

        @Override
        public BinarySequence getBin2(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return null;
            }
            return this.colA(col).getBin(this.colB(col).getLong(index * 8L));
        }

        @Override
        public long getBinLen(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return -1L;
            }
            return this.colA(col).getBinLen(this.colB(col).getLong(index * 8L));
        }

        @Override
        public boolean getBool(int col) {
            long index = this.getIndex(col);
            return index >= 0L && this.colA(col).getBool(index);
        }

        @Override
        public long getDate(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return Long.MIN_VALUE;
            }
            return this.colA(col).getLong(index * 8L);
        }

        @Override
        public double getDouble(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return Double.NaN;
            }
            return this.colA(col).getDouble(index * 8L);
        }

        @Override
        public float getFloat(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return Float.NaN;
            }
            return this.colA(col).getFloat(index * 4L);
        }

        @Override
        public CharSequence getFlyweightStr(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return null;
            }
            return this.colA(col).getStr(this.colB(col).getLong(index * 8L));
        }

        @Override
        public CharSequence getFlyweightStrB(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return null;
            }
            return this.colA(col).getStr2(this.colB(col).getLong(index * 8L));
        }

        @Override
        public int getInt(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return Integer.MIN_VALUE;
            }
            return this.colA(col).getInt(index * 4L);
        }

        @Override
        public long getLong(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return Long.MIN_VALUE;
            }
            return this.colA(col).getLong(index * 8L);
        }

        @Override
        public long getRowId() {
            return Rows.toRowID(this.columnBase >>> TableReader.this.columnCountBits, this.recordIndex);
        }

        @Override
        public short getShort(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return 0;
            }
            return this.colA(col).getShort(index * 2L);
        }

        @Override
        public int getStrLen(int col) {
            long index = this.getIndex(col);
            if (index < 0L) {
                return -1;
            }
            return this.colA(col).getStrLen(this.colB(col).getLong(index * 8L));
        }

        @Override
        public CharSequence getSym(int col) {
            return this.getFlyweightStr(col);
        }

        private ReadOnlyColumn colA(int col) {
            return (ReadOnlyColumn)TableReader.this.columns.getQuick(this.columnBase + col * 2);
        }

        private ReadOnlyColumn colB(int col) {
            return (ReadOnlyColumn)TableReader.this.columns.getQuick(this.columnBase + col * 2 + 1);
        }

        private long getIndex(int col) {
            assert (col > -1 && col < TableReader.this.columnCount) : "Column index out of bounds: " + col + " >= " + TableReader.access$400(TableReader.this);
            long top = TableReader.this.columnTops.getQuick(this.columnBase / 2 + col);
            return top > 0L ? this.recordIndex - top : this.recordIndex;
        }
    }

    private static class ColumnCopyStruct {
        ReadOnlyColumn mem1;
        ReadOnlyColumn mem2;
        long top;

        private ColumnCopyStruct() {
        }
    }

    @FunctionalInterface
    private static interface PartitionPathGenerator {
        public Path generate(TableReader var1, int var2);
    }

    @FunctionalInterface
    private static interface ReloadMethod {
        public boolean reload(TableReader var1);
    }

    @FunctionalInterface
    private static interface TimestampFloorMethod {
        public long floor(long var1);
    }

    @FunctionalInterface
    private static interface IntervalLengthMethod {
        public long calculate(long var1, long var3);
    }
}

