/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.CairoException;
import com.questdb.cairo.ReadOnlyMemory;
import com.questdb.cairo.TableColumnMetadata;
import com.questdb.cairo.TableUtils;
import com.questdb.common.AbstractRecordMetadata;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.FilesFacade;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.str.Path;
import java.io.Closeable;

class TableReaderMetadata
extends AbstractRecordMetadata
implements Closeable {
    private final ObjList<TableColumnMetadata> columnMetadata;
    private final CharSequenceIntHashMap columnNameIndexMap = new CharSequenceIntHashMap();
    private final ReadOnlyMemory metaMem;
    private final Path path;
    private final FilesFacade ff;
    private final CharSequenceIntHashMap tmpValidationMap = new CharSequenceIntHashMap();
    private int timestampIndex;
    private int columnCount;
    private ReadOnlyMemory transitionMeta;

    public TableReaderMetadata(FilesFacade ff, Path path) {
        this.ff = ff;
        this.path = new Path().of(path).$();
        try {
            this.metaMem = new ReadOnlyMemory(ff, path, ff.getPageSize());
            TableUtils.validate(ff, this.metaMem, this.columnNameIndexMap);
            this.timestampIndex = this.metaMem.getInt(8L);
            this.columnCount = this.metaMem.getInt(0L);
            this.columnMetadata = new ObjList(this.columnCount);
            long offset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence name = this.metaMem.getStr(offset);
                int index = this.columnNameIndexMap.keyIndex(name);
                this.columnMetadata.add(new TableColumnMetadata(this.columnNameIndexMap.keyAt(index).toString(), TableUtils.getColumnType(this.metaMem, i)));
                offset += (long)ReadOnlyMemory.getStorageLength(name);
            }
        }
        catch (CairoException e) {
            this.close();
            throw e;
        }
    }

    public static void freeTransitionIndex(long address) {
        if (address == 0L) {
            return;
        }
        Unsafe.free(address, Unsafe.getUnsafe().getInt(address));
    }

    public void applyTransitionIndex(long address) {
        this.metaMem.of(this.ff, this.path, this.ff.getPageSize());
        this.columnNameIndexMap.clear();
        int columnCount = Unsafe.getUnsafe().getInt(address + 4L);
        long index = address + 8L;
        long stateAddress = index + (long)(columnCount * 8);
        boolean timestampRequired = true;
        if (columnCount > this.columnCount) {
            this.columnMetadata.setPos(columnCount);
            this.columnCount = columnCount;
        }
        Unsafe.getUnsafe().setMemory(stateAddress, columnCount, (byte)0);
        for (int i = 0; i < columnCount; ++i) {
            if (Unsafe.getUnsafe().getByte(stateAddress + (long)i) == -1) continue;
            Unsafe.getUnsafe().putByte(stateAddress + (long)i, (byte)-1);
            int copyFrom = Unsafe.getUnsafe().getInt(index + (long)(i * 8));
            if (copyFrom == i + 1) {
                this.columnNameIndexMap.put(this.columnMetadata.getQuick(i).getName(), i);
                continue;
            }
            if (copyFrom > 0) {
                TableColumnMetadata tmp = this.moveMetadata(copyFrom - 1, null);
                this.columnNameIndexMap.put(tmp.getName(), i);
                tmp = this.moveMetadata(i, tmp);
                if (copyFrom - 1 == this.timestampIndex && timestampRequired) {
                    this.timestampIndex = i;
                    timestampRequired = false;
                }
                int copyTo = Unsafe.getUnsafe().getInt(index + (long)(i * 8) + 4L);
                while (copyTo > 0 && Unsafe.getUnsafe().getByte(stateAddress + (long)copyTo - 1L) != -1) {
                    Unsafe.getUnsafe().putByte(stateAddress + (long)copyTo - 1L, (byte)-1);
                    this.columnNameIndexMap.put(tmp.getName(), copyTo - 1);
                    tmp = this.moveMetadata(copyTo - 1, tmp);
                    copyFrom = copyTo;
                    copyTo = Unsafe.getUnsafe().getInt(index + (long)((copyTo - 1) * 8) + 4L);
                    if (copyFrom - 1 != this.timestampIndex || !timestampRequired) continue;
                    this.timestampIndex = copyTo - 1;
                    timestampRequired = false;
                }
                if (tmp == null || i != this.timestampIndex || !timestampRequired) continue;
                this.timestampIndex = -1;
                timestampRequired = false;
                continue;
            }
            TableColumnMetadata m = this.newInstance(i, columnCount);
            this.moveMetadata(i, m);
            this.columnNameIndexMap.put(m.getName(), i);
        }
        if (columnCount < this.columnCount) {
            if (this.timestampIndex >= columnCount && timestampRequired) {
                this.timestampIndex = -1;
            }
            this.columnMetadata.setPos(columnCount);
            this.columnCount = columnCount;
        }
    }

    @Override
    public void close() {
        Misc.free(this.metaMem);
        Misc.free(this.path);
    }

    public long createTransitionIndex() {
        if (this.transitionMeta == null) {
            this.transitionMeta = new ReadOnlyMemory();
        }
        this.transitionMeta.of(this.ff, this.path, this.ff.getPageSize());
        try (ReadOnlyMemory metaMem = this.transitionMeta;){
            long address;
            this.tmpValidationMap.clear();
            TableUtils.validate(this.ff, metaMem, this.tmpValidationMap);
            int columnCount = metaMem.getInt(0L);
            int n = Math.max(this.columnCount, columnCount);
            int size = n * 16;
            long index = address = Unsafe.malloc(size);
            Unsafe.getUnsafe().setMemory(address, size, (byte)0);
            Unsafe.getUnsafe().putInt(index, size);
            Unsafe.getUnsafe().putInt(index + 4L, columnCount);
            index += 8L;
            long offset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence name = metaMem.getStr(offset);
                offset += (long)ReadOnlyMemory.getStorageLength(name);
                int oldPosition = this.columnNameIndexMap.get(name);
                if (oldPosition > -1 && TableUtils.getColumnType(metaMem, i) == TableUtils.getColumnType(this.metaMem, oldPosition)) {
                    Unsafe.getUnsafe().putInt(index + (long)(i * 8), oldPosition + 1);
                    Unsafe.getUnsafe().putInt(index + (long)(oldPosition * 8) + 4L, i + 1);
                    continue;
                }
                Unsafe.getUnsafe().putLong(index + (long)(i * 8), 0L);
            }
            long l = address;
            return l;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getColumnIndexQuiet(CharSequence name) {
        return this.columnNameIndexMap.get(name);
    }

    @Override
    public RecordColumnMetadata getColumnQuick(int index) {
        return this.columnMetadata.getQuick(index);
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    public int getPartitionBy() {
        return this.metaMem.getInt(4L);
    }

    private TableColumnMetadata moveMetadata(int index, TableColumnMetadata metadata) {
        return this.columnMetadata.getAndSetQuick(index, metadata);
    }

    private TableColumnMetadata newInstance(int index, int columnCount) {
        long offset = TableUtils.getColumnNameOffset(columnCount);
        CharSequence name = null;
        for (int i = 0; i <= index; ++i) {
            name = this.metaMem.getStr(offset);
            offset += (long)ReadOnlyMemory.getStorageLength(name);
        }
        assert (name != null);
        return new TableColumnMetadata(name.toString(), TableUtils.getColumnType(this.metaMem, index));
    }
}

