/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AppendMemory;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.ReadOnlyMemory;
import com.questdb.cairo.VirtualMemory;
import com.questdb.common.ColumnType;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Files;
import com.questdb.std.FilesFacade;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.DateFormat;
import com.questdb.std.microtime.DateFormatCompiler;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.store.factory.configuration.JournalMetadata;

public final class TableUtils {
    public static final int TABLE_EXISTS = 0;
    public static final int TABLE_DOES_NOT_EXIST = 1;
    public static final int TABLE_RESERVED = 2;
    public static final String META_FILE_NAME = "_meta";
    public static final String TXN_FILE_NAME = "_txn";
    static final byte TODO_RESTORE_META = 2;
    static final byte TODO_TRUNCATE = 1;
    static final long META_OFFSET_COLUMN_TYPES = 12L;
    static final DateFormat fmtDay;
    static final DateFormat fmtMonth;
    static final DateFormat fmtYear;
    static final String ARCHIVE_FILE_NAME = "_archive";
    static final String DEFAULT_PARTITION_NAME = "default";
    static final long TX_OFFSET_TXN = 0L;
    static final long TX_OFFSET_TRANSIENT_ROW_COUNT = 8L;
    static final long TX_OFFSET_FIXED_ROW_COUNT = 16L;
    static final long TX_OFFSET_MAX_TIMESTAMP = 24L;
    static final long TX_OFFSET_STRUCT_VERSION = 32L;
    static final long TX_EOF = 40L;
    static final String META_SWAP_FILE_NAME = "_meta.swp";
    static final String META_PREV_FILE_NAME = "_meta.prev";
    static final String TODO_FILE_NAME = "_todo";
    static final long META_OFFSET_COUNT = 0L;
    static final long META_OFFSET_PARTITION_BY = 4L;
    static final long META_OFFSET_TIMESTAMP_INDEX = 8L;
    private static final int _16M = 0x1000000;
    private static final Log LOG;

    public static void create(FilesFacade ff, Path path, AppendMemory memory, CharSequence root, JournalMetadata metadata, int mode) {
        path.of(root).concat(metadata.getName());
        int rootLen = path.length();
        if (ff.mkdirs(path.put(Files.SEPARATOR).$(), mode) == -1) {
            throw CairoException.instance(ff.errno()).put("Cannot create dir: ").put(path);
        }
        try (AppendMemory mem = memory;){
            int i;
            mem.of(ff, path.trimTo(rootLen).concat(META_FILE_NAME).$(), ff.getPageSize());
            int count = metadata.getColumnCount();
            mem.putInt(count);
            mem.putInt(metadata.getPartitionBy());
            mem.putInt(metadata.getTimestampIndex());
            for (i = 0; i < count; ++i) {
                mem.putInt(metadata.getColumnQuick((int)i).type);
            }
            for (i = 0; i < count; ++i) {
                mem.putStr(metadata.getColumnQuick((int)i).name);
            }
            mem.of(ff, path.trimTo(rootLen).concat(TXN_FILE_NAME).$(), ff.getPageSize());
            TableUtils.resetTxn(mem);
        }
    }

    public static int exists(FilesFacade ff, Path path, CharSequence root, CharSequence name) {
        path.of(root).concat(name).$();
        if (ff.exists(path)) {
            if (ff.exists(path.chopZ().concat(TXN_FILE_NAME).$())) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public static long getColumnNameOffset(int columnCount) {
        return 12L + (long)(columnCount * 4);
    }

    public static long lock(FilesFacade ff, Path path) {
        long fd = ff.openRW(path.put(".lock").$());
        if (fd == -1L) {
            LOG.error().$("cannot open '").$(path).$("' to lock [errno=").$(ff.errno()).$(']').$();
            return -1L;
        }
        if (ff.lock(fd) != 0) {
            LOG.error().$("cannot lock '").$(path).$("' [errno=").$(ff.errno()).$(", fd=").$(fd).$(']').$();
            ff.close(fd);
            return -1L;
        }
        return fd;
    }

    public static void resetTxn(VirtualMemory txMem) {
        txMem.putLong(-1L);
        txMem.putLong(0L);
        txMem.putLong(0L);
        txMem.putLong(Long.MIN_VALUE);
        txMem.putLong(0L);
        Unsafe.getUnsafe().storeFence();
        txMem.jumpTo(0L);
        txMem.putLong(0L);
        Unsafe.getUnsafe().storeFence();
        txMem.jumpTo(40L);
    }

    public static void validate(FilesFacade ff, ReadOnlyMemory metaMem, CharSequenceIntHashMap nameIndex) {
        try {
            int i;
            int timestampType;
            int timestampIndex = metaMem.getInt(8L);
            int columnCount = metaMem.getInt(0L);
            long offset = TableUtils.getColumnNameOffset(columnCount);
            if (offset < (long)columnCount || columnCount > 0 && (offset < 0L || offset >= ff.length(metaMem.getFd()))) {
                throw TableUtils.validationException(metaMem).put("Incorrect columnCount: ").put(columnCount);
            }
            if (timestampIndex < -1 || timestampIndex >= columnCount) {
                throw TableUtils.validationException(metaMem).put("Timestamp index is outside of columnCount");
            }
            if (timestampIndex != -1 && (timestampType = TableUtils.getColumnType(metaMem, timestampIndex)) != 12) {
                throw TableUtils.validationException(metaMem).put("Timestamp column must be TIMESTAMP, but found ").put(ColumnType.nameOf(timestampType));
            }
            for (i = 0; i < columnCount; ++i) {
                int type = TableUtils.getColumnType(metaMem, i);
                if (ColumnType.sizeOf(type) != -1) continue;
                throw TableUtils.validationException(metaMem).put("Invalid column type ").put(type).put(" at [").put(i).put(']');
            }
            for (i = 0; i < columnCount; ++i) {
                CharSequence name = metaMem.getStr(offset);
                if (name == null || name.length() < 1) {
                    throw TableUtils.validationException(metaMem).put("NULL column name at [").put(i).put(']');
                }
                String s = name.toString();
                if (!nameIndex.put(s, i)) {
                    throw TableUtils.validationException(metaMem).put("Duplicate column: ").put(s).put(" at [").put(i).put(']');
                }
                offset += (long)ReadOnlyMemory.getStorageLength(name);
            }
        }
        catch (CairoException e) {
            nameIndex.clear();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readColumnTop(FilesFacade ff, Path path, CharSequence name, int plen, long buf) {
        try {
            if (ff.exists(TableUtils.topFile(path.chopZ(), name))) {
                long fd = ff.openRO(path);
                try {
                    if (ff.read(fd, buf, 8, 0L) != 8L) {
                        throw CairoException.instance(Os.errno()).put("Cannot read top of column ").put(path);
                    }
                    long l = Unsafe.getUnsafe().getLong(buf);
                    return l;
                }
                finally {
                    ff.close(fd);
                }
            }
            long l = 0L;
            return l;
        }
        finally {
            path.trimTo(plen);
        }
    }

    static LPSZ dFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".d").$();
    }

    static LPSZ topFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".top").$();
    }

    static LPSZ iFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".i").$();
    }

    static long getMapPageSize(FilesFacade ff) {
        long pageSize = ff.getPageSize() * ff.getPageSize();
        if (pageSize < ff.getPageSize() || pageSize > 0x1000000L) {
            if (0x1000000L % ff.getPageSize() == 0L) {
                return 0x1000000L;
            }
            return ff.getPageSize();
        }
        return pageSize;
    }

    static int getColumnType(ReadOnlyMemory metaMem, int columnIndex) {
        return metaMem.getInt(12L + (long)(columnIndex * 4));
    }

    static int openMetaSwapFile(FilesFacade ff, AppendMemory mem, Path path, int rootLen, int retryCount) {
        try {
            path.concat(META_SWAP_FILE_NAME).$();
            int l = path.length();
            int index = 0;
            while (true) {
                if (index > 0) {
                    path.trimTo(l).put('.').put(index);
                    path.$();
                }
                if (!ff.exists(path) || ff.remove(path)) {
                    try {
                        mem.of(ff, path, ff.getPageSize());
                        int n = index;
                        return n;
                    }
                    catch (CairoException e) {
                        LOG.error().$("Cannot open file: ").$(path).$('[').$(Os.errno()).$(']').$();
                        continue;
                    }
                }
                LOG.error().$("Cannot remove file: ").$(path).$('[').$(Os.errno()).$(']').$();
                {
                    if (++index < retryCount) continue;
                    throw CairoException.instance(0).put("Cannot open indexed file. Max number of attempts reached [").put(index).put("]. Last file tried: ").put(path);
                }
                break;
            }
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    static String getTodoText(long code) {
        switch ((int)(code & 0xFFL)) {
            case 1: {
                return "truncate";
            }
            case 2: {
                return "restore meta";
            }
        }
        return "unknown";
    }

    private static CairoException validationException(ReadOnlyMemory mem) {
        return CairoException.instance(0).put("Invalid metadata at fd=").put(mem.getFd()).put(". ");
    }

    static {
        LOG = LogFactory.getLog(TableUtils.class);
        DateFormatCompiler compiler = new DateFormatCompiler();
        fmtDay = compiler.compile("yyyy-MM-dd");
        fmtMonth = compiler.compile("yyyy-MM");
        fmtYear = compiler.compile("yyyy");
    }
}

