/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AppendMemory;
import com.questdb.cairo.CairoError;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.ReadOnlyMemory;
import com.questdb.cairo.ReadWriteMemory;
import com.questdb.cairo.RowFunction;
import com.questdb.cairo.TableUtils;
import com.questdb.cairo.TableWriterMetadata;
import com.questdb.cairo.VirtualMemory;
import com.questdb.common.ColumnType;
import com.questdb.common.NumericException;
import com.questdb.common.RecordMetadata;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.FilesFacade;
import com.questdb.std.LongList;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.DateFormat;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.microtime.DateLocaleFactory;
import com.questdb.std.microtime.Dates;
import com.questdb.std.str.ImmutableCharSequence;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.NativeLPSZ;
import com.questdb.std.str.Path;
import java.io.Closeable;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.NotNull;

public class TableWriter
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TableWriter.class);
    private static final CharSequenceHashSet ignoredFiles = new CharSequenceHashSet();
    private static final Runnable NOOP = () -> {};
    final ObjList<AppendMemory> columns;
    private final Path path;
    private final Path other;
    private final LongList refs = new LongList();
    private final Row row = new Row();
    private final int rootLen;
    private final ReadWriteMemory txMem;
    private final ReadOnlyMemory metaMem;
    private final VirtualMemory columnSizeMem;
    private final int partitionBy;
    private final RowFunction switchPartitionFunction = new SwitchPartitionRowFunction();
    private final RowFunction openPartitionFunction = new OpenPartitionRowFunction();
    private final RowFunction noPartitionFunction = new NoPartitionFunction();
    private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
    private final LongList columnTops;
    private final FilesFacade ff;
    private final DateFormat partitionDirFmt;
    private final AppendMemory ddlMem;
    private final int mkDirMode;
    private final int fileOperationRetryCount;
    private final CharSequence name;
    private final TableWriterMetadata metadata;
    private final Runnable MY_OPEN_META = this::openMetaFile;
    int txPartitionCount = 0;
    private long lockFd = -1L;
    private LongConsumer timestampSetter;
    private int columnCount;
    private ObjList<Runnable> nullers = new ObjList();
    private long fixedRowCount = 0L;
    private long txn;
    private long structVersion;
    private RowFunction rowFunction = this.openPartitionFunction;
    private long prevTimestamp;
    private long prevTransientRowCount;
    private long maxTimestamp;
    private long partitionLo;
    private long partitionHi;
    private long transientRowCount = 0L;
    private long masterRef = 0L;
    private boolean removeDirOnCancelRow = true;
    private long tempMem8b = Unsafe.malloc(8L);
    private int metaSwapIndex;
    private int metaPrevIndex;

    public TableWriter(FilesFacade ff, CharSequence root, CharSequence name) {
        this(ff, root, name, 509, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableWriter(FilesFacade ff, CharSequence root, CharSequence name, int mkDirMode, int fileOperationRetryCount) {
        LOG.info().$("open '").utf8(name).$('\'').$();
        this.ff = ff;
        this.mkDirMode = mkDirMode;
        this.fileOperationRetryCount = fileOperationRetryCount;
        this.path = new Path().of(root).concat(name);
        this.other = new Path().of(root).concat(name);
        this.name = ImmutableCharSequence.of(name);
        this.rootLen = this.path.length();
        try {
            try {
                this.lockFd = TableUtils.lock(ff, this.path);
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
            if (this.lockFd == -1L) {
                throw CairoException.instance(ff.errno()).put("Cannot lock table: ").put(this.path.$());
            }
            this.txMem = this.openTxnFile();
            this.txMem.jumpTo(40L);
            long todo = this.readTodoTaskCode();
            if (todo != -1L) {
                switch ((int)(todo & 0xFFL)) {
                    case 1: {
                        this.repairTruncate();
                        break;
                    }
                    case 2: {
                        this.repairMetaRename((int)(todo >> 8));
                        break;
                    }
                    default: {
                        LOG.error().$("ignoring unknown *todo* code: ").$(todo).$();
                    }
                }
            }
            this.ddlMem = new AppendMemory();
            this.metaMem = new ReadOnlyMemory();
            this.openMetaFile();
            this.metadata = new TableWriterMetadata(ff, this.metaMem);
            this.columnCount = this.metadata.getColumnCount();
            this.partitionBy = this.metaMem.getInt(4L);
            this.columnSizeMem = new VirtualMemory(ff.getPageSize());
            this.refs.extendAndSet(this.columnCount, 0L);
            this.columns = new ObjList(this.columnCount);
            this.nullers = new ObjList(this.columnCount);
            this.columnTops = new LongList(this.columnCount);
            this.partitionDirFmt = TableWriter.selectPartitionDirFmt(this.partitionBy);
            this.configureColumnMemory();
            this.timestampSetter = this.configureTimestampSetter();
            this.configureAppendPosition();
            this.purgeUnusedPartitions();
        }
        catch (CairoException e) {
            LOG.error().$("cannot open '").$(this.path).$("' and this is why: {").$(e).$('}').$();
            this.close();
            throw e;
        }
    }

    public void addColumn(CharSequence name, int type) {
        if (TableWriter.getColumnIndexQuiet(this.metaMem, name, this.columnCount) != -1) {
            throw CairoException.instance(0).put("Duplicate column name: ").put(name);
        }
        LOG.info().$("adding column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("]' to ").$(this.path).$();
        this.commit();
        this.metaSwapIndex = this.addColumnToMeta(name, type);
        this.metaMem.close();
        this.renameMetaToMetaPrev();
        this.writeRestoreMetaTodo();
        this.renameSwapMetaToMeta();
        this.configureColumn(type);
        ++this.columnCount;
        this.columnTops.extendAndSet(this.columnCount - 1, this.transientRowCount);
        if (this.transientRowCount > 0L || this.partitionBy == 3) {
            try {
                this.openNewColumnFiles(name);
            }
            catch (CairoException e) {
                TableWriter.runFragile(() -> {
                    this.removeMetaFile();
                    this.removeLastColumn();
                    this.rename((CharSequence)"_meta.prev", this.metaPrevIndex, "_meta");
                    this.openMetaFile();
                    this.removeTodoFile();
                }, e);
            }
        }
        try {
            this.openMetaFile();
            this.removeTodoFile();
        }
        catch (CairoException err) {
            throw new CairoError(err);
        }
        this.bumpStructureVersion();
        this.metadata.addColumn(name, type);
        LOG.info().$("ADDED column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("]' to ").$(this.path).$();
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.closeColumns(true);
            Misc.free(this.txMem);
            Misc.free(this.metaMem);
            Misc.free(this.columnSizeMem);
            Misc.free(this.ddlMem);
            Misc.free(this.path);
            Misc.free(this.other);
            if (this.lockFd != -1L) {
                this.ff.close(this.lockFd);
            }
            if (this.tempMem8b != 0L) {
                Unsafe.free(this.tempMem8b, 8L);
                this.tempMem8b = 0L;
            }
            LOG.info().$("closed '").utf8(this.name).$('\'').$();
        }
    }

    public void commit() {
        if ((this.masterRef & 1L) != 0L) {
            this.cancelRow();
        }
        if (this.inTransaction()) {
            this.txMem.jumpTo(8L);
            this.txMem.putLong(this.transientRowCount);
            if (this.txPartitionCount > 1) {
                this.commitPendingPartitions();
                this.txMem.putLong(this.fixedRowCount);
                this.columnSizeMem.jumpTo(0L);
                this.txPartitionCount = 1;
            } else {
                this.txMem.skip(8L);
            }
            this.txMem.putLong(this.maxTimestamp);
            this.fencedTxnBump();
            this.prevTransientRowCount = this.transientRowCount;
        }
    }

    public int getColumnIndex(CharSequence name) {
        int index = this.metadata.getColumnIndexQuiet(name);
        if (index == -1) {
            throw CairoException.instance(0).put("Invalid column name: ").put(name);
        }
        return index;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public CharSequence getName() {
        return this.name;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public boolean inTransaction() {
        return this.txPartitionCount > 1 || this.transientRowCount != this.prevTransientRowCount;
    }

    public boolean isOpen() {
        return this.tempMem8b != 0L;
    }

    public Row newRow(long timestamp) {
        return this.rowFunction.newRow(timestamp);
    }

    public void removeColumn(CharSequence name) {
        boolean timestamp;
        int index = this.getColumnIndex(name);
        LOG.info().$("removing column '").utf8(name).$("' from ").$(this.path).$();
        boolean bl = timestamp = index == this.metaMem.getInt(8L);
        if (timestamp && this.partitionBy != 3) {
            throw CairoException.instance(0).put("Cannot remove timestamp from partitioned table");
        }
        this.commit();
        this.metaSwapIndex = this.removeColumnFromMeta(index);
        this.metaMem.close();
        this.renameMetaToMetaPrev();
        this.writeRestoreMetaTodo();
        this.renameSwapMetaToMeta();
        this.removeColumn(index);
        --this.columnCount;
        if (timestamp) {
            this.prevTimestamp = Long.MIN_VALUE;
            this.maxTimestamp = Long.MIN_VALUE;
            this.timestampSetter = value -> {};
        }
        try {
            this.openMetaFile();
            this.removeTodoFile();
            this.removeColumnFiles(name);
        }
        catch (CairoException err) {
            throw new CairoError(err);
        }
        this.bumpStructureVersion();
        this.metadata.removeColumn(name);
        LOG.info().$("REMOVED column '").utf8(name).$("' from ").$(this.path).$();
    }

    public void rollback() {
        if (this.inTransaction()) {
            this.closeColumns(false);
            this.columnSizeMem.jumpTo(0L);
            this.configureAppendPosition();
            this.purgeUnusedPartitions();
        }
    }

    public long size() {
        return this.fixedRowCount + this.transientRowCount;
    }

    public String toString() {
        return "TableWriter{name=" + this.name + '}';
    }

    public final void truncate() {
        if (this.size() == 0L) {
            return;
        }
        this.writeTodo(1L);
        for (int i = 0; i < this.columnCount; ++i) {
            this.getPrimaryColumn(i).truncate();
            AppendMemory mem = this.getSecondaryColumn(i);
            if (mem == null) continue;
            mem.truncate();
        }
        if (this.partitionBy != 3) {
            this.closeColumns(false);
            this.removePartitionDirectories();
            this.rowFunction = this.openPartitionFunction;
        }
        this.prevTimestamp = Long.MIN_VALUE;
        this.maxTimestamp = Long.MIN_VALUE;
        this.partitionLo = Long.MIN_VALUE;
        this.prevTransientRowCount = 0L;
        this.transientRowCount = 0L;
        this.fixedRowCount = 0L;
        this.txn = 0L;
        this.txPartitionCount = 1;
        this.txMem.jumpTo(0L);
        TableUtils.resetTxn(this.txMem);
        try {
            this.removeTodoFile();
        }
        catch (CairoException err) {
            throw new CairoError(err);
        }
    }

    public void warmUp() {
        Row r = this.newRow(this.maxTimestamp);
        try {
            for (int i = 0; i < this.columnCount; ++i) {
                r.putByte(0, (byte)0);
            }
        }
        finally {
            r.cancel();
        }
    }

    private static int getPrimaryColumnIndex(int index) {
        return index * 2;
    }

    private static int getSecondaryColumnIndex(int index) {
        return TableWriter.getPrimaryColumnIndex(index) + 1;
    }

    private static void setColumnSize(FilesFacade ff, AppendMemory mem1, AppendMemory mem2, int type, long actualPosition, long buf) {
        if (actualPosition > 0L) {
            switch (type) {
                case 9: {
                    assert (mem2 != null);
                    if (ff.read(mem2.getFd(), buf, 8, (actualPosition - 1L) * 8L) != 8L) {
                        throw CairoException.instance(ff.errno()).put("Cannot read offset, fd=").put(mem2.getFd()).put(", offset=").put((actualPosition - 1L) * 8L);
                    }
                    long offset = Unsafe.getUnsafe().getLong(buf);
                    if (ff.read(mem1.getFd(), buf, 8, offset) != 8L) {
                        throw CairoException.instance(ff.errno()).put("Cannot read length, fd=").put(mem1.getFd()).put(", offset=").put(offset);
                    }
                    long len = Unsafe.getUnsafe().getLong(buf);
                    if (len == -1L) {
                        mem1.setSize(offset + 8L);
                    } else {
                        mem1.setSize(offset + len + 8L);
                    }
                    mem2.setSize(actualPosition * 8L);
                    break;
                }
                case 7: 
                case 8: {
                    assert (mem2 != null);
                    if (ff.read(mem2.getFd(), buf, 8, (actualPosition - 1L) * 8L) != 8L) {
                        throw CairoException.instance(ff.errno()).put("Cannot read offset, fd=").put(mem2.getFd()).put(", offset=").put((actualPosition - 1L) * 8L);
                    }
                    long offset = Unsafe.getUnsafe().getLong(buf);
                    if (ff.read(mem1.getFd(), buf, 4, offset) != 4L) {
                        throw CairoException.instance(ff.errno()).put("Cannot read length, fd=").put(mem1.getFd()).put(", offset=").put(offset);
                    }
                    long len = Unsafe.getUnsafe().getInt(buf);
                    if (len == -1L) {
                        mem1.setSize(offset + 4L);
                    } else {
                        mem1.setSize(offset + len * 2L + 4L);
                    }
                    mem2.setSize(actualPosition * 8L);
                    break;
                }
                default: {
                    mem1.setSize(actualPosition * (long)ColumnType.sizeOf(type));
                    break;
                }
            }
        } else {
            mem1.setSize(0L);
            if (mem2 != null) {
                mem2.setSize(0L);
            }
        }
    }

    private static DateFormat selectPartitionDirFmt(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return TableUtils.fmtDay;
            }
            case 1: {
                return TableUtils.fmtMonth;
            }
            case 2: {
                return TableUtils.fmtYear;
            }
        }
        return null;
    }

    private static int getColumnIndexQuiet(ReadOnlyMemory metaMem, CharSequence name, int columnCount) {
        long nameOffset = TableUtils.getColumnNameOffset(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            CharSequence col = metaMem.getStr(nameOffset);
            if (Chars.equals(col, name)) {
                return i;
            }
            nameOffset += (long)VirtualMemory.getStorageLength(col);
        }
        return -1;
    }

    private static void runFragile(Runnable runnable, CairoException e) {
        try {
            runnable.run();
        }
        catch (CairoException err) {
            LOG.error().$("DOUBLE ERROR: 1st: '").$(e).$('\'').$();
            throw new CairoError(err);
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addColumnToMeta(CharSequence name, int type) {
        int index;
        try {
            index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, 30);
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount + 1);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            for (int i = 0; i < columnCount; ++i) {
                this.ddlMem.putInt(TableUtils.getColumnType(this.metaMem, i));
            }
            this.ddlMem.putInt(type);
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)VirtualMemory.getStorageLength(columnName);
            }
            this.ddlMem.putStr(name);
        }
        finally {
            this.ddlMem.close();
        }
        return index;
    }

    private void bumpMasterRef() {
        if ((this.masterRef & 1L) != 0L) {
            this.cancelRow();
        }
        ++this.masterRef;
    }

    private void bumpStructureVersion() {
        this.txMem.jumpTo(32L);
        this.txMem.putLong(++this.structVersion);
        this.fencedTxnBump();
    }

    private void cancelRow() {
        if ((this.masterRef & 1L) == 0L) {
            return;
        }
        if (this.transientRowCount == 0L) {
            if (this.partitionBy != 3) {
                this.closeColumns(false);
                if (this.removeDirOnCancelRow) {
                    try {
                        this.setStateForTimestamp(this.maxTimestamp, false);
                        if (!this.ff.rmdir(this.path.$())) {
                            throw CairoException.instance(this.ff.errno()).put("Cannot remove directory: ").put(this.path);
                        }
                        this.removeDirOnCancelRow = false;
                    }
                    finally {
                        this.path.trimTo(this.rootLen);
                    }
                }
                if (this.prevTimestamp > Long.MIN_VALUE) {
                    try {
                        this.columnSizeMem.jumpTo((this.txPartitionCount - 2) * 16);
                        this.openPartition(this.prevTimestamp);
                        this.setAppendPosition(this.prevTransientRowCount);
                        --this.txPartitionCount;
                    }
                    catch (CairoException e) {
                        this.closeColumns(false);
                        throw e;
                    }
                } else {
                    this.rowFunction = this.openPartitionFunction;
                }
                this.transientRowCount = this.prevTransientRowCount;
                this.fixedRowCount -= this.prevTransientRowCount;
                this.maxTimestamp = this.prevTimestamp;
                this.removeDirOnCancelRow = true;
            } else {
                this.maxTimestamp = this.prevTimestamp;
                for (int i = 0; i < this.columnCount; ++i) {
                    this.getPrimaryColumn(i).setSize(0L);
                    AppendMemory mem = this.getSecondaryColumn(i);
                    if (mem == null) continue;
                    mem.setSize(0L);
                }
            }
        } else {
            this.maxTimestamp = this.prevTimestamp;
            boolean rowChanged = false;
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.refs.getQuick(i) != this.masterRef) continue;
                rowChanged = true;
                break;
            }
            if (rowChanged) {
                this.setAppendPosition(this.transientRowCount);
            }
        }
        this.refs.fill(0, this.columnCount, --this.masterRef);
    }

    private void closeColumns(boolean truncate) {
        if (this.columns != null) {
            int n = this.columns.size();
            for (int i = 0; i < n; ++i) {
                AppendMemory m = this.columns.getQuick(i);
                if (m == null) continue;
                m.close(truncate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPendingPartitions() {
        long offset = 0L;
        for (int i = 0; i < this.txPartitionCount - 1; ++i) {
            try {
                long partitionTimestamp = this.columnSizeMem.getLong(offset + 8L);
                this.setStateForTimestamp(partitionTimestamp, false);
                long fd = this.openAppend(this.path.concat("_archive").$());
                try {
                    int len = 8;
                    long o = offset;
                    while (len > 0) {
                        long l = Math.min((long)len, this.columnSizeMem.pageRemaining(o));
                        if (this.ff.write(fd, this.columnSizeMem.addressOf(o), l, 0L) != l) {
                            throw CairoException.instance(this.ff.errno()).put("Commit failed, file=").put(this.path);
                        }
                        len = (int)((long)len - l);
                        o += l;
                    }
                }
                finally {
                    this.ff.close(fd);
                }
                offset += 16L;
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private void configureAppendPosition() {
        this.txn = this.txMem.getLong(0L);
        this.prevTransientRowCount = this.transientRowCount = this.txMem.getLong(8L);
        this.fixedRowCount = this.txMem.getLong(16L);
        this.maxTimestamp = this.txMem.getLong(24L);
        this.structVersion = this.txMem.getLong(32L);
        this.prevTimestamp = this.maxTimestamp;
        if (this.maxTimestamp > Long.MIN_VALUE || this.partitionBy == 3) {
            this.openFirstPartition(this.maxTimestamp);
            this.rowFunction = this.partitionBy == 3 ? this.noPartitionFunction : this.switchPartitionFunction;
        } else {
            this.rowFunction = this.openPartitionFunction;
        }
    }

    private void configureColumn(int type) {
        AppendMemory secondary;
        AppendMemory primary = new AppendMemory();
        switch (type) {
            case 7: 
            case 8: 
            case 9: {
                secondary = new AppendMemory();
                break;
            }
            default: {
                secondary = null;
            }
        }
        this.columns.add(primary);
        this.columns.add(secondary);
        this.configureNuller(type, primary, secondary);
        this.refs.add(0L);
    }

    private void configureColumnMemory() {
        for (int i = 0; i < this.columnCount; ++i) {
            this.configureColumn(TableUtils.getColumnType(this.metaMem, i));
        }
    }

    private void configureNuller(int type, AppendMemory mem1, AppendMemory mem2) {
        switch (type) {
            case 0: 
            case 1: {
                this.nullers.add(() -> mem1.putByte((byte)0));
                break;
            }
            case 2: {
                this.nullers.add(() -> mem1.putDouble(Double.NaN));
                break;
            }
            case 3: {
                this.nullers.add(() -> mem1.putFloat(Float.NaN));
                break;
            }
            case 4: {
                this.nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                this.nullers.add(() -> mem1.putLong(Long.MIN_VALUE));
                break;
            }
            case 6: {
                this.nullers.add(() -> mem1.putShort((short)0));
                break;
            }
            case 7: 
            case 8: {
                this.nullers.add(() -> mem2.putLong(mem1.putNullStr()));
                break;
            }
            case 9: {
                this.nullers.add(() -> mem2.putLong(mem1.putNullBin()));
                break;
            }
        }
    }

    private LongConsumer configureTimestampSetter() {
        int index = this.metadata.getTimestampIndex();
        if (index == -1) {
            return value -> {};
        }
        this.nullers.setQuick(index, NOOP);
        return this.getPrimaryColumn(index)::putLong;
    }

    private void fencedTxnBump() {
        Unsafe.getUnsafe().storeFence();
        this.txMem.jumpTo(0L);
        this.txMem.putLong(++this.txn);
        Unsafe.getUnsafe().storeFence();
        this.txMem.jumpTo(40L);
    }

    private AppendMemory getPrimaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getPrimaryColumnIndex(column));
    }

    private AppendMemory getSecondaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getSecondaryColumnIndex(column));
    }

    private long openAppend(LPSZ name) {
        long fd = this.ff.openAppend(name);
        if (fd == -1L) {
            throw CairoException.instance(Os.errno()).put("Cannot open for append: ").put(name);
        }
        return fd;
    }

    private void openColumnFiles(CharSequence name, int i, int plen) {
        AppendMemory mem1 = this.getPrimaryColumn(i);
        AppendMemory mem2 = this.getSecondaryColumn(i);
        mem1.of(this.ff, TableUtils.dFile(this.path.trimTo(plen), name), TableUtils.getMapPageSize(this.ff));
        if (mem2 != null) {
            mem2.of(this.ff, TableUtils.iFile(this.path.trimTo(plen), name), TableUtils.getMapPageSize(this.ff));
        }
        this.path.trimTo(plen);
    }

    private void openFirstPartition(long timestamp) {
        this.openPartition(timestamp);
        this.setAppendPosition(this.transientRowCount);
        this.txPartitionCount = 1;
    }

    private void openMetaFile() {
        this.path.concat("_meta").$();
        try {
            this.metaMem.of(this.ff, this.path, this.ff.getPageSize());
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void openNewColumnFiles(CharSequence name) {
        try {
            this.setStateForTimestamp(this.maxTimestamp, false);
            int plen = this.path.length();
            this.openColumnFiles(name, this.columnCount - 1, plen);
            if (this.transientRowCount > 0L) {
                this.writeColumnTop(name);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openPartition(long timestamp) {
        try {
            this.setStateForTimestamp(timestamp, true);
            int plen = this.path.length();
            if (this.ff.mkdirs(this.path.put(Files.SEPARATOR).$(), this.mkDirMode) != 0) {
                throw CairoException.instance(this.ff.errno()).put("Cannot create directory: ").put(this.path);
            }
            assert (this.columnCount > 0);
            for (int i = 0; i < this.columnCount; ++i) {
                String name = this.metadata.getColumnQuick(i).getName();
                this.openColumnFiles(name, i, plen);
                this.columnTops.extendAndSet(i, TableUtils.readColumnTop(this.ff, this.path, name, plen, this.tempMem8b));
            }
            LOG.info().$("switched partition to '").$(this.path).$('\'').$();
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private ReadWriteMemory openTxnFile() {
        try {
            if (this.ff.exists(this.path.concat("_txn").$())) {
                ReadWriteMemory readWriteMemory = new ReadWriteMemory(this.ff, this.path, this.ff.getPageSize(), 0L, this.ff.getPageSize());
                return readWriteMemory;
            }
            throw CairoException.instance(this.ff.errno()).put("Cannot append. File does not exist: ").put(this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void purgeUnusedPartitions() {
        if (this.partitionBy != 3 && this.maxTimestamp != Long.MIN_VALUE) {
            this.removePartitionDirsNewerThan(this.maxTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readTodoTaskCode() {
        try {
            if (this.ff.exists(this.path.concat("_todo").$())) {
                long todoFd = this.ff.openRO(this.path);
                if (todoFd == -1L) {
                    throw CairoException.instance(Os.errno()).put("Cannot open *todo*: ").put(this.path);
                }
                long len = this.ff.read(todoFd, this.tempMem8b, 8, 0L);
                this.ff.close(todoFd);
                if (len != 8L) {
                    LOG.info().$("Cannot read *todo* code. File seems to be truncated. Ignoring. [file=").$(this.path).$(']').$();
                    long l = -1L;
                    return l;
                }
                long l = Unsafe.getUnsafe().getLong(this.tempMem8b);
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeColumn(int index) {
        Misc.free(this.getPrimaryColumn(index));
        Misc.free(this.getSecondaryColumn(index));
        this.columns.remove(TableWriter.getSecondaryColumnIndex(index));
        this.columns.remove(TableWriter.getPrimaryColumnIndex(index));
        this.columnTops.removeIndex(index);
    }

    private void removeColumnFiles(CharSequence name) {
        try {
            this.ff.iterateDir(this.path.$(), (file, type) -> {
                this.nativeLPSZ.of(file);
                if (type == 4 && !ignoredFiles.contains(this.nativeLPSZ)) {
                    this.path.trimTo(this.rootLen);
                    this.path.concat(this.nativeLPSZ);
                    int plen = this.path.length();
                    this.removeFileAndOrLog(TableUtils.dFile(this.path, name));
                    this.removeFileAndOrLog(TableUtils.iFile(this.path.trimTo(plen), name));
                    this.removeFileAndOrLog(TableUtils.topFile(this.path.trimTo(plen), name));
                }
            });
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeColumnFromMeta(int index) {
        try {
            int metaSwapIndex = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.fileOperationRetryCount);
            int timestampIndex = this.metaMem.getInt(8L);
            this.ddlMem.putInt(this.columnCount - 1);
            this.ddlMem.putInt(this.partitionBy);
            if (timestampIndex == index) {
                this.ddlMem.putInt(-1);
            } else if (index < timestampIndex) {
                this.ddlMem.putInt(timestampIndex - 1);
            } else {
                this.ddlMem.putInt(timestampIndex);
            }
            for (int i = 0; i < this.columnCount; ++i) {
                if (i == index) continue;
                this.ddlMem.putInt(TableUtils.getColumnType(this.metaMem, i));
            }
            long nameOffset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                if (i != index) {
                    this.ddlMem.putStr(columnName);
                }
                nameOffset += (long)VirtualMemory.getStorageLength(columnName);
            }
            int n = metaSwapIndex;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    private void removeFileAndOrLog(LPSZ name) {
        if (this.ff.exists(name)) {
            if (this.ff.remove(name)) {
                LOG.info().$("removed: ").$(this.path).$();
            } else {
                LOG.error().$("cannot remove: ").utf8(name).$(" [errno=").$(this.ff.errno()).$(']').$();
            }
        }
    }

    private void removeLastColumn() {
        this.removeColumn(this.columnCount - 1);
        --this.columnCount;
    }

    private void removeMetaFile() {
        try {
            this.path.concat("_meta").$();
            if (this.ff.exists(this.path) && !this.ff.remove(this.path)) {
                throw CairoException.instance(this.ff.errno()).put("Recovery failed. Cannot remove: ").put(this.path);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removePartitionDirectories() {
        try {
            this.ff.iterateDir(this.path.$(), (name, type) -> {
                this.path.trimTo(this.rootLen);
                this.path.concat(name).$();
                this.nativeLPSZ.of(name);
                if (!ignoredFiles.contains(this.nativeLPSZ)) {
                    if (type == 4 && !this.ff.rmdir(this.path)) {
                        throw CairoException.instance(this.ff.errno()).put("Cannot remove directory: ").put(this.path);
                    }
                    if (type != 4 && !this.ff.remove(this.path)) {
                        throw CairoException.instance(this.ff.errno()).put("Cannot remove file: ").put(this.path);
                    }
                }
            });
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removePartitionDirsNewerThan(long timestamp) {
        LOG.info().$("looking to remove partitions newer than '").$ts(timestamp).$("' from ").$(this.path.$()).$();
        try {
            this.ff.iterateDir(this.path.$(), (pName, type) -> {
                this.path.trimTo(this.rootLen);
                this.path.concat(pName).$();
                this.nativeLPSZ.of(pName);
                if (!ignoredFiles.contains(this.nativeLPSZ)) {
                    try {
                        long dirTimestamp = this.partitionDirFmt.parse(this.nativeLPSZ, DateLocaleFactory.INSTANCE.getDefaultDateLocale());
                        if (dirTimestamp <= timestamp) {
                            return;
                        }
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                    if (type == 4) {
                        if (this.ff.rmdir(this.path)) {
                            LOG.info().$("removing partition dir: ").$(this.path).$();
                        } else {
                            LOG.error().$("cannot remove: ").$(this.path).$(" [errno=").$(this.ff.errno()).$(']').$();
                        }
                    }
                }
            });
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeTodoFile() {
        try {
            if (!this.ff.remove(this.path.concat("_todo").$())) {
                throw CairoException.instance(Os.errno()).put("Recovery operation completed successfully but I cannot remove todo file: ").put(this.path).put(". Please remove manually before opening table again,");
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private int rename(CharSequence from, CharSequence toBase, int retries) {
        try {
            int index = 0;
            this.other.concat(toBase).$();
            this.path.concat(from).$();
            int l = this.other.length();
            do {
                if (index > 0) {
                    this.other.trimTo(l);
                    this.other.put('.').put(index);
                    this.other.$();
                }
                if (this.ff.exists(this.other) && !this.ff.remove(this.other)) {
                    LOG.info().$("cannot remove target of rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).$(']').$();
                    ++index;
                    continue;
                }
                if (!this.ff.rename(this.path, this.other)) {
                    LOG.info().$("cannot rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).$(']').$();
                    ++index;
                    continue;
                }
                int n = index;
                return n;
            } while (index < retries);
            throw CairoException.instance(0).put("Cannot rename ").put(this.path).put(". Max number of attempts reached [").put(index).put("]. Last target was: ").put(this.other);
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename(CharSequence fromBase, int fromIndex, CharSequence to) {
        try {
            this.path.concat(fromBase);
            if (fromIndex > 0) {
                this.path.put('.').put(fromIndex);
            }
            this.path.$();
            if (!this.ff.rename(this.path, this.other.concat(to).$())) {
                throw CairoException.instance(this.ff.errno()).put("Cannot rename ").put(this.path).put(" -> ").put(this.other);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private void renameMetaToMetaPrev() {
        try {
            this.metaPrevIndex = this.rename((CharSequence)"_meta", "_meta.prev", this.fileOperationRetryCount);
        }
        catch (CairoException e) {
            TableWriter.runFragile(this.MY_OPEN_META, e);
        }
    }

    private void renameSwapMetaToMeta() {
        try {
            this.rename((CharSequence)"_meta.swp", this.metaSwapIndex, "_meta");
        }
        catch (CairoException e) {
            TableWriter.runFragile(() -> {
                this.rename((CharSequence)"_meta.prev", this.metaPrevIndex, "_meta");
                this.openMetaFile();
                this.removeTodoFile();
            }, e);
        }
    }

    private void repairMetaRename(int index) {
        try {
            this.path.concat("_meta.prev");
            if (index > 0) {
                this.path.put('.').put(index);
            }
            this.path.$();
            if (this.ff.exists(this.path)) {
                LOG.info().$("Repairing metadata from: ").$(this.path).$();
                if (this.ff.exists(this.other.concat("_meta").$()) && !this.ff.remove(this.other)) {
                    throw CairoException.instance(Os.errno()).put("Repair failed. Cannot replace ").put(this.other);
                }
                if (!this.ff.rename(this.path, this.other)) {
                    throw CairoException.instance(Os.errno()).put("Repair failed. Cannot rename ").put(this.path).put(" -> ").put(this.other);
                }
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
        this.removeTodoFile();
    }

    private void repairTruncate() {
        LOG.info().$("repairing abnormally terminated truncate on ").$(this.path).$();
        if (this.partitionBy != 3) {
            this.removePartitionDirectories();
        }
        this.txMem.jumpTo(0L);
        TableUtils.resetTxn(this.txMem);
        this.removeTodoFile();
    }

    private void setAppendPosition(long position) {
        for (int i = 0; i < this.columnCount; ++i) {
            TableWriter.setColumnSize(this.ff, this.getPrimaryColumn(i), this.getSecondaryColumn(i), TableUtils.getColumnType(this.metaMem, i), position - this.columnTops.getQuick(i), this.tempMem8b);
        }
    }

    private void setStateForTimestamp(long timestamp, boolean updatePartitionInterval) {
        this.path.put(Files.SEPARATOR);
        switch (this.partitionBy) {
            case 0: {
                int y = Dates.getYear(timestamp);
                boolean leap = Dates.isLeapYear(y);
                int m = Dates.getMonthOfYear(timestamp, y, leap);
                int d = Dates.getDayOfMonth(timestamp, y, m, leap);
                DateFormatUtils.append000(this.path, y);
                this.path.put('-');
                DateFormatUtils.append0(this.path, m);
                this.path.put('-');
                DateFormatUtils.append0(this.path, d);
                if (!updatePartitionInterval) break;
                this.partitionLo = Dates.yearMicros(y, leap);
                this.partitionLo += Dates.monthOfYearMicros(m, leap);
                this.partitionLo += (long)(d - 1) * 86400000000L;
                this.partitionHi = this.partitionLo + 86400000000L;
                break;
            }
            case 1: {
                int y = Dates.getYear(timestamp);
                boolean leap = Dates.isLeapYear(y);
                int m = Dates.getMonthOfYear(timestamp, y, leap);
                DateFormatUtils.append000(this.path, y);
                this.path.put('-');
                DateFormatUtils.append0(this.path, m);
                if (!updatePartitionInterval) break;
                this.partitionLo = Dates.yearMicros(y, leap);
                this.partitionLo += Dates.monthOfYearMicros(m, leap);
                this.partitionHi = this.partitionLo + (long)Dates.getDaysPerMonth(m, leap) * 24L * 3600000000L;
                break;
            }
            case 2: {
                int y = Dates.getYear(timestamp);
                boolean leap = Dates.isLeapYear(y);
                DateFormatUtils.append000(this.path, y);
                if (!updatePartitionInterval) break;
                this.partitionLo = Dates.yearMicros(y, leap);
                this.partitionHi = Dates.addYear(this.partitionLo, 1);
                break;
            }
            default: {
                this.path.put("default");
                this.partitionLo = Long.MIN_VALUE;
                this.partitionHi = Long.MAX_VALUE;
            }
        }
    }

    private void switchPartition(long timestamp) {
        if (this.txPartitionCount++ > 0) {
            this.columnSizeMem.putLong(this.transientRowCount);
            this.columnSizeMem.putLong(this.maxTimestamp);
        }
        this.fixedRowCount += this.transientRowCount;
        this.prevTransientRowCount = this.transientRowCount;
        this.transientRowCount = 0L;
        this.openPartition(timestamp);
        this.setAppendPosition(0L);
    }

    private void updateMaxTimestamp(long timestamp) {
        this.prevTimestamp = this.maxTimestamp;
        this.maxTimestamp = timestamp;
        this.timestampSetter.accept(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeColumnTop(CharSequence name) {
        long fd = this.openAppend(this.path.concat(name).put(".top").$());
        try {
            Unsafe.getUnsafe().putLong(this.tempMem8b, this.transientRowCount);
            if (this.ff.append(fd, this.tempMem8b, 8) != 8L) {
                throw CairoException.instance(Os.errno()).put("Cannot append ").put(this.path);
            }
        }
        finally {
            this.ff.close(fd);
        }
    }

    private void writeRestoreMetaTodo() {
        try {
            this.writeTodo((long)this.metaPrevIndex << 8 | 2L);
        }
        catch (CairoException e) {
            TableWriter.runFragile(() -> {
                this.rename((CharSequence)"_meta.prev", this.metaPrevIndex, "_meta");
                this.openMetaFile();
            }, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTodo(long code) {
        try {
            long fd = this.openAppend(this.path.concat("_todo").$());
            try {
                Unsafe.getUnsafe().putLong(this.tempMem8b, code);
                if (this.ff.append(fd, this.tempMem8b, 8) != 8L) {
                    throw CairoException.instance(Os.errno()).put("Cannot write ").put(TableUtils.getTodoText(code)).put(" *todo*: ").put(this.path);
                }
            }
            finally {
                this.ff.close(fd);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    static {
        ignoredFiles.add("..");
        ignoredFiles.add(".");
        ignoredFiles.add("_meta");
        ignoredFiles.add("_txn");
        ignoredFiles.add("_todo");
    }

    public class Row {
        public void append() {
            if ((TableWriter.this.masterRef & 1L) == 0L) {
                return;
            }
            for (int i = 0; i < TableWriter.this.columnCount; ++i) {
                if (TableWriter.this.refs.getQuick(i) >= TableWriter.this.masterRef) continue;
                ((Runnable)TableWriter.this.nullers.getQuick(i)).run();
            }
            TableWriter.this.transientRowCount++;
            TableWriter.this.masterRef++;
        }

        public void cancel() {
            TableWriter.this.cancelRow();
        }

        public void putBin(int index, long address, long len) {
            TableWriter.this.getSecondaryColumn(index).putLong(TableWriter.this.getPrimaryColumn(index).putBin(address, len));
            this.notNull(index);
        }

        public void putBool(int index, boolean value) {
            TableWriter.this.getPrimaryColumn(index).putBool(value);
            this.notNull(index);
        }

        public void putByte(int index, byte value) {
            TableWriter.this.getPrimaryColumn(index).putByte(value);
            this.notNull(index);
        }

        public void putDate(int index, long value) {
            this.putLong(index, value);
        }

        public void putDouble(int index, double value) {
            TableWriter.this.getPrimaryColumn(index).putDouble(value);
            this.notNull(index);
        }

        public void putFloat(int index, float value) {
            TableWriter.this.getPrimaryColumn(index).putFloat(value);
            this.notNull(index);
        }

        public void putInt(int index, int value) {
            TableWriter.this.getPrimaryColumn(index).putInt(value);
            this.notNull(index);
        }

        public void putLong(int index, long value) {
            TableWriter.this.getPrimaryColumn(index).putLong(value);
            this.notNull(index);
        }

        public void putShort(int index, short value) {
            TableWriter.this.getPrimaryColumn(index).putShort(value);
            this.notNull(index);
        }

        public void putStr(int index, CharSequence value) {
            TableWriter.this.getSecondaryColumn(index).putLong(TableWriter.this.getPrimaryColumn(index).putStr(value));
            this.notNull(index);
        }

        public void putStr(int index, CharSequence value, int pos, int len) {
            TableWriter.this.getSecondaryColumn(index).putLong(TableWriter.this.getPrimaryColumn(index).putStr(value, pos, len));
            this.notNull(index);
        }

        private void notNull(int index) {
            TableWriter.this.refs.setQuick(index, TableWriter.this.masterRef);
        }
    }

    private class SwitchPartitionRowFunction
    implements RowFunction {
        private SwitchPartitionRowFunction() {
        }

        @NotNull
        private Row newRow0(long timestamp) {
            if (timestamp < TableWriter.this.maxTimestamp) {
                throw CairoException.instance(TableWriter.this.ff.errno()).put("Cannot insert rows out of order. Table=").put(TableWriter.this.path);
            }
            if (timestamp >= TableWriter.this.partitionHi && TableWriter.this.partitionBy != 3) {
                TableWriter.this.switchPartition(timestamp);
            }
            TableWriter.this.updateMaxTimestamp(timestamp);
            return TableWriter.this.row;
        }

        @Override
        public Row newRow(long timestamp) {
            TableWriter.this.bumpMasterRef();
            if (timestamp < TableWriter.this.partitionHi && timestamp >= TableWriter.this.maxTimestamp) {
                TableWriter.this.updateMaxTimestamp(timestamp);
                return TableWriter.this.row;
            }
            return this.newRow0(timestamp);
        }
    }

    private class NoPartitionFunction
    implements RowFunction {
        private NoPartitionFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            TableWriter.this.bumpMasterRef();
            if (timestamp < TableWriter.this.maxTimestamp) {
                throw CairoException.instance(TableWriter.this.ff.errno()).put("Cannot insert rows out of order. Table=").put(TableWriter.this.path);
            }
            TableWriter.this.updateMaxTimestamp(timestamp);
            return TableWriter.this.row;
        }
    }

    private class OpenPartitionRowFunction
    implements RowFunction {
        private OpenPartitionRowFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            if (TableWriter.this.maxTimestamp == Long.MIN_VALUE) {
                TableWriter.this.openFirstPartition(timestamp);
            }
            return (TableWriter.this.rowFunction = TableWriter.this.switchPartitionFunction).newRow(timestamp);
        }
    }
}

