/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.ReadOnlyMemory;
import com.questdb.cairo.TableColumnMetadata;
import com.questdb.cairo.TableUtils;
import com.questdb.common.AbstractRecordMetadata;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.FilesFacade;
import com.questdb.std.ObjList;

public class TableWriterMetadata
extends AbstractRecordMetadata {
    private final ObjList<TableColumnMetadata> columnMetadata;
    private final CharSequenceIntHashMap columnNameIndexMap = new CharSequenceIntHashMap();
    private int columnCount;
    private final int timestampIndex;

    public TableWriterMetadata(FilesFacade ff, ReadOnlyMemory metaMem) {
        TableUtils.validate(ff, metaMem, this.columnNameIndexMap);
        this.columnCount = metaMem.getInt(0L);
        this.timestampIndex = metaMem.getInt(8L);
        this.columnMetadata = new ObjList(this.columnCount);
        long offset = TableUtils.getColumnNameOffset(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            CharSequence name = metaMem.getStr(offset);
            int index = this.columnNameIndexMap.keyIndex(name);
            this.columnMetadata.add(new TableColumnMetadata(this.columnNameIndexMap.keyAt(index).toString(), TableUtils.getColumnType(metaMem, i)));
            offset += (long)ReadOnlyMemory.getStorageLength(name);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getColumnIndexQuiet(CharSequence name) {
        return this.columnNameIndexMap.get(name);
    }

    @Override
    public RecordColumnMetadata getColumnQuick(int index) {
        return this.columnMetadata.getQuick(index);
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    void addColumn(CharSequence name, int type) {
        String str = name.toString();
        this.columnNameIndexMap.put(str, this.columnMetadata.size());
        this.columnMetadata.add(new TableColumnMetadata(str, type));
        ++this.columnCount;
    }

    void removeColumn(CharSequence name) {
        int index = this.columnNameIndexMap.keyIndex(name);
        int columnIndex = this.columnNameIndexMap.valueAt(index);
        this.columnMetadata.remove(columnIndex);
        this.columnNameIndexMap.removeAt(index);
        --this.columnCount;
        for (int i = columnIndex; i < this.columnCount; ++i) {
            this.columnNameIndexMap.put(this.columnMetadata.getQuick(i).getName(), i);
        }
    }
}

