/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.std.BinarySequence;
import com.questdb.std.ByteBuffers;
import com.questdb.std.LongList;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSequence;
import java.io.Closeable;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

public class VirtualMemory
implements Closeable {
    private static final int STRING_LENGTH_BYTES = 4;
    protected final LongList pages = new LongList(4, 0L);
    private long pageSize;
    private ByteSequenceView bsview;
    private CharSequenceView csview;
    private CharSequenceView csview2;
    private int bits;
    private long mod;
    private long appendPointer = -1L;
    private long pageHi = -1L;
    private long pageLo = -1L;
    private long baseOffset = 1L;
    private long roOffsetLo = 0L;
    private long roOffsetHi = 0L;
    private long absolutePointer;
    private ViewSupplier<CharSequenceView> csViewSupplier = VirtualMemory::createCharSequenceView;
    private ViewSupplier<ByteSequenceView> bsViewSupplier = VirtualMemory::createByteSequenceView;

    public VirtualMemory(long pageSize) {
        this();
        this.setPageSize(pageSize);
    }

    protected VirtualMemory() {
    }

    public static int getStorageLength(CharSequence s) {
        if (s == null) {
            return 4;
        }
        return 4 + s.length() * 2;
    }

    public long addressOf(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi) {
            return this.absolutePointer + offset;
        }
        return this.addressOf0(offset);
    }

    public void clearHotPage() {
        this.roOffsetHi = 0L;
        this.roOffsetLo = 0L;
    }

    @Override
    public void close() {
        this.clearPages();
        this.appendPointer = -1L;
        this.pageHi = -1L;
        this.pageLo = -1L;
        this.baseOffset = 1L;
        this.clearHotPage();
    }

    public final long getAppendOffset() {
        return this.baseOffset + this.appendPointer;
    }

    public final BinarySequence getBin(long offset) {
        long len = this.getLong(offset);
        if (len == -1L) {
            return null;
        }
        return this.getByteSequenceView().of(offset + 8L, len);
    }

    public final long getBinLen(long offset) {
        return this.getLong(offset);
    }

    public boolean getBool(long offset) {
        return this.getByte(offset) == 1;
    }

    public final byte getByte(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 1L) {
            return Unsafe.getUnsafe().getByte(this.absolutePointer + offset);
        }
        return this.getByte0(offset);
    }

    public final double getDouble(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            return Unsafe.getUnsafe().getDouble(this.absolutePointer + offset);
        }
        return this.getDouble0(offset);
    }

    public final float getFloat(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            return Unsafe.getUnsafe().getFloat(this.absolutePointer + offset);
        }
        return this.getFloat0(offset);
    }

    public final int getInt(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            return Unsafe.getUnsafe().getInt(this.absolutePointer + offset);
        }
        return this.getInt0(offset);
    }

    public long getLong(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            return Unsafe.getUnsafe().getLong(this.absolutePointer + offset);
        }
        return this.getLong0(offset);
    }

    public final short getShort(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 2L) {
            return Unsafe.getUnsafe().getShort(this.absolutePointer + offset);
        }
        return this.getShort0(offset);
    }

    public final CharSequence getStr(long offset) {
        int len = this.getInt(offset);
        if (len == -1) {
            return null;
        }
        return this.getCharSequenceView().of(offset + 4L, len);
    }

    public final CharSequence getStr2(long offset) {
        int len = this.getInt(offset);
        if (len == -1) {
            return null;
        }
        if (this.csview2 == null) {
            this.csview2 = new CharSequenceView();
        }
        return this.csview2.of(offset + 4L, len);
    }

    public final int getStrLen(long offset) {
        return this.getInt(offset);
    }

    public void jumpTo(long offset) {
        assert (offset >= 0L);
        long p = offset - this.baseOffset;
        if (p > this.pageLo && p < this.pageHi) {
            this.appendPointer = p;
        } else {
            this.jumpTo0(offset);
        }
    }

    public long pageRemaining(long offset) {
        return this.getPageSize(this.pageIndex(offset)) - this.offsetInPage(offset);
    }

    public final long putBin(ByteBuffer buf) {
        if (buf instanceof DirectBuffer) {
            int pos = buf.position();
            int len = buf.remaining();
            buf.position(pos + len);
            return this.putBin(ByteBuffers.getAddress(buf) + (long)pos, len);
        }
        return this.putBin0(buf);
    }

    public final long putBin(BinarySequence value) {
        long offset = this.getAppendOffset();
        if (value == null) {
            this.putLong(-1L);
        } else {
            long len = value.length();
            this.putLong(len);
            long remaining = this.pageHi - this.appendPointer;
            if (len < remaining) {
                this.putBinSequence(value, 0L, len);
                this.appendPointer += len;
            } else {
                this.putBin0(value, len, remaining);
            }
        }
        return offset;
    }

    public final long putBin(long from, long len) {
        long offset = this.getAppendOffset();
        this.putLong(len > 0L ? len : -1L);
        if (len < 1L) {
            return offset;
        }
        if (len < this.pageHi - this.appendPointer) {
            Unsafe.getUnsafe().copyMemory(from, this.appendPointer, len);
            this.appendPointer += len;
        } else {
            this.putBinSlit(from, len);
        }
        return offset;
    }

    public void putBool(boolean value) {
        this.putByte((byte)(value ? 1 : 0));
    }

    public void putByte(byte b) {
        if (this.pageHi == this.appendPointer) {
            this.pageAt(this.getAppendOffset() + 1L);
        }
        Unsafe.getUnsafe().putByte(this.appendPointer++, b);
    }

    public final void putDouble(double value) {
        if (this.pageHi - this.appendPointer > 7L) {
            Unsafe.getUnsafe().putDouble(this.appendPointer, value);
            this.appendPointer += 8L;
        } else {
            this.putDoubleBytes(value);
        }
    }

    public final void putFloat(float value) {
        if (this.pageHi - this.appendPointer > 3L) {
            Unsafe.getUnsafe().putFloat(this.appendPointer, value);
            this.appendPointer += 4L;
        } else {
            this.putFloatBytes(value);
        }
    }

    public final void putInt(int value) {
        if (this.pageHi - this.appendPointer > 3L) {
            Unsafe.getUnsafe().putInt(this.appendPointer, value);
            this.appendPointer += 4L;
        } else {
            this.putIntBytes(value);
        }
    }

    public final void putLong(long value) {
        if (this.pageHi - this.appendPointer > 7L) {
            Unsafe.getUnsafe().putLong(this.appendPointer, value);
            this.appendPointer += 8L;
        } else {
            this.putLongBytes(value);
        }
    }

    public final long putNullBin() {
        long offset = this.getAppendOffset();
        this.putLong(-1L);
        return offset;
    }

    public final long putNullStr() {
        long offset = this.getAppendOffset();
        this.putInt(-1);
        return offset;
    }

    public final void putShort(short value) {
        if (this.pageHi - this.appendPointer > 1L) {
            Unsafe.getUnsafe().putShort(this.appendPointer, value);
            this.appendPointer += 2L;
        } else {
            this.putShortBytes(value);
        }
    }

    public final long putStr(CharSequence value) {
        return value == null ? this.putNullStr() : this.putStr(value, 0, value.length());
    }

    public final long putStr(CharSequence value, int pos, int len) {
        if (value == null) {
            return this.putNullStr();
        }
        long offset = this.getAppendOffset();
        this.putInt(len);
        if (this.pageHi - this.appendPointer < (long)(len * 2)) {
            this.putStrSplit(value, pos, len);
        } else {
            VirtualMemory.copyStrChars(value, pos, len, this.appendPointer);
            this.appendPointer += (long)(len * 2);
        }
        return offset;
    }

    public void skip(long bytes) {
        assert (bytes >= 0L);
        if (this.pageHi - this.appendPointer > bytes) {
            this.appendPointer += bytes;
        } else {
            this.skip0(bytes);
        }
    }

    private static void copyStrChars(CharSequence value, int pos, int len, long address) {
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i + pos);
            Unsafe.getUnsafe().putChar(address + (long)(2 * i), c);
        }
    }

    private long addressOf0(long offset) {
        return this.computeHotPage(this.pageIndex(offset)) + this.offsetInPage(offset);
    }

    protected long allocateNextPage(int page) {
        return Unsafe.malloc(this.getMapPageSize());
    }

    protected long cachePageAddress(int index, long address) {
        this.pages.extendAndSet(index, address);
        return address;
    }

    private void clearPages() {
        int n = this.pages.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.release(i, this.pages.getQuick(i));
            }
        }
        this.pages.erase();
    }

    private long computeHotPage(int page) {
        long pageAddress = this.getPageAddress(page);
        this.roOffsetLo = this.pageOffset(page) - 1L;
        this.roOffsetHi = this.roOffsetLo + this.getPageSize(page) + 1L;
        this.absolutePointer = pageAddress - this.roOffsetLo - 1L;
        return pageAddress;
    }

    private void copyBufBytes(ByteBuffer buf, int pos, int len) {
        for (int i = 0; i < len; ++i) {
            byte c = buf.get(pos + i);
            Unsafe.getUnsafe().putByte(this.appendPointer + (long)i, c);
        }
    }

    private ByteSequenceView createByteSequenceView() {
        this.bsViewSupplier = mem -> mem.bsview;
        this.bsview = new ByteSequenceView();
        return this.bsview;
    }

    private CharSequenceView createCharSequenceView() {
        this.csViewSupplier = mem -> mem.csview;
        this.csview = new CharSequenceView();
        return this.csview;
    }

    private byte getByte0(long offset) {
        return Unsafe.getUnsafe().getByte(this.computeHotPage(this.pageIndex(offset)) + this.offsetInPage(offset));
    }

    private ByteSequenceView getByteSequenceView() {
        return this.bsViewSupplier.get(this);
    }

    private CharSequenceView getCharSequenceView() {
        return this.csViewSupplier.get(this);
    }

    private double getDouble0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize(page);
        if (this.getPageSize(page) - pageOffset > 7L) {
            return Unsafe.getUnsafe().getDouble(this.computeHotPage(page) + pageOffset);
        }
        return this.getDoubleBytes(page, pageOffset, pageSize);
    }

    double getDoubleBytes(int page, long pageOffset, long pageSize) {
        return Double.longBitsToDouble(this.getLongBytes(page, pageOffset, pageSize));
    }

    private float getFloat0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        if (this.getPageSize(page) - pageOffset > 3L) {
            return Unsafe.getUnsafe().getFloat(this.computeHotPage(page) + pageOffset);
        }
        return this.getFloatBytes(page, pageOffset);
    }

    float getFloatBytes(int page, long pageOffset) {
        return Float.intBitsToFloat(this.getIntBytes(page, pageOffset));
    }

    private int getInt0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        if (this.getPageSize(page) - pageOffset > 3L) {
            return Unsafe.getUnsafe().getInt(this.computeHotPage(page) + pageOffset);
        }
        return this.getIntBytes(page, pageOffset);
    }

    int getIntBytes(int page, long pageOffset) {
        int value = 0;
        long pageAddress = this.getPageAddress(page);
        long pageSize = this.getPageSize(page);
        for (int i = 0; i < 4; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                pageOffset = 0L;
            }
            int b = Unsafe.getUnsafe().getByte(pageAddress + pageOffset++) & 0xFF;
            value = b << 8 * i | value;
        }
        return value;
    }

    private long getLong0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize(page);
        if (pageSize - pageOffset > 7L) {
            return Unsafe.getUnsafe().getLong(this.computeHotPage(page) + pageOffset);
        }
        return this.getLongBytes(page, pageOffset, pageSize);
    }

    long getLongBytes(int page, long pageOffset, long pageSize) {
        long value = 0L;
        long pageAddress = this.getPageAddress(page);
        for (int i = 0; i < 8; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                pageOffset = 0L;
            }
            long b = Unsafe.getUnsafe().getByte(pageAddress + pageOffset++) & 0xFF;
            value = b << 8 * i | value;
        }
        return value;
    }

    protected long getMapPageSize() {
        return this.pageSize;
    }

    protected long getPageAddress(int page) {
        return this.pages.getQuick(page);
    }

    protected long getPageSize(int page) {
        return this.getMapPageSize();
    }

    private short getShort0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize(page);
        if (pageSize - pageOffset > 1L) {
            return Unsafe.getUnsafe().getShort(this.computeHotPage(page) + pageOffset);
        }
        return this.getShortBytes(page, pageOffset, pageSize);
    }

    short getShortBytes(int page, long pageOffset, long pageSize) {
        short value = 0;
        long pageAddress = this.getPageAddress(page);
        for (int i = 0; i < 2; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                pageOffset = 0L;
            }
            short b = (short)(Unsafe.getUnsafe().getByte(pageAddress + pageOffset++) & 0xFF);
            value = (short)(b << 8 * i | value);
        }
        return value;
    }

    private void jumpTo0(long offset) {
        int page = this.pageIndex(offset);
        this.pageLo = this.mapWritePage(page);
        this.pageHi = this.pageLo + this.getPageSize(page);
        this.baseOffset = this.pageOffset(page + 1) - this.pageHi;
        this.appendPointer = this.pageLo + this.offsetInPage(offset);
        --this.pageLo;
    }

    protected long mapWritePage(int page) {
        long address;
        if (page < this.pages.size() && (address = this.pages.getQuick(page)) != 0L) {
            return address;
        }
        return this.cachePageAddress(page, this.allocateNextPage(page));
    }

    private long offsetInPage(long offset) {
        return offset & this.mod;
    }

    private void pageAt(long offset) {
        int page = this.pageIndex(offset);
        this.updateLimits(page, this.mapWritePage(page));
    }

    protected final int pageIndex(long offset) {
        return (int)(offset >> this.bits);
    }

    protected final long pageOffset(int page) {
        return (long)page << this.bits;
    }

    private void putBin0(BinarySequence value, long len, long remaining) {
        long pos = 0L;
        do {
            this.putBinSequence(value, pos, remaining);
            pos += remaining;
            this.pageAt(this.baseOffset + this.pageHi);
        } while ((len -= remaining) >= (remaining = this.pageHi - this.appendPointer));
        this.putBinSequence(value, pos, len);
        this.appendPointer += len;
    }

    private long putBin0(ByteBuffer buf) {
        long offset = this.getAppendOffset();
        if (buf == null) {
            this.putLong(-1L);
            return offset;
        }
        int pos = buf.position();
        int len = buf.remaining();
        buf.position(pos + len);
        this.putLong(len);
        if ((long)len < this.pageHi - this.appendPointer) {
            this.copyBufBytes(buf, pos, len);
            this.appendPointer += (long)len;
        } else {
            this.putBinSplit(buf, pos, len);
        }
        return offset;
    }

    private void putBinSequence(BinarySequence value, long pos, long len) {
        long copied;
        long offset = 0L;
        while ((copied = value.copyTo(this.appendPointer + offset, pos, len)) != len) {
            len -= copied;
            pos += copied;
            offset += copied;
        }
    }

    private void putBinSlit(long start, long len) {
        while (true) {
            int half;
            if (len <= (long)(half = (int)(this.pageHi - this.appendPointer))) {
                Unsafe.getUnsafe().copyMemory(start, this.appendPointer, len);
                this.appendPointer += len;
                break;
            }
            Unsafe.getUnsafe().copyMemory(start, this.appendPointer, half);
            this.pageAt(this.getAppendOffset() + (long)half);
            len -= (long)half;
            start += (long)half;
        }
    }

    private void putBinSplit(ByteBuffer buf, int pos, int len) {
        int start = pos;
        while (true) {
            int half;
            if (len <= (half = (int)(this.pageHi - this.appendPointer))) {
                this.copyBufBytes(buf, start, len);
                this.appendPointer += (long)len;
                break;
            }
            this.copyBufBytes(buf, start, half);
            this.pageAt(this.getAppendOffset() + (long)half);
            len -= half;
            start += half;
        }
    }

    void putDoubleBytes(double value) {
        this.putLongBytes(Double.doubleToLongBits(value));
    }

    void putFloatBytes(float value) {
        this.putIntBytes(Float.floatToIntBits(value));
    }

    void putIntBytes(int value) {
        this.putByte((byte)(value & 0xFF));
        this.putByte((byte)(value >> 8 & 0xFF));
        this.putByte((byte)(value >> 16 & 0xFF));
        this.putByte((byte)(value >> 24 & 0xFF));
    }

    void putLongBytes(long value) {
        this.putByte((byte)(value & 0xFFL));
        this.putByte((byte)(value >> 8 & 0xFFL));
        this.putByte((byte)(value >> 16 & 0xFFL));
        this.putByte((byte)(value >> 24 & 0xFFL));
        this.putByte((byte)(value >> 32 & 0xFFL));
        this.putByte((byte)(value >> 40 & 0xFFL));
        this.putByte((byte)(value >> 48 & 0xFFL));
        this.putByte((byte)(value >> 56 & 0xFFL));
    }

    void putShortBytes(short value) {
        this.putByte((byte)(value & 0xFF));
        this.putByte((byte)(value >> 8 & 0xFF));
    }

    private void putSplitChar(char c) {
        Unsafe.getUnsafe().putByte(this.pageHi - 1L, (byte)(c >> 8));
        this.pageAt(this.baseOffset + this.pageHi);
        Unsafe.getUnsafe().putByte(this.appendPointer++, (byte)c);
    }

    private void putStrSplit(CharSequence value, int pos, int len) {
        int start = pos;
        while (true) {
            int half;
            if (len <= (half = (int)((this.pageHi - this.appendPointer) / 2L))) {
                VirtualMemory.copyStrChars(value, start, len, this.appendPointer);
                this.appendPointer += (long)(len * 2);
                break;
            }
            VirtualMemory.copyStrChars(value, start, half, this.appendPointer);
            if ((long)(half * 2) < this.pageHi - this.appendPointer) {
                this.putSplitChar(value.charAt(start + half++));
            } else {
                this.pageAt(this.getAppendOffset() + (long)(half * 2));
            }
            len -= half;
            start += half;
        }
    }

    protected void release(int page, long address) {
        if (address != 0L) {
            Unsafe.free(address, this.getPageSize(page));
        }
    }

    protected final void setPageSize(long pageSize) {
        this.clearPages();
        this.pageSize = Numbers.ceilPow2(pageSize);
        this.bits = Numbers.msb(this.pageSize);
        this.mod = this.pageSize - 1L;
        this.clearHotPage();
    }

    private void skip0(long bytes) {
        this.jumpTo(this.getAppendOffset() + bytes);
    }

    protected final void updateLimits(int page, long pageAddress) {
        this.pageLo = pageAddress - 1L;
        this.pageHi = pageAddress + this.getPageSize(page);
        this.baseOffset = this.pageOffset(page + 1) - this.pageHi;
        this.appendPointer = pageAddress;
    }

    private class ByteSequenceView
    implements BinarySequence {
        private long offset;
        private long len = -1L;
        private long lastIndex = -1L;
        private int page;
        private long pageAddress;
        private long pageOffset;
        private long pageSize;

        private ByteSequenceView() {
        }

        @Override
        public byte byteAt(long index) {
            byte c;
            if (index == this.lastIndex + 1L && this.pageOffset < this.pageSize) {
                c = Unsafe.getUnsafe().getByte(this.pageAddress + this.pageOffset);
                ++this.pageOffset;
            } else {
                c = this.updatePosAndGet(index);
            }
            this.lastIndex = index;
            return c;
        }

        @Override
        public long copyTo(long address, long start, long length) {
            long offset = this.offset + start;
            int page = VirtualMemory.this.pageIndex(offset);
            long pageAddress = VirtualMemory.this.getPageAddress(page);
            long offsetInPage = VirtualMemory.this.offsetInPage(offset);
            long len = Math.min(length, this.pageSize - offsetInPage);
            long srcAddress = pageAddress + offsetInPage;
            Unsafe.getUnsafe().copyMemory(srcAddress, address, len);
            return len;
        }

        @Override
        public long length() {
            return this.len;
        }

        ByteSequenceView of(long offset, long len) {
            this.offset = offset;
            this.len = len;
            this.lastIndex = -1L;
            this.page = VirtualMemory.this.pageIndex(offset);
            this.pageSize = VirtualMemory.this.getPageSize(this.page);
            this.pageAddress = VirtualMemory.this.getPageAddress(this.page);
            this.pageOffset = VirtualMemory.this.offsetInPage(offset);
            return this;
        }

        private byte updatePosAndGet(long index) {
            long offset = this.offset + index;
            this.page = VirtualMemory.this.pageIndex(offset);
            this.pageSize = VirtualMemory.this.getPageSize(this.page);
            this.pageAddress = VirtualMemory.this.getPageAddress(this.page);
            this.pageOffset = VirtualMemory.this.offsetInPage(offset);
            byte c = Unsafe.getUnsafe().getByte(this.pageAddress + this.pageOffset);
            ++this.pageOffset;
            return c;
        }
    }

    public class CharSequenceView
    extends AbstractCharSequence {
        private long offset;
        private int len;
        private int lastIndex;
        private int page;
        private long pageSize;
        private long pageAddress;
        private long pageOffset;
        private long mod;

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index) {
            char c;
            if (index == this.lastIndex + 1 && this.pageOffset < this.mod) {
                c = Unsafe.getUnsafe().getChar(this.pageAddress + this.pageOffset);
                this.pageOffset += 2L;
            } else {
                c = this.updatePosAndGet(index);
            }
            this.lastIndex = index;
            return c;
        }

        CharSequenceView of(long offset, int len) {
            this.offset = offset;
            this.len = len;
            this.lastIndex = -1;
            this.page = VirtualMemory.this.pageIndex(offset);
            this.pageSize = VirtualMemory.this.getPageSize(this.page);
            this.mod = this.pageSize - 1L;
            this.pageAddress = VirtualMemory.this.getPageAddress(this.page);
            this.pageOffset = VirtualMemory.this.offsetInPage(offset);
            return this;
        }

        private char updatePosAndGet(int index) {
            char c;
            long offset = this.offset + (long)(index * 2);
            this.page = VirtualMemory.this.pageIndex(offset);
            this.pageSize = VirtualMemory.this.getPageSize(this.page);
            this.mod = this.pageSize - 1L;
            this.pageAddress = VirtualMemory.this.getPageAddress(this.page);
            this.pageOffset = VirtualMemory.this.offsetInPage(offset);
            if (this.pageSize - this.pageOffset > 1L) {
                c = Unsafe.getUnsafe().getChar(this.pageAddress + this.pageOffset);
                this.pageOffset += 2L;
            } else {
                c = (char)(Unsafe.getUnsafe().getByte(this.pageAddress + this.pageOffset) << 8);
                this.pageAddress = VirtualMemory.this.getPageAddress(++this.page);
                c = (char)(c | Unsafe.getUnsafe().getByte(this.pageAddress));
                this.pageOffset = 1L;
            }
            return c;
        }
    }

    @FunctionalInterface
    private static interface ViewSupplier<T> {
        public T get(VirtualMemory var1);
    }
}

