/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo.pool;

import com.questdb.cairo.pool.PoolListener;
import com.questdb.std.FilesFacade;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.MicrosecondClock;
import com.questdb.std.str.ImmutableCharSequence;
import java.io.Closeable;

abstract class AbstractPool
implements Closeable {
    public static final long CLOSED = Unsafe.getFieldOffset(AbstractPool.class, "closed");
    protected static final long UNALLOCATED = -1L;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    protected final CharSequence root;
    protected final FilesFacade ff;
    private final long inactiveTtlUs;
    private final MicrosecondClock clock;
    private PoolListener eventListener;
    private volatile int closed = 0;

    public AbstractPool(FilesFacade ff, MicrosecondClock clock, CharSequence root, long inactiveTtlMs) {
        this.ff = ff;
        this.clock = clock;
        this.root = ImmutableCharSequence.of(root);
        this.inactiveTtlUs = inactiveTtlMs * 1000L;
    }

    @Override
    public final void close() {
        if (Unsafe.getUnsafe().compareAndSwapInt(this, CLOSED, 0, 1)) {
            this.closePool();
        }
    }

    public PoolListener getPoolListener() {
        return this.eventListener;
    }

    public boolean releaseInactive() {
        return this.releaseAll(this.clock.getTicks() - this.inactiveTtlUs);
    }

    public void setPoolListner(PoolListener eventListener) {
        this.eventListener = eventListener;
    }

    protected void closePool() {
        this.releaseAll(Long.MAX_VALUE);
        this.notifyListener(Thread.currentThread().getId(), null, (short)24);
    }

    protected boolean isClosed() {
        return this.closed == 1;
    }

    protected void notifyListener(long thread, CharSequence name, short event) {
        PoolListener listener = this.getPoolListener();
        if (listener != null) {
            listener.onEvent((byte)1, thread, name, event, (short)0, (short)0);
        }
    }

    protected abstract boolean releaseAll(long var1);
}

