/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo.pool;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.pool.AbstractPool;
import com.questdb.cairo.pool.PoolListener;
import com.questdb.cairo.pool.ResourcePool;
import com.questdb.cairo.pool.ex.EntryLockedException;
import com.questdb.cairo.pool.ex.EntryUnavailableException;
import com.questdb.cairo.pool.ex.PoolClosedException;
import com.questdb.common.PoolConstants;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.ConcurrentHashMap;
import com.questdb.std.FilesFacade;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.MicrosecondClock;
import java.util.Arrays;
import java.util.Map;

public class ReaderPool
extends AbstractPool
implements ResourcePool<TableReader> {
    private static final Log LOG = LogFactory.getLog(ReaderPool.class);
    private static final long UNLOCKED = -1L;
    private static final long NEXT_STATUS = Unsafe.getFieldOffset(Entry.class, "nextStatus");
    private static final int ENTRY_SIZE = 32;
    private static final long LOCK_OWNER = Unsafe.getFieldOffset(Entry.class, "lockOwner");
    private static final int NEXT_OPEN = 0;
    private static final int NEXT_ALLOCATED = 1;
    private static final int NEXT_LOCKED = 2;
    private final ConcurrentHashMap<CharSequence, Entry> entries = new ConcurrentHashMap();
    private final int maxSegments;
    private final int maxEntries;
    private final MicrosecondClock clock;

    public ReaderPool(CairoConfiguration configuration) {
        super(configuration.getFilesFacade(), configuration.getClock(), configuration.getRoot(), configuration.getInactiveReaderTTL());
        this.clock = configuration.getClock();
        this.maxSegments = configuration.getReaderPoolSegments();
        this.maxEntries = this.maxSegments * 32;
    }

    @Override
    public TableReader get(CharSequence name) {
        long lockOwner;
        Entry other;
        this.checkClosed();
        Entry e = this.entries.get(name);
        long thread = Thread.currentThread().getId();
        if (e == null && (other = this.entries.putIfAbsent(name, e = new Entry(0, this.clock.getTicks()))) != null) {
            e = other;
        }
        if ((lockOwner = e.lockOwner) != -1L) {
            LOG.info().$('\'').$(name).$("' is locked [owner=").$(lockOwner).$(']').$();
            throw EntryLockedException.INSTANCE;
        }
        do {
            for (int i = 0; i < 32; ++i) {
                if (!Unsafe.cas(e.allocations, i, -1L, thread)) continue;
                R r = Unsafe.arrayGet(e.readers, i);
                if (r == null) {
                    try {
                        LOG.info().$("open '").$(name).$("' [at=").$(e.index).$(':').$(i).$(']').$();
                        r = new R(this.ff, this, e, i, this.root, name);
                    }
                    catch (CairoException ex) {
                        Unsafe.arrayPutOrdered(e.allocations, i, -1L);
                        throw ex;
                    }
                    Unsafe.arrayPut(e.readers, i, r);
                    this.notifyListener(thread, name, (short)10, e.index, i);
                } else {
                    r.reload();
                    this.notifyListener(thread, name, (short)11, e.index, i);
                }
                if (this.isClosed()) {
                    Unsafe.arrayPut(e.readers, i, null);
                    r.goodby();
                    LOG.info().$('\'').$(name).$("' born free").$();
                    return r;
                }
                LOG.info().$('\'').$(name).$("' is assigned [at=").$(e.index).$(':').$(i).$(", thread=").$(thread).$(']').$();
                return r;
            }
            LOG.debug().$("Thread ").$(thread).$(" is moving to entry ").$(e.index + 1).$();
            if (!Unsafe.getUnsafe().compareAndSwapInt(e, NEXT_STATUS, 0, 1)) continue;
            LOG.debug().$("Thread ").$(thread).$(" allocated entry ").$(e.index + 1).$();
            e.next = new Entry(e.index + 1, this.clock.getTicks());
        } while ((e = e.next) != null && e.index < this.maxSegments);
        this.notifyListener(thread, name, (short)25, -1, -1);
        LOG.info().$('\'').$(name).$("' is busy [thread=").$(thread).$(", retries=").$(this.maxSegments).$(']').$();
        throw EntryUnavailableException.INSTANCE;
    }

    public int getBusyCount() {
        int count = 0;
        for (Map.Entry<CharSequence, Entry> me : this.entries.entrySet()) {
            Entry e = me.getValue();
            do {
                for (int i = 0; i < 32; ++i) {
                    if (Unsafe.arrayGetVolatile(e.allocations, i) == -1L || Unsafe.arrayGet(e.readers, i) == null) continue;
                    ++count;
                }
            } while ((e = e.next) != null);
        }
        return count;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public boolean lock(CharSequence name) {
        this.checkClosed();
        Entry e = this.entries.get(name);
        if (e == null) {
            LOG.info().$('\'').$(name).$("' not found, nothing to lock").$();
            return true;
        }
        long thread = Thread.currentThread().getId();
        if (Unsafe.cas(e, LOCK_OWNER, -1L, thread) || Unsafe.cas(e, LOCK_OWNER, thread, thread)) {
            do {
                for (int i = 0; i < 32; ++i) {
                    if (Unsafe.cas(e.allocations, i, -1L, thread)) {
                        this.closeReader(thread, e, i, (short)19, 2);
                        continue;
                    }
                    if (Unsafe.cas(e.allocations, i, thread, thread)) {
                        if (Unsafe.arrayGet(e.readers, i) == null) continue;
                        e.lockOwner = -1L;
                        return false;
                    }
                    LOG.info().$("'").$(name).$("' is busy [at=").$(e.index).$(':').$(i).$(", owner=").$(Unsafe.arrayGet(e.allocations, i)).$(", thread=").$(thread).$(']').$();
                    e.lockOwner = -1L;
                    return false;
                }
                if (e.next != null) continue;
                if (!Unsafe.getUnsafe().compareAndSwapInt(e, NEXT_STATUS, 0, 2)) {
                    if (e.next != null) continue;
                    LOG.info().$("'").$(name).$("' is busy [at=").$(e.index + 1).$(':').$(0).$(", owner=unknown").$(", thread=").$(thread).$(']').$();
                    e.lockOwner = -1L;
                    return false;
                }
                break;
            } while ((e = e.next) != null);
        } else {
            LOG.error().$('\'').$(name).$("' already locked [owner=").$(e.lockOwner).$(']').$();
            this.notifyListener(thread, name, (short)7, -1, -1);
            return false;
        }
        this.notifyListener(thread, name, (short)6, -1, -1);
        LOG.info().$('\'').$(name).$("' locked [thread=").$(thread).$(']').$();
        return true;
    }

    public void unlock(CharSequence name) {
        Entry e = this.entries.get(name);
        long thread = Thread.currentThread().getId();
        if (e == null) {
            LOG.info().$('\'').$(name).$("' not found, cannot unlock").$();
            this.notifyListener(thread, name, (short)9, -1, -1);
            return;
        }
        if (e.lockOwner == thread) {
            this.entries.remove(name);
        }
        this.notifyListener(thread, name, (short)8, -1, -1);
        LOG.info().$('\'').$(name).$("' unlocked").$();
    }

    private void checkClosed() {
        if (this.isClosed()) {
            LOG.info().$("is closed");
            throw PoolClosedException.INSTANCE;
        }
    }

    @Override
    protected void closePool() {
        super.closePool();
        LOG.info().$("closed").$();
    }

    @Override
    protected boolean releaseAll(long deadline) {
        long thread = Thread.currentThread().getId();
        boolean removed = false;
        int closeReason = deadline < Long.MAX_VALUE ? 3 : 1;
        for (Map.Entry<CharSequence, Entry> me : this.entries.entrySet()) {
            Entry e = me.getValue();
            do {
                for (int i = 0; i < 32; ++i) {
                    R r;
                    if (deadline > Unsafe.arrayGetVolatile(e.releaseTimes, i) && Unsafe.arrayGet(e.readers, i) != null) {
                        if (!Unsafe.cas(e.allocations, i, -1L, thread)) continue;
                        if (deadline > Unsafe.arrayGet(e.releaseTimes, i)) {
                            removed = true;
                            this.closeReader(thread, e, i, (short)17, closeReason);
                        }
                        Unsafe.arrayPutOrdered(e.allocations, i, -1L);
                        continue;
                    }
                    if (deadline != Long.MAX_VALUE || (r = Unsafe.arrayGet(e.readers, i)) == null) continue;
                    LOG.info().$("shutting down. '").$(r.getName()).$("' is left behind").$();
                }
            } while ((e = e.next) != null);
        }
        return removed;
    }

    private void closeReader(long thread, Entry entry, int index, short ev, int reason) {
        R r = Unsafe.arrayGet(entry.readers, index);
        if (r != null) {
            r.goodby();
            r.close();
            LOG.info().$("closed '").$(r.getName()).$("' [at=").$(entry.index).$(':').$(index).$(", reason=").$(PoolConstants.closeReasonText(reason)).$(']').$();
            this.notifyListener(thread, r.getName(), ev, entry.index, index);
            Unsafe.arrayPut(entry.readers, index, null);
        }
    }

    private void notifyListener(long thread, CharSequence name, short event, int segment, int position) {
        PoolListener listener = this.getPoolListener();
        if (listener != null) {
            listener.onEvent((byte)2, thread, name, event, (short)segment, (short)position);
        }
    }

    private boolean returnToPool(R reader) {
        CharSequence name = reader.getName();
        long thread = Thread.currentThread().getId();
        int index = reader.index;
        if (Unsafe.arrayGetVolatile(((R)reader).entry.allocations, index) != -1L) {
            if (this.isClosed()) {
                Unsafe.arrayPutOrdered(((R)reader).entry.readers, index, null);
                this.notifyListener(thread, name, (short)2, ((R)reader).entry.index, index);
                LOG.info().$("allowing '").$(name).$("' to close [thread=").$(thread).$(']').$();
                reader.goodby();
                return false;
            }
            LOG.info().$('\'').$(name).$("' is back [at=").$(((R)reader).entry.index).$(':').$(index).$(", thread=").$(thread).$(']').$();
            this.notifyListener(thread, name, (short)1, ((R)reader).entry.index, index);
            Unsafe.arrayPut(((R)reader).entry.releaseTimes, index, this.clock.getTicks());
            Unsafe.arrayPutOrdered(((R)reader).entry.allocations, index, -1L);
            return true;
        }
        LOG.error().$('\'').$(name).$("' is available [at=").$(((R)reader).entry.index).$(':').$(index).$(']');
        return true;
    }

    public static class R
    extends TableReader {
        private final int index;
        private ReaderPool pool;
        private Entry entry;

        public R(FilesFacade ff, ReaderPool pool, Entry entry, int index, CharSequence root, CharSequence name) {
            super(ff, root, name);
            this.pool = pool;
            this.entry = entry;
            this.index = index;
        }

        @Override
        public void close() {
            if (this.pool != null && this.entry != null && this.pool.returnToPool(this)) {
                return;
            }
            super.close();
        }

        private void goodby() {
            this.entry = null;
            this.pool = null;
        }
    }

    private static class Entry {
        final long[] allocations = new long[32];
        final long[] releaseTimes = new long[32];
        final R[] readers = new R[32];
        volatile long lockOwner = -1L;
        long nextStatus = 0L;
        volatile Entry next;
        int index = 0;

        public Entry(int index, long currentMicros) {
            this.index = index;
            Arrays.fill(this.allocations, -1L);
            Arrays.fill(this.releaseTimes, currentMicros);
        }
    }
}

