/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo.pool;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.TableUtils;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.pool.AbstractPool;
import com.questdb.cairo.pool.ResourcePool;
import com.questdb.cairo.pool.ex.EntryLockedException;
import com.questdb.cairo.pool.ex.EntryUnavailableException;
import com.questdb.cairo.pool.ex.PoolClosedException;
import com.questdb.common.PoolConstants;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.ConcurrentHashMap;
import com.questdb.std.Misc;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.MicrosecondClock;
import com.questdb.std.str.Path;
import java.util.Iterator;

public class WriterPool
extends AbstractPool
implements ResourcePool<TableWriter> {
    private static final Log LOG = LogFactory.getLog(WriterPool.class);
    private static final long ENTRY_OWNER = Unsafe.getFieldOffset(Entry.class, "owner");
    private final ConcurrentHashMap<CharSequence, Entry> entries = new ConcurrentHashMap();
    private final CairoConfiguration configuration;
    private final Path path = new Path();
    private final MicrosecondClock clock;
    private final CharSequence root;

    public WriterPool(CairoConfiguration configuration) {
        super(configuration.getFilesFacade(), configuration.getClock(), configuration.getRoot(), configuration.getInactiveWriterTTL());
        this.configuration = configuration;
        this.clock = configuration.getClock();
        this.root = configuration.getRoot();
        this.notifyListener(Thread.currentThread().getId(), null, (short)23);
    }

    @Override
    public TableWriter get(CharSequence tableName) {
        this.checkClosed();
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(tableName);
        if (e == null) {
            e = new Entry(this.clock.getTicks());
            Entry other = this.entries.putIfAbsent(tableName, e);
            if (other == null) {
                return this.createWriter(tableName, e, thread);
            }
            e = other;
        }
        long owner = e.owner;
        if (Unsafe.cas(e, ENTRY_OWNER, -1L, thread)) {
            if (e.writer == null) {
                return this.createWriter(tableName, e, thread);
            }
            if (this.isClosed()) {
                e.writer.goodby();
            }
            return this.logAndReturn(e, (short)11);
        }
        if (e.owner == thread) {
            if (e.lockFd != -1L) {
                throw EntryLockedException.INSTANCE;
            }
            if (e.ex != null) {
                this.notifyListener(thread, tableName, (short)21);
                throw e.ex;
            }
            if (this.isClosed()) {
                LOG.info().$('\'').$(tableName).$("' born free").$();
                e.writer.goodby();
            }
            return this.logAndReturn(e, (short)11);
        }
        LOG.error().$('\'').$(tableName).$("' is busy [owner=").$(owner).$(']').$();
        throw EntryUnavailableException.INSTANCE;
    }

    public int getBusyCount() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            if (e.owner == -1L) continue;
            ++count;
        }
        return count;
    }

    public boolean lock(CharSequence tableName) {
        this.checkClosed();
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(tableName);
        if (e == null) {
            e = new Entry(this.clock.getTicks());
            Entry other = this.entries.putIfAbsent(tableName, e);
            if (other == null) {
                return this.lockAndNotify(thread, e, tableName);
            }
            e = other;
        }
        if (Unsafe.cas(e, ENTRY_OWNER, -1L, thread)) {
            this.closeWriter(thread, e, (short)19, 2);
            return this.lockAndNotify(thread, e, tableName);
        }
        LOG.error().$("cannot lock '").$(tableName).$("', busy [owner=").$(e.owner).$(", thread=").$(thread).$();
        this.notifyListener(thread, tableName, (short)7);
        return false;
    }

    public int size() {
        return this.entries.size();
    }

    public void unlock(CharSequence name) {
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(name);
        if (e == null) {
            this.notifyListener(thread, name, (short)9);
            return;
        }
        if (e.owner == thread) {
            if (e.writer != null) {
                this.notifyListener(thread, name, (short)9);
                throw CairoException.instance(0).put("Writer ").put(name).put(" is not locked");
            }
            this.entries.remove(name);
        }
        if (e.lockFd != -1L) {
            this.ff.close(e.lockFd);
        }
        this.notifyListener(thread, name, (short)8);
    }

    private void checkClosed() {
        if (this.isClosed()) {
            LOG.info().$("is closed").$();
            throw PoolClosedException.INSTANCE;
        }
    }

    @Override
    protected void closePool() {
        super.closePool();
        Misc.free(this.path);
        LOG.info().$("closed").$();
    }

    @Override
    protected boolean releaseAll(long deadline) {
        long thread = Thread.currentThread().getId();
        boolean removed = false;
        int reason = deadline == Long.MAX_VALUE ? 1 : 3;
        Iterator<Entry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            Entry e = iterator.next();
            if (deadline > e.lastReleaseTime && e.owner == -1L) {
                if (!Unsafe.cas(e, ENTRY_OWNER, -1L, thread)) continue;
                this.closeWriter(thread, e, (short)17, reason);
                iterator.remove();
                removed = true;
                continue;
            }
            if (e.lockFd != -1L) {
                if (!this.ff.close(e.lockFd)) continue;
                e.lockFd = -1L;
                iterator.remove();
                removed = true;
                continue;
            }
            if (e.ex == null) continue;
            LOG.info().$("purging entry for failed to allocate writer").$();
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    private void closeWriter(long thread, Entry e, short ev, int reason) {
        PooledTableWriter w = e.writer;
        if (w != null) {
            CharSequence name = e.writer.getName();
            w.goodby();
            w.close();
            e.writer = null;
            LOG.info().$("closed '").$(name).$("' [reason=").$(PoolConstants.closeReasonText(reason)).$(", by=").$(thread).$(']').$();
            this.notifyListener(thread, name, ev);
        }
    }

    int countFreeWriters() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            if (e.owner == -1L) {
                ++count;
                continue;
            }
            LOG.info().$("'").$(e.writer.getName()).$("' is still busy [owner=").$(e.owner).$(']').$();
        }
        return count;
    }

    private PooledTableWriter createWriter(CharSequence name, Entry e, long thread) {
        try {
            this.checkClosed();
            LOG.info().$("open '").$(name).$("' [thread=").$(thread).$(']').$();
            e.writer = new PooledTableWriter(this, e, name);
            return this.logAndReturn(e, (short)10);
        }
        catch (CairoException ex) {
            LOG.error().$("failed to allocate writer '").$(name).$("' [thread=").$(e.owner).$(']').$();
            e.ex = ex;
            this.notifyListener(e.owner, name, (short)14);
            throw ex;
        }
    }

    private boolean lockAndNotify(long thread, Entry e, CharSequence tableName) {
        e.lockFd = TableUtils.lock(this.ff, this.path.of(this.root).concat(tableName));
        if (e.lockFd == -1L) {
            LOG.error().$("cannot lock '").$(tableName).$("' [thread=").$(thread).$(']').$();
            e.owner = -1L;
            return false;
        }
        LOG.info().$('\'').$(tableName).$("' locked [thread=").$(thread).$(']').$();
        this.notifyListener(thread, tableName, (short)6);
        return true;
    }

    private PooledTableWriter logAndReturn(Entry e, short event) {
        LOG.info().$('\'').$(e.writer.getName()).$("' is assigned [thread=").$(e.owner).$(']').$();
        this.notifyListener(e.owner, e.writer.getName(), event);
        return e.writer;
    }

    private boolean returnToPool(Entry e) {
        CharSequence name = e.writer.getName();
        long thread = Thread.currentThread().getId();
        if (e.owner != -1L) {
            LOG.info().$('\'').$(name).$(" is back [thread=").$(thread).$(']').$();
            if (this.isClosed()) {
                LOG.info().$("allowing '").$(name).$("' to close [thread=").$(e.owner).$(']').$();
                e.writer.goodby();
                e.writer = null;
                this.entries.remove(name);
                this.notifyListener(thread, name, (short)2);
                return false;
            }
            e.owner = -1L;
            e.lastReleaseTime = this.configuration.getClock().getTicks();
            this.notifyListener(thread, name, (short)1);
        } else {
            LOG.error().$('\'').$(name).$("' has no owner").$();
            this.notifyListener(thread, name, (short)3);
        }
        return true;
    }

    private static class PooledTableWriter
    extends TableWriter {
        private final WriterPool pool;
        private Entry entry;

        public PooledTableWriter(WriterPool pool, Entry e, CharSequence name) {
            super(pool.ff, pool.root, name, pool.configuration.getMkDirMode(), pool.configuration.getFileOperationRetryCount());
            this.pool = pool;
            this.entry = e;
        }

        @Override
        public void close() {
            if (this.entry != null && this.pool != null && this.pool.returnToPool(this.entry)) {
                return;
            }
            super.close();
        }

        @Override
        public String toString() {
            return "PooledTableWriter{name=" + (this.entry.writer != null ? this.entry.writer.getName() : "<unassigned>") + '}';
        }

        private void goodby() {
            this.entry = null;
        }
    }

    private static class Entry {
        private long owner = Thread.currentThread().getId();
        private PooledTableWriter writer;
        private volatile long lastReleaseTime;
        private CairoException ex = null;
        private volatile long lockFd = -1L;

        public Entry(long lastReleaseTime) {
            this.lastReleaseTime = lastReleaseTime;
        }
    }
}

