/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.common;

import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.IntIntHashMap;
import com.questdb.std.IntObjHashMap;
import com.questdb.std.ObjIntHashMap;
import com.questdb.std.str.StringSink;
import java.nio.ByteBuffer;

public final class ColumnType {
    public static final int BOOLEAN = 0;
    public static final int BYTE = 1;
    public static final int DOUBLE = 2;
    public static final int FLOAT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int SHORT = 6;
    public static final int STRING = 7;
    public static final int SYMBOL = 8;
    public static final int BINARY = 9;
    public static final int DATE = 10;
    public static final int TIMESTAMP = 12;
    public static final int PARAMETER = 11;
    private static final ObjIntHashMap<Class> classMap = new ObjIntHashMap();
    private static final IntIntHashMap sizeMap = new IntIntHashMap();
    private static final IntObjHashMap<String> typeNameMap = new IntObjHashMap();
    private static final CharSequenceIntHashMap nameTypeMap = new CharSequenceIntHashMap();
    private static final ThreadLocal<StringSink> caseConverterBuffer = ThreadLocal.withInitial(StringSink::new);

    private ColumnType() {
    }

    public static int columnTypeOf(Class clazz) {
        return classMap.get(clazz);
    }

    public static int columnTypeOf(CharSequence name) {
        StringSink b = caseConverterBuffer.get();
        b.clear();
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            b.put(Character.toUpperCase(name.charAt(i)));
        }
        return nameTypeMap.get(b);
    }

    public static int count() {
        return typeNameMap.size();
    }

    public static String nameOf(int columnType) {
        String name = typeNameMap.get(columnType);
        return name != null ? name : "unknown";
    }

    public static int sizeOf(int columnType) {
        return sizeMap.get(columnType);
    }

    static {
        classMap.put(Boolean.TYPE, 0);
        classMap.put(Byte.TYPE, 1);
        classMap.put(Double.TYPE, 2);
        classMap.put(Float.TYPE, 3);
        classMap.put(Integer.TYPE, 4);
        classMap.put(Long.TYPE, 5);
        classMap.put(Short.TYPE, 6);
        classMap.put(String.class, 7);
        classMap.put(ByteBuffer.class, 9);
        sizeMap.put(0, 1);
        sizeMap.put(1, 1);
        sizeMap.put(2, 8);
        sizeMap.put(3, 4);
        sizeMap.put(4, 4);
        sizeMap.put(5, 8);
        sizeMap.put(6, 2);
        sizeMap.put(7, 0);
        sizeMap.put(8, 4);
        sizeMap.put(9, 0);
        sizeMap.put(10, 8);
        sizeMap.put(11, 0);
        sizeMap.put(12, 8);
        typeNameMap.put(0, "BOOLEAN");
        typeNameMap.put(1, "BYTE");
        typeNameMap.put(2, "DOUBLE");
        typeNameMap.put(3, "FLOAT");
        typeNameMap.put(4, "INT");
        typeNameMap.put(5, "LONG");
        typeNameMap.put(6, "SHORT");
        typeNameMap.put(7, "STRING");
        typeNameMap.put(8, "SYMBOL");
        typeNameMap.put(9, "BINARY");
        typeNameMap.put(10, "DATE");
        typeNameMap.put(11, "PARAMETER");
        typeNameMap.put(12, "TIMESTAMP");
        nameTypeMap.put("BOOLEAN", 0);
        nameTypeMap.put("BYTE", 1);
        nameTypeMap.put("DOUBLE", 2);
        nameTypeMap.put("FLOAT", 3);
        nameTypeMap.put("INT", 4);
        nameTypeMap.put("LONG", 5);
        nameTypeMap.put("SHORT", 6);
        nameTypeMap.put("STRING", 7);
        nameTypeMap.put("SYMBOL", 8);
        nameTypeMap.put("BINARY", 9);
        nameTypeMap.put("DATE", 10);
        nameTypeMap.put("PARAMETER", 11);
        nameTypeMap.put("TIMESTAMP", 12);
    }
}

