/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.client;

import com.questdb.std.Chars;
import com.questdb.std.Net;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.CharSink;
import java.io.Closeable;

public class LineProtoSender
extends AbstractCharSink
implements Closeable {
    private final int capacity;
    private final long bufA;
    private final long bufB;
    private final long sockaddr;
    private final long fd;
    private long lo;
    private long hi;
    private long ptr;
    private long lineStart;
    private boolean hasMetric = false;
    private boolean noFields = true;

    public LineProtoSender(CharSequence ipv4Address, int port, int capacity) {
        this.capacity = capacity;
        this.sockaddr = Net.sockaddr(ipv4Address, port);
        this.fd = Net.socketUdp();
        this.bufA = Unsafe.malloc(capacity);
        this.bufB = Unsafe.malloc(capacity);
        this.lo = this.bufA;
        this.hi = this.lo + (long)capacity;
        this.ptr = this.lo;
        this.lineStart = this.lo;
    }

    public void $(long timestamp) {
        this.put(' ').put(timestamp);
        this.$();
    }

    public LineProtoSender $() {
        this.put('\n');
        this.lineStart = this.ptr;
        this.hasMetric = false;
        this.noFields = true;
        return this;
    }

    @Override
    public void close() {
        Net.close(this.fd);
        Net.freeSockAddr(this.sockaddr);
        Unsafe.free(this.bufA, this.capacity);
        Unsafe.free(this.bufB, this.capacity);
    }

    public LineProtoSender field(CharSequence name, long value) {
        this.field(name).put(value).put('i');
        return this;
    }

    public LineProtoSender field(CharSequence name, CharSequence value) {
        this.field(name).putQuoted(value);
        return this;
    }

    public LineProtoSender field(CharSequence name, double value, int scale) {
        this.field(name).put(value, scale);
        return this;
    }

    @Override
    public void flush() {
        this.send();
        this.ptr = this.lineStart = this.lo;
    }

    @Override
    public LineProtoSender put(CharSequence cs) {
        int l = cs.length();
        if (this.ptr + (long)l < this.hi) {
            Chars.strcpy(cs, l, this.ptr);
        } else {
            this.send00();
            if (this.ptr + (long)l < this.hi) {
                Chars.strcpy(cs, l, this.ptr);
            } else {
                throw new RuntimeException("too much!");
            }
        }
        this.ptr += (long)l;
        return this;
    }

    @Override
    public LineProtoSender put(char c) {
        if (this.ptr >= this.hi) {
            this.send00();
        }
        Unsafe.getUnsafe().putByte(this.ptr++, (byte)c);
        return this;
    }

    public LineProtoSender metric(CharSequence metric) {
        if (this.hasMetric) {
            throw new RuntimeException();
        }
        this.hasMetric = true;
        return this.put(metric);
    }

    public LineProtoSender tag(CharSequence tag, CharSequence value) {
        if (this.hasMetric) {
            this.put(',').putNameEscaped(tag).put('=').encodeUtf8(value);
            return this;
        }
        throw new RuntimeException();
    }

    private CharSink field(CharSequence name) {
        if (!this.hasMetric) {
            throw new RuntimeException();
        }
        if (this.noFields) {
            this.put(' ');
            this.noFields = false;
        } else {
            this.put(',');
        }
        return this.putNameEscaped(name).put('=');
    }

    private LineProtoSender putNameEscaped(CharSequence name) {
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            switch (c) {
                case ' ': 
                case ',': 
                case '=': {
                    this.put('\\');
                }
            }
            this.put(c);
        }
        return this;
    }

    private void send() {
        if (this.lo < this.lineStart) {
            Net.sendTo(this.fd, this.lo, (int)(this.lineStart - this.lo), this.sockaddr);
        }
    }

    private void send00() {
        int len = (int)(this.ptr - this.lineStart);
        if (len == 0) {
            this.send();
            this.ptr = this.lineStart = this.lo;
        } else if (len < this.capacity) {
            long target = this.lo == this.bufA ? this.bufB : this.bufA;
            Unsafe.getUnsafe().copyMemory(this.lineStart, target, len);
            this.send();
            this.lineStart = this.lo = target;
            this.ptr = target + (long)len;
            this.hi = this.lo + (long)this.capacity;
        } else {
            throw new RuntimeException("too big!");
        }
    }
}

