/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.receiver;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.pool.ResourcePool;
import com.questdb.cutlass.receiver.ReceiverConfiguration;
import com.questdb.cutlass.receiver.parser.CairoLineProtoParser;
import com.questdb.cutlass.receiver.parser.LineProtoLexer;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.Job;
import com.questdb.std.NetFacade;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;

public class GenericLineProtoReceiver
implements Closeable,
Job {
    private static final Log LOG = LogFactory.getLog(GenericLineProtoReceiver.class);
    private final DirectByteCharSequence byteSequence = new DirectByteCharSequence();
    private final LineProtoLexer lexer;
    private final CairoLineProtoParser parser;
    private final NetFacade nf;
    private final int bufLen;
    private long fd = -1L;
    private int commitRate;
    private long totalCount = 0L;
    private long buf;

    public GenericLineProtoReceiver(ReceiverConfiguration receiverCfg, CairoConfiguration cairoCfg, ResourcePool<TableWriter> writerPool) {
        this.nf = receiverCfg.getNetFacade();
        this.fd = this.nf.socketUdp();
        if (this.fd < 0L) {
            int errno = Os.errno();
            LOG.error().$("cannot open UDP socket [errno=").$(errno).$(']').$();
            throw CairoException.instance(errno).put("Cannot open UDP socket");
        }
        try {
            if (!this.nf.bindUdp(this.fd, receiverCfg.getBindIPv4Address(), receiverCfg.getPort())) {
                int errno = Os.errno();
                LOG.error().$("cannot bind socket [errno=").$(errno).$(", fd=").$(this.fd).$(", bind=").$(receiverCfg.getBindIPv4Address()).$(", port=").$(receiverCfg.getPort()).$(']').$();
                throw CairoException.instance(Os.errno()).put("Cannot bind to ").put(receiverCfg.getBindIPv4Address()).put(':').put(receiverCfg.getPort());
            }
            if (!this.nf.join(this.fd, receiverCfg.getBindIPv4Address(), receiverCfg.getGroupIPv4Address())) {
                int errno = Os.errno();
                LOG.error().$("cannot join group [errno=").$(errno).$(", fd=").$(this.fd).$(", bind=").$(receiverCfg.getBindIPv4Address()).$(", group=").$(receiverCfg.getGroupIPv4Address()).$(']').$();
                throw CairoException.instance(Os.errno()).put("Cannot join group ").put(receiverCfg.getGroupIPv4Address()).put(" [bindTo=").put(receiverCfg.getBindIPv4Address()).put(']');
            }
        }
        catch (CairoException e) {
            this.close();
            throw e;
        }
        this.commitRate = receiverCfg.getCommitRate();
        if (receiverCfg.getReceiveBufferSize() != -1 && this.nf.setRcvBuf(this.fd, receiverCfg.getReceiveBufferSize()) != 0) {
            LOG.error().$("cannot set receive buffer size [fd=").$(this.fd).$(", size=").$(receiverCfg.getReceiveBufferSize()).$(']').$();
        }
        this.bufLen = receiverCfg.getMsgBufferSize();
        this.buf = Unsafe.malloc(this.bufLen);
        this.lexer = new LineProtoLexer(receiverCfg.getMsgBufferSize());
        this.parser = new CairoLineProtoParser(cairoCfg, writerPool);
        this.lexer.withParser(this.parser);
        LOG.info().$("started [fd=").$(this.fd).$(", bind=").$(receiverCfg.getBindIPv4Address()).$(", group=").$(receiverCfg.getGroupIPv4Address()).$(", port=").$(receiverCfg.getPort()).$(", commitRate=").$(this.commitRate).$(']').$();
    }

    @Override
    public void close() {
        if (this.fd > -1L) {
            this.nf.close(this.fd);
            if (this.buf != 0L) {
                Unsafe.free(this.buf, this.bufLen);
            }
            if (this.parser != null) {
                this.parser.commitAll();
                this.parser.close();
            }
            LOG.info().$("closed [fd=").$(this.fd).$(']').$();
            this.fd = -1L;
        }
    }

    @Override
    public boolean run() {
        int count;
        boolean ran = false;
        while ((count = this.nf.recv(this.fd, this.buf, this.bufLen)) > 0) {
            this.byteSequence.of(this.buf, this.buf + (long)count);
            this.lexer.parse(this.byteSequence);
            this.lexer.parseLast();
            ++this.totalCount;
            if (this.totalCount > (long)this.commitRate) {
                this.totalCount = 0L;
                this.parser.commitAll();
            }
            if (ran) continue;
            ran = true;
        }
        this.parser.commitAll();
        return ran;
    }
}

