/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.receiver.parser;

import com.questdb.cairo.AppendMemory;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.TableUtils;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.pool.ResourcePool;
import com.questdb.common.ColumnType;
import com.questdb.common.NumericException;
import com.questdb.common.RecordMetadata;
import com.questdb.cutlass.receiver.parser.CachedCharSequence;
import com.questdb.cutlass.receiver.parser.CharSequenceCache;
import com.questdb.cutlass.receiver.parser.LineProtoParser;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.LongList;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.microtime.MicrosecondClock;
import com.questdb.std.str.ImmutableCharSequence;
import com.questdb.std.str.Path;
import java.io.Closeable;

public class CairoLineProtoParser
implements LineProtoParser,
Closeable {
    private static final Log LOG = LogFactory.getLog(CairoLineProtoParser.class);
    private static final LineEndParser NOOP_LINE_END = cache -> {};
    private static final FieldValueParser NOOP_FIELD_VALUE = (value, cache) -> {};
    private static final FieldNameParser NOOP_FIELD_NAME = name -> {};
    private final ResourcePool<TableWriter> pool;
    private final CharSequenceObjHashMap<CacheEntry> writerCache = new CharSequenceObjHashMap();
    private final CharSequenceObjHashMap<TableWriter> commitList = new CharSequenceObjHashMap();
    private final Path path = new Path();
    private final CairoConfiguration configuration;
    private final LongList columnNameType = new LongList();
    private final LongList columnValues = new LongList();
    private final AppendMemory appendMemory = new AppendMemory();
    private final MicrosecondClock clock;
    private final FieldNameParser MY_NEW_FIELD_NAME = this::parseFieldNameNewTable;
    private final FieldValueParser MY_NEW_TAG_VALUE = this::parseTagValueNewTable;
    private int cacheEntryIndex = 0;
    private TableWriter writer;
    private final LineEndParser MY_LINE_END = this::appendRow;
    private RecordMetadata metadata;
    private int columnCount;
    private int columnIndex;
    private long columnName;
    private int columnType;
    private final FieldNameParser MY_FIELD_NAME = this::parseFieldName;
    private long tableName;
    private final LineEndParser MY_NEW_LINE_END = this::createTableAndAppendRow;
    private LineEndParser onLineEnd;
    private FieldNameParser onFieldName;
    private FieldValueParser onFieldValue;
    private FieldValueParser onTagValue;
    private final FieldValueParser MY_FIELD_VALUE = this::parseFieldValue;
    private final FieldValueParser MY_NEW_FIELD_VALUE = this::parseFieldValueNewTable;
    private final FieldValueParser MY_TAG_VALUE = this::parseTagValue;

    public CairoLineProtoParser(CairoConfiguration configuration, ResourcePool<TableWriter> pool) {
        this.configuration = configuration;
        this.clock = configuration.getClock();
        this.pool = pool;
    }

    @Override
    public void close() {
        Misc.free(this.path);
        Misc.free(this.appendMemory);
        int n = this.writerCache.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.writerCache.valueQuick(i).writer);
        }
    }

    public void commitAll() {
        if (this.writer != null) {
            this.writer.commit();
        }
        int n = this.commitList.size();
        for (int i = 0; i < n; ++i) {
            this.commitList.valueQuick(i).commit();
        }
        this.commitList.clear();
    }

    @Override
    public void onError(int position, int state, int code) {
        this.clearState();
    }

    @Override
    public void onEvent(CachedCharSequence token, int eventType, CharSequenceCache cache) {
        switch (eventType) {
            case 1: {
                int wrtIndex = this.writerCache.keyIndex(token);
                if (wrtIndex == this.cacheEntryIndex) {
                    if (this.writer != null) {
                        this.switchModeToAppend();
                        break;
                    }
                    this.initCacheEntry(token, this.writerCache.valueAt(wrtIndex));
                    break;
                }
                this.switchTable(token, wrtIndex);
                break;
            }
            case 4: 
            case 5: {
                this.onFieldName.parse(token);
                break;
            }
            case 2: {
                this.onTagValue.parse(token, cache);
                break;
            }
            case 3: {
                this.onFieldValue.parse(token, cache);
                break;
            }
            case 6: {
                this.columnValues.add(token.getCacheAddress());
                break;
            }
        }
    }

    @Override
    public void onLineEnd(CharSequenceCache cache) {
        try {
            this.onLineEnd.parse(cache);
        }
        catch (CairoException e) {
            LOG.error().$(e).$();
        }
        this.clearState();
    }

    private void appendFirstRowAndCacheWriter(CharSequenceCache cache) {
        TableWriter.Row row;
        TableWriter writer;
        this.writer = writer = this.pool.get(cache.get(this.tableName));
        this.metadata = writer.getMetadata();
        this.columnCount = this.metadata.getColumnCount();
        this.writerCache.valueAt(this.cacheEntryIndex).writer = writer;
        int columnCount = this.columnNameType.size() / 2;
        int valueCount = this.columnValues.size();
        if (columnCount == valueCount) {
            row = writer.newRow(this.clock.getTicks());
        } else {
            try {
                row = writer.newRow(Numbers.parseLong(cache.get(this.columnValues.getQuick(valueCount - 1))));
            }
            catch (NumericException e) {
                LOG.error().$("invalid timestamp: ").$(cache.get(this.columnValues.getQuick(valueCount - 1))).$();
                return;
            }
        }
        try {
            for (int i = 0; i < columnCount; ++i) {
                this.putValue(row, i, (int)this.columnNameType.getQuick(i * 2 + 1), cache.get(this.columnValues.getQuick(i)));
            }
            row.append();
        }
        catch (BadCastException ignore) {
            row.cancel();
        }
    }

    private void appendRow(CharSequenceCache cache) {
        TableWriter.Row row;
        int valueCount;
        int columnCount = this.columnNameType.size() / 2;
        if (columnCount == (valueCount = this.columnValues.size())) {
            row = this.writer.newRow(this.clock.getTicks());
        } else {
            try {
                row = this.writer.newRow(Numbers.parseLong(cache.get(this.columnValues.getQuick(valueCount - 1))));
            }
            catch (NumericException e) {
                LOG.error().$("invalid timestamp: ").$(cache.get(this.columnValues.getQuick(valueCount - 1))).$();
                return;
            }
        }
        try {
            for (int i = 0; i < columnCount; ++i) {
                this.putValue(row, (int)this.columnNameType.getQuick(i * 2), (int)this.columnNameType.getQuick(i * 2 + 1), cache.get(this.columnValues.getQuick(i)));
            }
            row.append();
        }
        catch (BadCastException ignore) {
            row.cancel();
        }
    }

    private void cacheWriter(CacheEntry entry, CachedCharSequence tableName) {
        try {
            entry.writer = this.pool.get(tableName);
            this.tableName = tableName.getCacheAddress();
            this.createState(entry);
        }
        catch (CairoException ex) {
            LOG.error().$(ex).$();
            this.switchModeToSkipLine();
        }
    }

    private void clearState() {
        this.columnNameType.clear();
        this.columnValues.clear();
    }

    private void createState(CacheEntry entry) {
        this.writer = entry.writer;
        this.metadata = this.writer.getMetadata();
        this.columnCount = this.metadata.getColumnCount();
        this.switchModeToAppend();
    }

    private void createTable(CharSequenceCache cache) {
        this.path.of(this.configuration.getRoot()).concat(cache.get(this.tableName));
        int rootLen = this.path.length();
        if (this.configuration.getFilesFacade().mkdirs(this.path.put(Files.SEPARATOR).$(), this.configuration.getMkDirMode()) == -1) {
            throw CairoException.instance(0).put("cannot create directory: ").put(this.path);
        }
        try (AppendMemory mem = this.appendMemory;){
            int i;
            mem.of(this.configuration.getFilesFacade(), this.path.trimTo(rootLen).concat("_meta").$(), this.configuration.getFilesFacade().getPageSize());
            int count = this.columnNameType.size() / 2;
            mem.putInt(count + 1);
            mem.putInt(3);
            mem.putInt(count);
            for (i = 0; i < count; ++i) {
                mem.putInt((int)this.columnNameType.getQuick(i * 2 + 1));
            }
            mem.putInt(12);
            for (i = 0; i < count; ++i) {
                mem.putStr(cache.get(this.columnNameType.getQuick(i * 2)));
            }
            mem.putStr("timestamp");
            mem.of(this.configuration.getFilesFacade(), this.path.trimTo(rootLen).concat("_txn").$(), this.configuration.getFilesFacade().getPageSize());
            TableUtils.resetTxn(mem);
        }
    }

    private void createTableAndAppendRow(CharSequenceCache cache) {
        this.createTable(cache);
        this.appendFirstRowAndCacheWriter(cache);
    }

    private int getValueType(CharSequence token) {
        int len = token.length();
        char c = token.charAt(len - 1);
        switch (c) {
            case 'i': {
                return 4;
            }
            case 'e': {
                return 0;
            }
            case '\"': {
                if (len < 2 || token.charAt(0) != '\"') {
                    LOG.error().$("incorrectly quoted string: ").$(token).$();
                    return -1;
                }
                return 7;
            }
        }
        return 2;
    }

    private void initCacheEntry(CachedCharSequence token, CacheEntry entry) {
        block0 : switch (entry.state) {
            case 0: {
                int exists = TableUtils.exists(this.configuration.getFilesFacade(), this.path, this.configuration.getRoot(), token);
                switch (exists) {
                    case 0: {
                        entry.state = 1;
                        this.cacheWriter(entry, token);
                        break;
                    }
                    case 1: {
                        this.tableName = token.getCacheAddress();
                        if (this.onLineEnd == this.MY_NEW_LINE_END) break block0;
                        this.onLineEnd = this.MY_NEW_LINE_END;
                        this.onFieldName = this.MY_NEW_FIELD_NAME;
                        this.onFieldValue = this.MY_NEW_FIELD_VALUE;
                        this.onTagValue = this.MY_NEW_TAG_VALUE;
                        break;
                    }
                    default: {
                        entry.state = 3;
                        this.switchModeToSkipLine();
                        break;
                    }
                }
                break;
            }
            case 1: {
                this.cacheWriter(entry, token);
                break;
            }
            default: {
                this.switchModeToSkipLine();
            }
        }
    }

    private void parseFieldName(CachedCharSequence token) {
        this.columnIndex = this.metadata.getColumnIndexQuiet(token);
        if (this.columnIndex == -1) {
            this.columnName = token.getCacheAddress();
        } else {
            this.columnType = this.metadata.getColumnQuick(this.columnIndex).getType();
        }
    }

    private void parseFieldNameNewTable(CachedCharSequence token) {
        this.columnNameType.add(token.getCacheAddress());
    }

    private void parseFieldValue(CachedCharSequence value, CharSequenceCache cache) {
        int valueType = this.getValueType(value);
        if (valueType == -1) {
            this.switchModeToSkipLine();
        } else {
            this.parseValue(value, valueType, cache);
        }
    }

    private void parseFieldValueNewTable(CachedCharSequence value, CharSequenceCache cache) {
        int valueType = this.getValueType(value);
        if (valueType == -1) {
            this.switchModeToSkipLine();
        } else {
            this.parseValueNewTable(value, valueType);
        }
    }

    private void parseTagValue(CachedCharSequence value, CharSequenceCache cache) {
        this.parseValue(value, 8, cache);
    }

    private void parseTagValueNewTable(CachedCharSequence value, CharSequenceCache cache) {
        this.parseValueNewTable(value, 8);
    }

    private void parseValue(CachedCharSequence value, int valueType, CharSequenceCache cache) {
        if (this.columnIndex == -1) {
            this.columnNameType.add(this.columnCount++);
            this.columnNameType.add(valueType);
            this.writer.addColumn(cache.get(this.columnName), valueType);
        } else if (this.columnType != valueType) {
            LOG.error().$("mismatched column and value types [table=").$(this.writer.getName()).$(", column=").$(this.metadata.getColumnQuick(this.columnIndex).getName()).$(", columnType=").$(ColumnType.nameOf(this.columnType)).$(", valueType=").$(ColumnType.nameOf(valueType)).$(']').$();
            this.switchModeToSkipLine();
        } else {
            this.columnNameType.add(this.columnIndex);
            this.columnNameType.add(valueType);
        }
        this.columnValues.add(value.getCacheAddress());
    }

    private void parseValueNewTable(CachedCharSequence value, int valueType) {
        this.columnNameType.add(valueType);
        this.columnValues.add(value.getCacheAddress());
    }

    private void putValue(TableWriter.Row row, int index, int columnType, CharSequence value) throws BadCastException {
        switch (columnType) {
            case 4: {
                try {
                    row.putInt(index, Numbers.parseInt(value, 0, value.length() - 1));
                    break;
                }
                catch (NumericException e) {
                    LOG.error().$("not an INT: ").$(value).$();
                    throw BadCastException.INSTANCE;
                }
            }
            case 2: {
                try {
                    row.putDouble(index, Numbers.parseDouble(value));
                    break;
                }
                catch (NumericException e) {
                    LOG.error().$("not a DOUBLE: ").$(value).$();
                    throw BadCastException.INSTANCE;
                }
            }
            case 0: {
                row.putBool(index, Chars.equals(value, "true"));
                break;
            }
            case 7: {
                row.putStr(index, value, 1, value.length() - 2);
                break;
            }
            case 8: {
                row.putStr(index, value);
            }
        }
    }

    private void switchModeToAppend() {
        if (this.onLineEnd != this.MY_LINE_END) {
            this.onLineEnd = this.MY_LINE_END;
            this.onFieldName = this.MY_FIELD_NAME;
            this.onFieldValue = this.MY_FIELD_VALUE;
            this.onTagValue = this.MY_TAG_VALUE;
        }
    }

    private void switchModeToSkipLine() {
        if (this.onFieldValue != NOOP_FIELD_VALUE) {
            this.onFieldValue = NOOP_FIELD_VALUE;
            this.onFieldName = NOOP_FIELD_NAME;
            this.onTagValue = NOOP_FIELD_VALUE;
            this.onLineEnd = NOOP_LINE_END;
        }
    }

    private void switchTable(CachedCharSequence tableName, int entryIndex) {
        CacheEntry entry;
        CacheEntry e;
        if (this.cacheEntryIndex != 0 && (e = this.writerCache.valueAt(this.cacheEntryIndex)).writer != null) {
            this.commitList.put(e.writer.getName(), e.writer);
        }
        if (entryIndex < 0) {
            entry = this.writerCache.valueAt(entryIndex);
        } else {
            entry = new CacheEntry();
            this.writerCache.putAt(entryIndex, ImmutableCharSequence.of(tableName), entry);
            entryIndex = -entryIndex - 1;
        }
        this.cacheEntryIndex = entryIndex;
        if (entry.writer == null) {
            this.initCacheEntry(tableName, entry);
        } else {
            this.createState(entry);
        }
    }

    private class CacheEntry {
        private TableWriter writer;
        private int state = 0;

        private CacheEntry() {
        }
    }

    private static class BadCastException
    extends Exception {
        private static final BadCastException INSTANCE = new BadCastException();

        private BadCastException() {
        }
    }

    @FunctionalInterface
    private static interface FieldValueParser {
        public void parse(CachedCharSequence var1, CharSequenceCache var2);
    }

    @FunctionalInterface
    private static interface FieldNameParser {
        public void parse(CachedCharSequence var1);
    }

    @FunctionalInterface
    private static interface LineEndParser {
        public void parse(CharSequenceCache var1);
    }
}

