/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.receiver.parser;

import com.questdb.cutlass.receiver.parser.CachedCharSequence;
import com.questdb.cutlass.receiver.parser.CharSequenceCache;
import com.questdb.cutlass.receiver.parser.LineProtoException;
import com.questdb.cutlass.receiver.parser.LineProtoParser;
import com.questdb.cutlass.receiver.parser.Utf8RepairContinue;
import com.questdb.std.Chars;
import com.questdb.std.Mutable;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.ByteSequence;
import com.questdb.std.str.CharSink;

public class LineProtoLexer
implements Mutable {
    private final ArrayBackedCharSink sink = new ArrayBackedCharSink();
    private final ArrayBackedCharSequence cs = new ArrayBackedCharSequence();
    private final ArrayBackedByteSequence utf8ErrorSeq = new ArrayBackedByteSequence();
    private final FloatingCharSequence floatingCharSequence = new FloatingCharSequence();
    private final CharSequenceCache charSequenceCache = address -> {
        this.floatingCharSequence.lo = (int)(address >> 32);
        this.floatingCharSequence.hi = (int)address - 1;
        return this.floatingCharSequence;
    };
    private int state = 1;
    private boolean escape = false;
    private char[] buffer;
    private int dstPos = 0;
    private int dstTop = 0;
    private boolean skipLine = false;
    private LineProtoParser parser;
    private int utf8ErrorTop;
    private int utf8ErrorPos;
    private int errorCode = 0;

    public LineProtoLexer(int bufferSize) {
        this.buffer = new char[bufferSize];
    }

    @Override
    public final void clear() {
        this.escape = false;
        this.state = 1;
        this.dstPos = 0;
        this.dstTop = 0;
        this.utf8ErrorPos = -1;
        this.utf8ErrorTop = -1;
        this.skipLine = false;
        this.errorCode = 0;
    }

    public void parse(ByteSequence bytes) {
        int srcPos = 0;
        int len = bytes.length();
        block28: while (srcPos < len) {
            byte b = bytes.byteAt(srcPos);
            if (this.skipLine) {
                switch (b) {
                    case 10: 
                    case 13: {
                        this.clear();
                        break;
                    }
                }
                ++srcPos;
                continue;
            }
            if (this.escape) {
                --this.dstPos;
            }
            try {
                block33: {
                    if (b < 0) {
                        try {
                            srcPos = this.utf8Decode(bytes, srcPos, len, b);
                            break block33;
                        }
                        catch (Utf8RepairContinue e) {
                            break;
                        }
                    }
                    this.sink.put((char)b);
                    ++srcPos;
                }
                if (this.escape) {
                    this.escape = false;
                    ++this.dstPos;
                    continue;
                }
                char c = Unsafe.arrayGet(this.buffer, this.dstPos++);
                block5 : switch (c) {
                    case ',': {
                        switch (this.state) {
                            case 1: {
                                this.fireEvent();
                                this.state = 4;
                                break block5;
                            }
                            case 2: {
                                this.fireEvent();
                                this.state = 4;
                                break block5;
                            }
                            case 3: {
                                this.fireEvent();
                                this.state = 5;
                                break block5;
                            }
                        }
                        this.errorCode = 1;
                        throw LineProtoException.INSTANCE;
                    }
                    case '=': {
                        switch (this.state) {
                            case 4: {
                                this.fireEvent();
                                this.state = 2;
                                break block5;
                            }
                            case 5: {
                                this.fireEvent();
                                this.state = 3;
                                break block5;
                            }
                        }
                        this.errorCode = 1;
                        throw LineProtoException.INSTANCE;
                    }
                    case '\\': {
                        this.escape = true;
                        continue block28;
                    }
                    case ' ': {
                        switch (this.state) {
                            case 1: {
                                this.fireEvent();
                                this.state = 5;
                                break block5;
                            }
                            case 2: {
                                this.fireEvent();
                                this.state = 5;
                                break block5;
                            }
                            case 3: {
                                this.fireEvent();
                                this.state = 6;
                                break block5;
                            }
                        }
                        this.errorCode = 1;
                        throw LineProtoException.INSTANCE;
                    }
                    case '\n': 
                    case '\r': {
                        this.consumeLineEnd();
                        break;
                    }
                    default: {
                        continue block28;
                    }
                }
                this.dstTop = this.dstPos;
            }
            catch (LineProtoException ex) {
                this.skipLine = true;
                this.parser.onError(this.dstPos - 1, this.state, this.errorCode);
            }
        }
    }

    public void parseLast() {
        if (!this.skipLine) {
            ++this.dstPos;
            try {
                this.consumeLineEnd();
            }
            catch (LineProtoException e) {
                this.parser.onError(this.dstPos - 1, this.state, this.errorCode);
            }
        }
        this.clear();
    }

    public void withParser(LineProtoParser parser) {
        this.parser = parser;
    }

    private void consumeLineEnd() throws LineProtoException {
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                this.fireEvent();
                this.parser.onLineEnd(this.charSequenceCache);
                this.clear();
                break;
            }
            default: {
                this.errorCode = 1;
                throw LineProtoException.INSTANCE;
            }
        }
    }

    private void fireEvent() throws LineProtoException {
        if (this.dstTop >= this.dstPos - 1) {
            this.errorCode = 3;
            throw LineProtoException.INSTANCE;
        }
        this.parser.onEvent(this.cs, this.state, this.charSequenceCache);
    }

    private int repairMultiByteChar(byte b, ByteSequence bytes, int pos, int len) throws LineProtoException {
        int n = -1;
        while (true) {
            if (this.utf8ErrorTop == -1) {
                this.utf8ErrorTop = this.utf8ErrorPos = this.dstPos + 1;
            }
            ++this.utf8ErrorPos;
            this.dstPos = this.dstPos;
            this.sink.put((char)b);
            int errorLen = this.utf8ErrorSeq.length();
            if (errorLen > 1) {
                this.dstPos = this.utf8ErrorTop - 1;
                n = Chars.utf8DecodeMultiByte(this.utf8ErrorSeq, this.utf8ErrorSeq.byteAt(0), 0, errorLen, this.sink);
            }
            if (n == -1 && errorLen > 3) {
                this.errorCode = 2;
                throw LineProtoException.INSTANCE;
            }
            if (n != -1 || ++pos >= len) break;
            b = bytes.byteAt(pos);
        }
        this.dstPos = this.utf8ErrorTop - 1;
        if (n > 0) {
            this.utf8ErrorPos = -1;
            this.utf8ErrorTop = -1;
            return pos + 1;
        }
        throw Utf8RepairContinue.INSTANCE;
    }

    private int utf8Decode(ByteSequence bytes, int srcPos, int len, byte b) throws LineProtoException {
        int n = Chars.utf8DecodeMultiByte(bytes, b, srcPos, len, this.sink);
        srcPos = n == -1 ? this.repairMultiByteChar(b, bytes, srcPos, len) : (srcPos += n);
        return srcPos;
    }

    static /* synthetic */ char[] access$502(LineProtoLexer x0, char[] x1) {
        x0.buffer = x1;
        return x1;
    }

    private class ArrayBackedByteSequence
    implements ByteSequence {
        private ArrayBackedByteSequence() {
        }

        @Override
        public byte byteAt(int index) {
            return (byte)Unsafe.arrayGet(LineProtoLexer.this.buffer, LineProtoLexer.this.utf8ErrorTop + index);
        }

        @Override
        public int length() {
            return LineProtoLexer.this.utf8ErrorPos - LineProtoLexer.this.utf8ErrorTop;
        }
    }

    private class FloatingCharSequence
    extends AbstractCharSequence {
        int lo;
        int hi;

        private FloatingCharSequence() {
        }

        @Override
        public int length() {
            return this.hi - this.lo;
        }

        @Override
        public char charAt(int index) {
            return Unsafe.arrayGet(LineProtoLexer.this.buffer, this.lo + index);
        }
    }

    private class ArrayBackedCharSequence
    extends AbstractCharSequence
    implements CachedCharSequence {
        private ArrayBackedCharSequence() {
        }

        @Override
        public long getCacheAddress() {
            return (long)LineProtoLexer.this.dstTop << 32 | (long)LineProtoLexer.this.dstPos;
        }

        @Override
        public int length() {
            return LineProtoLexer.this.dstPos - LineProtoLexer.this.dstTop - 1;
        }

        @Override
        public char charAt(int index) {
            return Unsafe.arrayGet(LineProtoLexer.this.buffer, LineProtoLexer.this.dstTop + index);
        }
    }

    private class ArrayBackedCharSink
    extends AbstractCharSink {
        private ArrayBackedCharSink() {
        }

        @Override
        public CharSink put(char c) {
            if (LineProtoLexer.this.dstPos == LineProtoLexer.this.buffer.length) {
                this.extend();
            }
            Unsafe.arrayPut(LineProtoLexer.this.buffer, LineProtoLexer.this.dstPos, c);
            return this;
        }

        private void extend() {
            int capacity = LineProtoLexer.this.dstPos * 2;
            if (capacity < 0) {
                throw LineProtoException.INSTANCE;
            }
            char[] buf = new char[capacity];
            System.arraycopy(LineProtoLexer.this.buffer, 0, buf, 0, LineProtoLexer.this.dstPos);
            LineProtoLexer.access$502(LineProtoLexer.this, buf);
        }
    }
}

