/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ex;

import com.questdb.common.ColumnType;
import com.questdb.common.PartitionBy;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.log.LogRecord;
import com.questdb.std.ex.JournalException;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadata;

public class JournalMetadataException
extends JournalException {
    private static final Log LOG = LogFactory.getLog(JournalMetadataException.class);
    private static final int FIRST_COL_PAD = 15;
    private static final int DEFAULT_COL_PAD = 40;

    public JournalMetadataException(JournalMetadata mo, JournalMetadata mn) {
        super("Checksum mismatch. Check log for details", new Object[0]);
        LogRecord b = LOG.error();
        b.$("Metadata mismatch for journal:\n");
        b.$("Name: ").$(mo.getName()).$('\n');
        this.sep(b);
        this.b(b);
        this.pad(b, 15, "column#");
        this.pad(b, "OLD");
        this.pad(b, "NEW");
        this.e(b);
        this.sep(b);
        this.b(b);
        boolean diff = mo.getPartitionBy() != mn.getPartitionBy();
        this.pad(b, 15, (diff ? "*" : "") + "Partition by");
        this.pad(b, PartitionBy.toString(mo.getPartitionBy()));
        this.pad(b, PartitionBy.toString(mn.getPartitionBy()));
        this.e(b);
        this.sep(b);
        int i = 0;
        while (true) {
            ColumnMetadata cmn;
            ColumnMetadata cmo = i < mo.getColumnCount() ? mo.getColumnQuick(i) : null;
            ColumnMetadata columnMetadata = cmn = i < mn.getColumnCount() ? mn.getColumnQuick(i) : null;
            if (cmo == null && cmn == null) break;
            diff = cmo == null || cmn == null;
            diff = diff || !cmo.name.equals(cmn.name);
            diff = diff || cmo.size != cmn.size;
            diff = diff || cmo.type != cmn.type;
            diff = diff || cmo.distinctCountHint != cmn.distinctCountHint;
            diff = diff || cmo.sameAs == null && cmn.sameAs != null || cmo.sameAs != null && !cmo.sameAs.equals(cmn.sameAs);
            this.b(b);
            this.pad(b, 15, (diff ? "*" : "") + i);
            if (cmo != null) {
                this.col(b, cmo);
            } else {
                this.skip(b);
            }
            if (cmn != null) {
                this.col(b, cmn);
            } else {
                this.skip(b);
            }
            ++i;
            this.e(b);
        }
        this.sep(b);
        b.$();
    }

    private void b(LogRecord r) {
        r.$('|');
    }

    private void col(LogRecord r, ColumnMetadata m) {
        this.pad(r, (m.distinctCountHint > 0 ? m.distinctCountHint + " ~ " : "") + (m.indexed ? Character.valueOf('#') : "") + m.name + (m.sameAs != null ? " -> " + m.sameAs : "") + ' ' + ColumnType.nameOf(m.type) + '(' + m.size + ')');
    }

    private void e(LogRecord r) {
        r.$('\n');
    }

    private void pad(LogRecord b, int w, String value) {
        int pad = value == null ? w : w - value.length();
        for (int i = 0; i < pad; ++i) {
            b.$(' ');
        }
        if (value != null) {
            b.$(value);
        }
        b.$("  |");
    }

    private void pad(LogRecord r, String value) {
        this.pad(r, 40, value);
    }

    private void sep(LogRecord b) {
        b.$("+-------------------------------------------------------------------------------------------------------+\n");
    }

    private void skip(LogRecord r) {
        this.pad(r, "");
    }
}

