/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.log;

import com.questdb.log.LogRecordSink;
import com.questdb.log.LogWriter;
import com.questdb.mp.RingQueue;
import com.questdb.mp.Sequence;
import com.questdb.mp.SynchronizedJob;
import com.questdb.std.Files;
import java.io.Closeable;

public class LogConsoleWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    private final long fd = Files.getStdOutFd();
    private final RingQueue<LogRecordSink> ring;
    private final Sequence subSeq;
    private final int level;

    public LogConsoleWriter(RingQueue<LogRecordSink> ring, Sequence subSeq, int level) {
        this.ring = ring;
        this.subSeq = subSeq;
        this.level = level;
    }

    @Override
    public void bindProperties() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean runSerially() {
        long cursor = this.subSeq.next();
        if (cursor < 0L) {
            return false;
        }
        LogRecordSink sink = this.ring.get(cursor);
        if ((sink.getLevel() & this.level) != 0) {
            Files.append(this.fd, sink.getAddress(), sink.length());
        }
        this.subSeq.done(cursor);
        return true;
    }
}

