/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.log;

import com.questdb.common.NumericException;
import com.questdb.log.Log;
import com.questdb.log.LogConsoleWriter;
import com.questdb.log.LogError;
import com.questdb.log.LogRecordSink;
import com.questdb.log.LogWriter;
import com.questdb.log.LogWriterConfig;
import com.questdb.log.Logger;
import com.questdb.mp.FanOut;
import com.questdb.mp.MPSequence;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SCSequence;
import com.questdb.mp.Sequence;
import com.questdb.mp.Worker;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Chars;
import com.questdb.std.IntObjHashMap;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.ObjHashSet;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.MicrosecondClock;
import com.questdb.std.microtime.MicrosecondClockImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public class LogFactory
implements Closeable {
    public static final LogFactory INSTANCE = new LogFactory();
    public static final String DEBUG_TRIGGER = "ebug";
    public static final String CONFIG_SYSTEM_PROPERTY = "questdbLog";
    private static final int DEFAULT_QUEUE_DEPTH = 1024;
    private static final int DEFAULT_MSG_SIZE = 4096;
    private static final String DEFAULT_CONFIG = "/qlog.conf";
    private static final String EMPTY_STR = "";
    private static final CharSequenceHashSet reserved = new CharSequenceHashSet();
    private static final LengthDescendingComparator LDC = new LengthDescendingComparator();
    private final CharSequenceObjHashMap<ScopeConfiguration> scopeConfigMap = new CharSequenceObjHashMap();
    private final ObjList<ScopeConfiguration> scopeConfigs = new ObjList();
    private final ObjHashSet<LogWriter> jobs = new ObjHashSet();
    private final CountDownLatch workerHaltLatch = new CountDownLatch(1);
    private final MicrosecondClock clock;
    private Worker worker = null;
    private boolean configured = false;
    private int queueDepth = 1024;
    private int recordLength = 4096;

    public LogFactory() {
        this(MicrosecondClockImpl.INSTANCE);
    }

    public LogFactory(MicrosecondClock clock) {
        this.clock = clock;
    }

    public static Log getLog(Class clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(CharSequence key) {
        if (!LogFactory.INSTANCE.configured) {
            LogFactory.configureFromSystemProperties(INSTANCE);
        }
        return INSTANCE.create(key);
    }

    public void add(LogWriterConfig config) {
        ScopeConfiguration scopeConf = this.scopeConfigMap.get(config.getScope());
        if (scopeConf == null) {
            scopeConf = new ScopeConfiguration(3);
            this.scopeConfigMap.put(config.getScope(), scopeConf);
            this.scopeConfigs.add(scopeConf);
        }
        scopeConf.add(config);
    }

    public void bind() {
        int i;
        if (this.configured) {
            return;
        }
        int n = this.scopeConfigs.size();
        for (i = 0; i < n; ++i) {
            ScopeConfiguration conf = this.scopeConfigs.get(i);
            conf.bind(this.jobs, this.queueDepth, this.recordLength);
        }
        this.scopeConfigMap.sortKeys(LDC);
        n = this.jobs.size();
        for (i = 0; i < n; ++i) {
            LogWriter w = this.jobs.get(i);
            w.bindProperties();
        }
        this.configured = true;
    }

    @Override
    public void close() {
        this.haltThread();
        int n = this.jobs.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.jobs.get(i));
        }
    }

    public Log create(CharSequence key) {
        if (!this.configured) {
            throw new LogError("Not configured");
        }
        ScopeConfiguration scopeConfiguration = this.find(key);
        if (scopeConfiguration == null) {
            return new Logger(this.clock, LogFactory.compressScope(key), null, null, null, null, null, null);
        }
        Holder inf = scopeConfiguration.getHolder(Numbers.msb(2));
        Holder dbg = scopeConfiguration.getHolder(Numbers.msb(1));
        Holder err = scopeConfiguration.getHolder(Numbers.msb(4));
        return new Logger(this.clock, LogFactory.compressScope(key), dbg == null ? null : dbg.ring, dbg == null ? null : dbg.lSeq, inf == null ? null : inf.ring, inf == null ? null : inf.lSeq, err == null ? null : err.ring, err == null ? null : err.lSeq);
    }

    public ObjHashSet<LogWriter> getJobs() {
        return this.jobs;
    }

    public int getQueueDepth() {
        return this.queueDepth;
    }

    private void setQueueDepth(int queueDepth) {
        this.queueDepth = queueDepth;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    private void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
    }

    public void haltThread() {
        if (this.worker != null) {
            this.worker.halt();
            try {
                this.workerHaltLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.worker = null;
        }
    }

    public void startThread() {
        if (this.worker != null) {
            return;
        }
        this.worker = new Worker(this.jobs, this.workerHaltLatch);
        this.worker.setDaemon(true);
        this.worker.setName("questdb-log-writer");
        this.worker.start();
    }

    static void configureFromSystemProperties(LogFactory factory) {
        block30: {
            String conf = System.getProperty(CONFIG_SYSTEM_PROPERTY);
            if (conf == null) {
                conf = DEFAULT_CONFIG;
            }
            try (InputStream is = LogFactory.class.getResourceAsStream(conf);){
                if (is != null) {
                    Properties properties = new Properties();
                    properties.load(is);
                    LogFactory.setup(factory, properties);
                    break block30;
                }
                File f = new File(conf);
                if (f.canRead()) {
                    try (FileInputStream fis = new FileInputStream(f);){
                        Properties properties = new Properties();
                        properties.load(fis);
                        LogFactory.setup(factory, properties);
                        break block30;
                    }
                }
                factory.configureDefaultWriter();
            }
            catch (IOException e) {
                if (!DEFAULT_CONFIG.equals(conf)) {
                    throw new LogError("Cannot read " + conf, e);
                }
                factory.configureDefaultWriter();
            }
        }
        factory.startThread();
    }

    private static void setup(LogFactory factory, Properties properties) {
        String writers = properties.getProperty("writers");
        if (writers == null) {
            factory.configured = true;
            return;
        }
        String s = properties.getProperty("queueDepth");
        if (s != null && s.length() > 0) {
            try {
                factory.setQueueDepth(Numbers.parseInt(s));
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for queueDepth");
            }
        }
        if ((s = properties.getProperty("recordLength")) != null && s.length() > 0) {
            try {
                factory.setRecordLength(Numbers.parseInt(s));
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for recordLength");
            }
        }
        for (String w : writers.split(",")) {
            LogWriterConfig conf = LogFactory.createWriter(properties, w.trim());
            if (conf == null) continue;
            factory.add(conf);
        }
        factory.bind();
    }

    private static LogWriterConfig createWriter(Properties properties, String w) {
        Constructor<?> constructor;
        Class<?> cl;
        String writer = "w." + w + '.';
        String clazz = properties.getProperty(writer + "class");
        String levelStr = properties.getProperty(writer + "level");
        String scope = properties.getProperty(writer + "scope");
        if (clazz == null) {
            return null;
        }
        try {
            cl = Class.forName(clazz);
            constructor = cl.getDeclaredConstructor(RingQueue.class, Sequence.class, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
            throw new LogError("Class not found " + clazz, e);
        }
        catch (NoSuchMethodException e) {
            throw new LogError("Constructor(RingQueue, Sequence, int) expected: " + clazz, e);
        }
        int level = 0;
        if (levelStr != null) {
            block13: for (String s : levelStr.split(",")) {
                switch (s.toUpperCase()) {
                    case "DEBUG": {
                        level |= 1;
                        continue block13;
                    }
                    case "INFO": {
                        level |= 2;
                        continue block13;
                    }
                    case "ERROR": {
                        level |= 4;
                        continue block13;
                    }
                    default: {
                        throw new LogError("Unknown level: " + s);
                    }
                }
            }
        }
        if (System.getProperty(DEBUG_TRIGGER) != null) {
            level |= 1;
        }
        return new LogWriterConfig(scope == null ? EMPTY_STR : scope, level, (ring, seq, level1) -> {
            try {
                LogWriter w1 = (LogWriter)constructor.newInstance(ring, seq, level1);
                for (String n : properties.stringPropertyNames()) {
                    String p;
                    if (!n.startsWith(writer) || reserved.contains(p = n.substring(writer.length()))) continue;
                    try {
                        Field f = cl.getDeclaredField(p);
                        if (f == null || f.getType() != String.class) continue;
                        Unsafe.getUnsafe().putObject(w1, Unsafe.getUnsafe().objectFieldOffset(f), properties.getProperty(n));
                    }
                    catch (Exception e) {
                        throw new LogError("Unknown property: " + n, e);
                    }
                }
                return w1;
            }
            catch (Exception e) {
                throw new LogError("Error creating log writer", e);
            }
        });
    }

    private static CharSequence compressScope(CharSequence key) {
        StringBuilder builder = new StringBuilder();
        char c = '\u0000';
        boolean pick = true;
        int z = 0;
        int n = key.length();
        for (int i = 0; i < n; ++i) {
            char a = key.charAt(i);
            if (a == '.') {
                if (pick) continue;
                builder.append(c).append('.');
                pick = true;
                continue;
            }
            if (!pick) continue;
            c = a;
            z = i;
            pick = false;
        }
        while (z < key.length()) {
            builder.append(key.charAt(z));
            ++z;
        }
        builder.append(' ');
        return builder;
    }

    private void configureDefaultWriter() {
        int level = 6;
        if (System.getProperty(DEBUG_TRIGGER) != null) {
            level |= 1;
        }
        this.add(new LogWriterConfig(level, LogConsoleWriter::new));
        this.bind();
    }

    private ScopeConfiguration find(CharSequence key) {
        ObjList<CharSequence> keys = this.scopeConfigMap.keys();
        CharSequence k = null;
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            CharSequence s = keys.getQuick(i);
            if (!Chars.startsWith(key, s)) continue;
            k = s;
            break;
        }
        if (k == null) {
            return null;
        }
        return this.scopeConfigMap.get(k);
    }

    static {
        reserved.add("scope");
        reserved.add("class");
        reserved.add("level");
    }

    private static class Holder {
        private final RingQueue<LogRecordSink> ring;
        private final Sequence lSeq;
        private Sequence wSeq;
        private FanOut fanOut;

        public Holder(int queueDepth, int recordLength) {
            this.ring = new RingQueue<LogRecordSink>(() -> new LogRecordSink(recordLength), queueDepth);
            this.lSeq = new MPSequence(queueDepth);
        }
    }

    private static class LengthDescendingComparator
    implements Comparator<CharSequence>,
    Serializable {
        private LengthDescendingComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int l2;
            int l1 = o1.length();
            if (l1 < (l2 = o2.length())) {
                return 1;
            }
            if (l1 > l2) {
                return -11;
            }
            return 0;
        }
    }

    private static class ScopeConfiguration {
        private final int[] channels;
        private final ObjList<LogWriterConfig> writerConfigs = new ObjList();
        private final IntObjHashMap<Holder> holderMap = new IntObjHashMap();
        private int ci = 0;

        public ScopeConfiguration(int levels) {
            this.channels = new int[levels];
        }

        public void bind(ObjHashSet<LogWriter> jobs, int queueDepth, int recordLength) {
            Holder h;
            int i;
            ObjList<Holder> holderList = new ObjList<Holder>();
            int n = this.channels.length;
            for (i = 0; i < n; ++i) {
                int index = Unsafe.arrayGet(this.channels, i);
                if (index <= 0 || (h = this.holderMap.get(index)) != null) continue;
                h = new Holder(queueDepth, recordLength);
                this.holderMap.put(index, h);
                holderList.add(h);
            }
            n = this.writerConfigs.size();
            for (i = 0; i < n; ++i) {
                LogWriterConfig c = this.writerConfigs.getQuick(i);
                h = this.holderMap.get(this.channels[Numbers.msb(c.getLevel())]);
                if (h.wSeq != null) {
                    if (h.fanOut == null) {
                        h.fanOut = FanOut.to(h.wSeq).and(h.wSeq = new SCSequence());
                    } else {
                        h.fanOut.and(h.wSeq = new SCSequence());
                    }
                } else {
                    h.wSeq = new SCSequence();
                }
                jobs.add(c.getFactory().createLogWriter(h.ring, h.wSeq, c.getLevel()));
            }
            n = holderList.size();
            for (i = 0; i < n; ++i) {
                Holder h2 = (Holder)holderList.getQuick(i);
                if (h2.fanOut != null) {
                    h2.lSeq.then(h2.fanOut).then(h2.lSeq);
                    continue;
                }
                h2.lSeq.then(h2.wSeq).then(h2.lSeq);
            }
        }

        private void add(LogWriterConfig conf) {
            int i;
            int mask = conf.getLevel();
            int min = Integer.MAX_VALUE;
            int q = ++this.ci;
            int n = this.channels.length;
            for (i = 0; i < n; ++i) {
                if ((mask >> i & 1) != 1) continue;
                int that = Unsafe.arrayGet(this.channels, i);
                if (that == 0) {
                    Unsafe.arrayPut(this.channels, i, q);
                }
                if (that <= 0 || that >= min) continue;
                min = that;
            }
            if (mask > 1 && min < Integer.MAX_VALUE) {
                n = this.channels.length;
                for (i = 0; i < n; ++i) {
                    if ((mask >> i & 1) != 1) continue;
                    Unsafe.arrayPut(this.channels, i, min);
                }
            }
            this.writerConfigs.add(conf);
        }

        private Holder getHolder(int index) {
            return this.holderMap.get(this.channels[index]);
        }
    }
}

