/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.log;

import com.questdb.common.NumericException;
import com.questdb.log.LogError;
import com.questdb.log.LogRecordSink;
import com.questdb.log.LogWriter;
import com.questdb.mp.RingQueue;
import com.questdb.mp.Sequence;
import com.questdb.mp.SynchronizedJob;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.std.str.Path;
import java.io.Closeable;

public class LogFileWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final RingQueue<LogRecordSink> ring;
    private final Sequence subSeq;
    private final int level;
    private long fd = -1L;
    private long lim;
    private long buf;
    private long _wptr;
    private String location;
    private String truncate;
    private String bufferSize;
    private int bufSize;

    public LogFileWriter(RingQueue<LogRecordSink> ring, Sequence subSeq, int level) {
        this.ring = ring;
        this.subSeq = subSeq;
        this.level = level;
    }

    @Override
    public void bindProperties() {
        if (this.bufferSize != null) {
            try {
                this.bufSize = Numbers.parseIntSize(this.bufferSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for bufferSize");
            }
        } else {
            this.bufSize = 0x100000;
        }
        this.buf = this._wptr = Unsafe.malloc(this.bufSize);
        this.lim = this.buf + (long)this.bufSize;
        try (Path path = new Path().of(this.location).$();){
            if (this.truncate != null && Chars.equalsIgnoreCase(this.truncate, "true")) {
                this.fd = Files.openRW(path);
                Files.truncate(this.fd, 0L);
            } else {
                this.fd = Files.openAppend(path);
            }
        }
        if (this.fd == -1L) {
            throw new LogError("Cannot open file for append: " + this.location);
        }
    }

    @Override
    public void close() {
        if (this.buf != 0L) {
            if (this._wptr > this.buf) {
                this.flush();
            }
            Unsafe.free(this.buf, this.bufSize);
            this.buf = 0L;
        }
        if (this.fd != -1L) {
            Files.close(this.fd);
            this.fd = -1L;
        }
    }

    public int getBufSize() {
        return this.bufSize;
    }

    @Override
    public boolean runSerially() {
        long cursor = this.subSeq.next();
        if (cursor < 0L) {
            if (this._wptr > this.buf) {
                this.flush();
                return true;
            }
            return false;
        }
        LogRecordSink sink = this.ring.get(cursor);
        if ((sink.getLevel() & this.level) != 0) {
            int l = sink.length();
            if (this._wptr + (long)l >= this.lim) {
                this.flush();
            }
            Unsafe.getUnsafe().copyMemory(sink.getAddress(), this._wptr, l);
            this._wptr += (long)l;
        }
        this.subSeq.done(cursor);
        return true;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    private void flush() {
        Files.append(this.fd, this.buf, (int)(this._wptr - this.buf));
        this._wptr = this.buf;
    }
}

