/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.log;

import com.questdb.std.Chars;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.CharSink;

public class LogRecordSink
extends AbstractCharSink {
    private final long address;
    private final long lim;
    private long _wptr;
    private int level;

    LogRecordSink(int capacity) {
        int c = Numbers.ceilPow2(capacity);
        this.address = this._wptr = Unsafe.malloc(c);
        this.lim = this.address + (long)c;
    }

    public void clear(int len) {
        this._wptr = this.address + (long)len;
    }

    public long getAddress() {
        return this.address;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int length() {
        return (int)(this._wptr - this.address);
    }

    @Override
    public CharSink put(CharSequence cs) {
        int rem = (int)(this.lim - this._wptr);
        int len = cs.length();
        int n = rem < len ? rem : len;
        Chars.strcpy(cs, n, this._wptr);
        this._wptr += (long)n;
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this._wptr < this.lim) {
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)c);
        }
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        long hi = this._wptr;
        for (long p = this.address; p < hi; ++p) {
            b.append((char)Unsafe.getUnsafe().getByte(p));
        }
        return b.toString();
    }
}

