/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.log;

import com.questdb.log.Log;
import com.questdb.log.LogRecord;
import com.questdb.log.LogRecordSink;
import com.questdb.log.NullLogRecord;
import com.questdb.mp.RingQueue;
import com.questdb.mp.Sequence;
import com.questdb.std.Net;
import com.questdb.std.Sinkable;
import com.questdb.std.microtime.MicrosecondClock;
import com.questdb.std.str.CharSink;
import java.io.File;

class Logger
implements LogRecord,
Log {
    private final CharSequence name;
    private final RingQueue<LogRecordSink> debugRing;
    private final Sequence debugSeq;
    private final RingQueue<LogRecordSink> infoRing;
    private final Sequence infoSeq;
    private final RingQueue<LogRecordSink> errorRing;
    private final Sequence errorSeq;
    private final ThreadLocalCursor tl = new ThreadLocalCursor();
    private final MicrosecondClock clock;

    Logger(MicrosecondClock clock, CharSequence name, RingQueue<LogRecordSink> debugRing, Sequence debugSeq, RingQueue<LogRecordSink> infoRing, Sequence infoSeq, RingQueue<LogRecordSink> errorRing, Sequence errorSeq) {
        this.clock = clock;
        this.name = name;
        this.debugRing = debugRing;
        this.debugSeq = debugSeq;
        this.infoRing = infoRing;
        this.infoSeq = infoSeq;
        this.errorRing = errorRing;
        this.errorSeq = errorSeq;
    }

    @Override
    public void $() {
        this.$("\r\n");
        Holder h = (Holder)this.tl.get();
        h.seq.done(h.cursor);
    }

    @Override
    public LogRecord $(CharSequence sequence) {
        if (sequence == null) {
            this.sink().put("null");
        } else {
            this.sink().put(sequence);
        }
        return this;
    }

    @Override
    public LogRecord utf8(CharSequence sequence) {
        if (sequence == null) {
            this.sink().put("null");
        } else {
            this.sink().encodeUtf8(sequence);
        }
        return this;
    }

    @Override
    public LogRecord $(int x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(double x) {
        this.sink().put(x, 2);
        return this;
    }

    @Override
    public LogRecord $(long x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(char c) {
        this.sink().put(c);
        return this;
    }

    @Override
    public LogRecord $(Throwable e) {
        if (e != null) {
            this.sink().put("\r\n").put(e);
        }
        return this;
    }

    @Override
    public LogRecord $(File x) {
        this.sink().put(x == null ? "null" : x.getAbsolutePath());
        return this;
    }

    @Override
    public LogRecord $(Enum e) {
        this.sink().put(e != null ? e.name() : "null");
        return this;
    }

    @Override
    public LogRecord $(Object x) {
        this.sink().put(x == null ? "null" : x.toString());
        return this;
    }

    @Override
    public LogRecord $(Sinkable x) {
        if (x == null) {
            this.sink().put("null");
        } else {
            x.toSink(this.sink());
        }
        return this;
    }

    @Override
    public LogRecord $ip(long ip) {
        Net.appendIP4(this.sink(), ip);
        return this;
    }

    @Override
    public LogRecord $ts(long x) {
        this.sink().putISODate(x);
        return this;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public LogRecord debug() {
        return this.xdebug().ts().$(" D ").$(this.name);
    }

    @Override
    public LogRecord error() {
        return this.xerror().ts().$(" E ").$(this.name);
    }

    @Override
    public LogRecord info() {
        return this.xinfo().ts().$(" I ").$(this.name);
    }

    @Override
    public LogRecord ts() {
        this.sink().putISODate(this.clock.getTicks());
        return this;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugSeq != null;
    }

    @Override
    public LogRecord xerror() {
        return this.next(this.errorSeq, this.errorRing, 4);
    }

    @Override
    public LogRecord xinfo() {
        return this.next(this.infoSeq, this.infoRing, 2);
    }

    private LogRecord next(Sequence seq, RingQueue<LogRecordSink> ring, int level) {
        if (seq == null) {
            return NullLogRecord.INSTANCE;
        }
        long cursor = seq.next();
        if (cursor < 0L) {
            return NullLogRecord.INSTANCE;
        }
        Holder h = (Holder)this.tl.get();
        h.cursor = cursor;
        h.seq = seq;
        h.ring = ring;
        LogRecordSink r = ring.get(cursor);
        r.setLevel(level);
        r.clear(0);
        return this;
    }

    private CharSink sink() {
        Holder h = (Holder)this.tl.get();
        return (CharSink)h.ring.get(h.cursor);
    }

    private LogRecord xdebug() {
        return this.next(this.debugSeq, this.debugRing, 1);
    }

    private static class ThreadLocalCursor
    extends ThreadLocal<Holder> {
        private ThreadLocalCursor() {
        }

        @Override
        protected Holder initialValue() {
            return new Holder();
        }
    }

    private static class Holder {
        private long cursor;
        private Sequence seq;
        private RingQueue<LogRecordSink> ring;

        private Holder() {
        }
    }
}

