/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.mp;

import com.questdb.mp.AbstractSSequence;
import com.questdb.mp.WaitStrategy;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import java.util.Arrays;

abstract class AbstractMSequence
extends AbstractSSequence {
    private final int[] flags;
    private final int mask;
    private final int shift;

    AbstractMSequence(int cycle, WaitStrategy waitStrategy) {
        super(waitStrategy);
        this.flags = new int[cycle];
        Arrays.fill(this.flags, -1);
        this.mask = cycle - 1;
        this.shift = Numbers.msb(cycle);
    }

    @Override
    public long availableIndex(long lo) {
        long l;
        long hi = this.value + 1L;
        for (l = lo; l < hi && this.available0(l); ++l) {
        }
        return l - 1L;
    }

    @Override
    public long current() {
        return this.value;
    }

    @Override
    public void done(long cursor) {
        Unsafe.getUnsafe().putOrderedInt(this.flags, (long)((int)(cursor & (long)this.mask) << (int)Unsafe.INT_SCALE) + Unsafe.INT_OFFSET, (int)(cursor >>> this.shift));
        this.barrier.getWaitStrategy().signal();
    }

    @Override
    public void reset() {
        this.value = -1L;
        Arrays.fill(this.flags, -1);
        this.setCacheFenced(-1L);
    }

    private boolean available0(long lo) {
        return Unsafe.getUnsafe().getIntVolatile(this.flags, (long)((int)(lo & (long)this.mask) << (int)Unsafe.INT_SCALE) + Unsafe.INT_OFFSET) == (int)(lo >>> this.shift);
    }
}

