/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.mp;

import com.questdb.mp.AbstractSequence;
import com.questdb.mp.Barrier;
import com.questdb.mp.NullWaitStrategy;
import com.questdb.mp.OpenBarrier;
import com.questdb.mp.Sequence;
import com.questdb.mp.WaitStrategy;

abstract class AbstractSSequence
extends AbstractSequence
implements Sequence {
    AbstractSSequence(WaitStrategy waitStrategy) {
        super(waitStrategy);
    }

    AbstractSSequence() {
        this(NullWaitStrategy.INSTANCE);
    }

    @Override
    public long nextBully() {
        long cursor;
        while ((cursor = this.next()) < 0L) {
            this.bully();
        }
        return cursor;
    }

    @Override
    public long waitForNext() {
        long r;
        WaitStrategy waitStrategy = this.getWaitStrategy();
        while ((r = this.next()) < 0L) {
            waitStrategy.await();
        }
        return r;
    }

    @Override
    public Barrier root() {
        return this.barrier != OpenBarrier.INSTANCE ? this.barrier.root() : this;
    }

    @Override
    public void setBarrier(Barrier barrier) {
        this.barrier = barrier;
    }

    @Override
    public Barrier then(Barrier barrier) {
        barrier.setBarrier(this);
        return barrier;
    }

    private void bully() {
        this.barrier.getWaitStrategy().signal();
    }
}

