/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.mp;

import com.questdb.mp.Job;
import com.questdb.std.Unsafe;

public abstract class SynchronizedJob
implements Job {
    private static final long LOCKED_OFFSET = Unsafe.getFieldOffset(SynchronizedJob.class, "locked");
    private volatile int locked = 0;

    @Override
    public boolean run() {
        if (Unsafe.getUnsafe().compareAndSwapInt(this, LOCKED_OFFSET, 0, 1)) {
            try {
                boolean bl = this.runSerially();
                return bl;
            }
            finally {
                this.locked = 0;
            }
        }
        return false;
    }

    protected abstract boolean runSerially();
}

