/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.mp;

import com.questdb.common.JournalRuntimeException;
import com.questdb.ex.TimeoutException;
import com.questdb.mp.AbstractWaitStrategy;
import com.questdb.mp.AlertedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimeoutBlockingWaitStrategy
extends AbstractWaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final long time;
    private final TimeUnit unit;

    public TimeoutBlockingWaitStrategy(long time, TimeUnit unit) {
        this.time = time;
        this.unit = unit;
    }

    @Override
    public boolean acceptSignal() {
        return true;
    }

    @Override
    public void await() {
        this.lock.lock();
        try {
            if (this.alerted) {
                throw AlertedException.INSTANCE;
            }
            if (!this.condition.await(this.time, this.unit)) {
                throw TimeoutException.INSTANCE;
            }
        }
        catch (InterruptedException e) {
            throw new JournalRuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void signal() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

