/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.mp;

import com.questdb.mp.Job;
import com.questdb.std.ObjHashSet;
import com.questdb.std.Unsafe;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class Worker
extends Thread {
    private static final long RUNNING_OFFSET = Unsafe.getFieldOffset(Worker.class, "running");
    private static final long YIELD_THRESHOLD = 100000L;
    private static final long SLEEP_THRESHOLD = 10000000L;
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final ObjHashSet<? extends Job> jobs;
    private final CountDownLatch haltLatch;
    private volatile int running = 0;
    private volatile int fence;

    public Worker(ObjHashSet<? extends Job> jobs, CountDownLatch haltLatch) {
        this.jobs = jobs;
        this.haltLatch = haltLatch;
        this.setName("questdb-worker-" + COUNTER.incrementAndGet());
    }

    public void halt() {
        this.running = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Unsafe.getUnsafe().compareAndSwapInt(this, RUNNING_OFFSET, 0, 1)) {
            this.setupJobs();
            int n = this.jobs.size();
            long uselessCounter = 0L;
            while (this.running == 1) {
                boolean useful = false;
                for (int i = 0; i < n; ++i) {
                    this.loadFence();
                    try {
                        useful |= this.jobs.get(i).run();
                        continue;
                    }
                    finally {
                        this.storeFence();
                    }
                }
                if (useful) {
                    uselessCounter = 0L;
                    continue;
                }
                if (++uselessCounter < 0L) {
                    uselessCounter = 10000001L;
                }
                if (uselessCounter > 100000L) {
                    Thread.yield();
                }
                if (uselessCounter <= 10000000L) continue;
                LockSupport.parkNanos(1000000L);
            }
        }
        this.haltLatch.countDown();
    }

    private int loadFence() {
        return this.fence;
    }

    private void setupJobs() {
        if (this.running == 1) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                this.loadFence();
                try {
                    this.jobs.get(i).setupThread();
                    continue;
                }
                finally {
                    this.storeFence();
                }
            }
        }
    }

    private void storeFence() {
        this.fence = 1;
    }
}

