/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.std.Net;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.NetworkError;
import java.io.Closeable;

public final class Epoll
implements Closeable {
    public static final short SIZEOF_EVENT;
    public static final int EPOLLIN;
    public static final int EPOLLOUT;
    public static final int EPOLL_CTL_ADD;
    public static final int EPOLL_CTL_MOD;
    private static final short DATA_OFFSET;
    private static final short EVENTS_OFFSET;
    private static final int EPOLLONESHOT;
    private static final int EPOLLET;
    private final long events;
    private final long epfd;
    private final int capacity;
    private boolean closed = false;
    private long _rPtr;

    public Epoll(int capacity) {
        this.capacity = capacity;
        this.events = this._rPtr = Unsafe.malloc((long)SIZEOF_EVENT * (long)capacity);
        this.epfd = Epoll.epollCreate();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Net.close(this.epfd);
        Unsafe.free(this.events, (long)SIZEOF_EVENT * (long)this.capacity);
        this.closed = true;
    }

    public int control(long fd, long id, int cmd, int event) {
        Unsafe.getUnsafe().putInt(this.events + (long)EVENTS_OFFSET, event | EPOLLET | EPOLLONESHOT);
        Unsafe.getUnsafe().putLong(this.events + (long)DATA_OFFSET, id);
        return Epoll.epollCtl(this.epfd, cmd, fd, this.events);
    }

    public long getData() {
        return Unsafe.getUnsafe().getLong(this._rPtr + (long)DATA_OFFSET);
    }

    public int getEvent() {
        return Unsafe.getUnsafe().getInt(this._rPtr + (long)EVENTS_OFFSET);
    }

    public void listen(long sfd) {
        Unsafe.getUnsafe().putInt(this.events + (long)EVENTS_OFFSET, EPOLLIN | EPOLLET);
        Unsafe.getUnsafe().putLong(this.events + (long)DATA_OFFSET, 0L);
        if (Epoll.epollCtl(this.epfd, EPOLL_CTL_ADD, sfd, this.events) < 0) {
            throw new NetworkError("Error in epoll_ctl: " + Os.errno());
        }
    }

    public int poll() {
        return Epoll.epollWait(this.epfd, this.events, this.capacity, 0);
    }

    public void setOffset(int offset) {
        this._rPtr = this.events + (long)offset;
    }

    private static native long epollCreate();

    private static native int epollCtl(long var0, int var2, long var3, long var5);

    private static native int epollWait(long var0, long var2, int var4, int var5);

    private static native short getDataOffset();

    private static native short getEventsOffset();

    private static native short getEventSize();

    private static native int getEPOLLIN();

    private static native int getEPOLLET();

    private static native int getEPOLLOUT();

    private static native int getEPOLLONESHOT();

    private static native int getCtlAdd();

    private static native int getCtlMod();

    static {
        DATA_OFFSET = Epoll.getDataOffset();
        EVENTS_OFFSET = Epoll.getEventsOffset();
        SIZEOF_EVENT = Epoll.getEventSize();
        EPOLLIN = Epoll.getEPOLLIN();
        EPOLLET = Epoll.getEPOLLET();
        EPOLLOUT = Epoll.getEPOLLOUT();
        EPOLLONESHOT = Epoll.getEPOLLONESHOT();
        EPOLL_CTL_ADD = Epoll.getCtlAdd();
        EPOLL_CTL_MOD = Epoll.getCtlMod();
    }
}

