/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.MPSequence;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SCSequence;
import com.questdb.mp.Sequence;
import com.questdb.mp.SynchronizedJob;
import com.questdb.net.Context;
import com.questdb.net.ContextFactory;
import com.questdb.net.DisconnectReason;
import com.questdb.net.Dispatcher;
import com.questdb.net.Epoll;
import com.questdb.net.Event;
import com.questdb.std.LongMatrix;
import com.questdb.std.Misc;
import com.questdb.std.Net;
import com.questdb.std.ObjectFactory;
import com.questdb.std.Os;
import com.questdb.std.ex.NetworkError;
import com.questdb.std.time.MillisecondClock;
import java.io.IOException;

public class EpollDispatcher<C extends Context>
extends SynchronizedJob
implements Dispatcher<C> {
    private static final int M_TIMESTAMP = 1;
    private static final int M_FD = 2;
    private static final int M_ID = 0;
    private static final Log LOG = LogFactory.getLog(EpollDispatcher.class);
    private final long socketFd;
    private final RingQueue<Event<C>> ioQueue;
    private final Sequence ioSequence;
    private final RingQueue<Event<C>> interestQueue;
    private final MPSequence interestPubSequence;
    private final SCSequence interestSubSequence = new SCSequence();
    private final MillisecondClock clock;
    private final Epoll epoll;
    private final int timeout;
    private final LongMatrix<C> pending = new LongMatrix(4);
    private final int maxConnections;
    private final ContextFactory<C> contextFactory;
    private int connectionCount = 0;
    private long fdid = 1L;

    public EpollDispatcher(CharSequence ip, int port, int maxConnections, int timeout, RingQueue<Event<C>> ioQueue, Sequence ioSequence, MillisecondClock clock, int capacity, ObjectFactory<Event<C>> eventFactory, ContextFactory<C> contextFactory) {
        this.ioQueue = ioQueue;
        this.ioSequence = ioSequence;
        this.interestQueue = new RingQueue<Event<C>>(eventFactory, ioQueue.getCapacity());
        this.interestPubSequence = new MPSequence(this.interestQueue.getCapacity());
        this.interestPubSequence.then(this.interestSubSequence).then(this.interestPubSequence);
        this.clock = clock;
        this.maxConnections = maxConnections;
        this.timeout = timeout;
        this.contextFactory = contextFactory;
        this.epoll = new Epoll(capacity);
        this.socketFd = Net.socketTcp(false);
        if (!Net.bindTcp(this.socketFd, ip, port)) {
            throw new NetworkError("Failed to find socket");
        }
        Net.listen(this.socketFd, 128);
        this.epoll.listen(this.socketFd);
        LOG.debug().$("Listening socket: ").$(this.socketFd).$();
    }

    @Override
    public void close() throws IOException {
        this.epoll.close();
        Net.close(this.socketFd);
        int n = this.pending.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.pending.get(i));
        }
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount;
    }

    @Override
    public void registerChannel(C context, int channelStatus) {
        long cursor = this.interestPubSequence.nextBully();
        Event<C> evt = this.interestQueue.get(cursor);
        evt.context = context;
        evt.channelStatus = channelStatus;
        LOG.debug().$("Re-queuing ").$(context.getFd()).$();
        this.interestPubSequence.done(cursor);
    }

    private void accept(long timestamp) {
        while (true) {
            long _fd;
            if ((_fd = Net.accept(this.socketFd)) < 0L) {
                if (Os.errno() == Net.EWOULDBLOCK) break;
                LOG.error().$("Error in accept(): ").$(Os.errno()).$();
                break;
            }
            LOG.info().$(" Connected ").$(_fd).$();
            if (Net.configureNonBlocking(_fd) < 0) {
                LOG.error().$("Cannot make FD non-blocking").$();
                Net.close(_fd);
            }
            ++this.connectionCount;
            if (this.connectionCount > this.maxConnections) {
                LOG.info().$("Too many connections, kicking out ").$(_fd).$();
                Net.close(_fd);
                --this.connectionCount;
                return;
            }
            this.addPending(_fd, timestamp);
        }
    }

    private void addPending(long _fd, long timestamp) {
        int r = this.pending.addRow();
        LOG.debug().$(" Matrix row ").$(r).$(" for ").$(_fd).$();
        this.pending.set(r, 1, timestamp);
        this.pending.set(r, 2, _fd);
        this.pending.set(r, 0, this.fdid++);
        this.pending.set(r, this.contextFactory.newInstance(_fd, this.clock));
    }

    private void disconnect(C context, int disconnectReason) {
        LOG.info().$("Disconnected ").$ip(context.getIp()).$(" [").$(DisconnectReason.nameOf(disconnectReason)).$(']').$();
        context.close();
        --this.connectionCount;
    }

    private void enqueuePending(int watermark) {
        int i = watermark;
        int sz = this.pending.size();
        int offset = 0;
        while (i < sz) {
            this.epoll.setOffset(offset);
            if (this.epoll.control((int)this.pending.get(i, 2), this.pending.get(i, 0), Epoll.EPOLL_CTL_ADD, Epoll.EPOLLIN) < 0) {
                LOG.debug().$("epoll_ctl failure ").$(Os.errno()).$();
            } else {
                LOG.debug().$("epoll_ctl ").$(this.pending.get(i, 2)).$(" as ").$(this.pending.get(i, 0)).$();
            }
            ++i;
            offset += Epoll.SIZEOF_EVENT;
        }
    }

    private void processIdleConnections(long deadline) {
        int count = 0;
        int i = 0;
        int n = this.pending.size();
        while (i < n && this.pending.get(i, 1) < deadline) {
            this.disconnect((Context)this.pending.get(i), 2);
            ++i;
            ++count;
        }
        this.pending.zapTop(count);
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        int offset = 0;
        block6: while ((cursor = this.interestSubSequence.next()) > -1L) {
            long id;
            useful = true;
            Event<C> evt = this.interestQueue.get(cursor);
            Object context = evt.context;
            int channelStatus = evt.channelStatus;
            this.interestSubSequence.done(cursor);
            int fd = (int)context.getFd();
            ++this.fdid;
            LOG.debug().$("Registering ").$(fd).$(" status ").$(channelStatus).$(" as ").$(id).$();
            this.epoll.setOffset(offset);
            offset += Epoll.SIZEOF_EVENT;
            switch (channelStatus) {
                case 1: {
                    this.epoll.control(fd, id, Epoll.EPOLL_CTL_MOD, Epoll.EPOLLIN);
                    break;
                }
                case 4: {
                    this.epoll.control(fd, id, Epoll.EPOLL_CTL_MOD, Epoll.EPOLLOUT);
                    break;
                }
                case 3: {
                    this.disconnect(context, 3);
                    continue block6;
                }
                case 5: {
                    this.disconnect(context, 1);
                    continue block6;
                }
            }
            int r = this.pending.addRow();
            this.pending.set(r, 1, timestamp);
            this.pending.set(r, 2, fd);
            this.pending.set(r, 0, id);
            this.pending.set(r, context);
        }
        return useful;
    }

    @Override
    protected boolean runSerially() {
        boolean useful = false;
        int n = this.epoll.poll();
        int watermark = this.pending.size();
        long timestamp = this.clock.getTicks();
        int offset = 0;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.epoll.setOffset(offset);
                offset += Epoll.SIZEOF_EVENT;
                long id = this.epoll.getData();
                if (id == 0L) {
                    this.accept(timestamp);
                    continue;
                }
                int row = this.pending.binarySearch(id);
                if (row < 0) {
                    LOG.error().$("Internal error: unknown ID: ").$(id).$();
                    continue;
                }
                Context context = (Context)this.pending.get(row);
                long cursor = this.ioSequence.nextBully();
                Event<C> evt = this.ioQueue.get(cursor);
                evt.context = context;
                evt.channelStatus = (this.epoll.getEvent() & Epoll.EPOLLIN) > 0 ? 1 : 4;
                this.ioSequence.done(cursor);
                LOG.debug().$("Queuing ").$(id).$(" on ").$(context.getFd()).$(", status: ").$(evt.channelStatus).$();
                this.pending.deleteRow(row);
                --watermark;
            }
            if (watermark < this.pending.size()) {
                this.enqueuePending(watermark);
            }
            useful = true;
        }
        long deadline = timestamp - (long)this.timeout;
        if (this.pending.size() > 0 && this.pending.get(0, 1) < deadline) {
            this.processIdleConnections(deadline);
            useful = true;
        }
        return this.processRegistrations(timestamp) || useful;
    }
}

