/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.std.ByteBuffers;
import com.questdb.std.Unsafe;
import com.questdb.std.Zip;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class GZipWritableChannel<T extends WritableByteChannel>
implements WritableByteChannel {
    private final ByteBuffer out;
    private final long outAddr;
    private final int outAvail;
    private T channel;
    private long z_streamp;
    private boolean flushed = false;
    private int crc = 0;
    private long total = 0L;

    public GZipWritableChannel(int bufferSize) {
        this.out = ByteBuffer.allocateDirect(bufferSize);
        this.outAvail = bufferSize;
        this.outAddr = ByteBuffers.getAddress(this.out);
        this.z_streamp = Zip.deflateInit();
        if (this.z_streamp <= 0L) {
            throw new OutOfMemoryError();
        }
    }

    public void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        this.deflate(true);
        Unsafe.getUnsafe().putInt(this.outAddr, this.crc);
        Unsafe.getUnsafe().putInt(this.outAddr + 4L, (int)this.total);
        this.out.limit(8).position(0);
        this.channel.write(this.out);
        this.flushed = true;
    }

    @Override
    public boolean isOpen() {
        return this.z_streamp != 0L;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.channel.isOpen()) {
            this.channel.close();
        }
        if (this.z_streamp != 0L) {
            Zip.deflateEnd(this.z_streamp);
            this.z_streamp = 0L;
        }
        ByteBuffers.release(this.out);
    }

    public GZipWritableChannel<T> of(T channel) throws IOException {
        this.reset();
        this.channel = channel;
        Unsafe.getUnsafe().copyMemory(Zip.gzipHeader, this.outAddr, 10L);
        this.out.limit(10).position(0);
        channel.write(this.out);
        return this;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!ByteBuffers.isDirect(src)) {
            throw new IllegalArgumentException("Heap buffers are not supported");
        }
        int result = src.remaining();
        int pos = src.position();
        Zip.setInput(this.z_streamp, ByteBuffers.getAddress(src) + (long)pos, result);
        this.crc = Zip.crc32(this.crc, ByteBuffers.getAddress(src) + (long)pos, result);
        this.deflate(false);
        src.position(pos + result);
        this.total += (long)result;
        return result;
    }

    private void deflate(boolean flush) throws IOException {
        int ret;
        do {
            if ((ret = Zip.deflate(this.z_streamp, this.outAddr, this.outAvail, flush)) < 0) {
                throw new IOException("Deflater error: " + ret);
            }
            int len = this.outAvail - Zip.availOut(this.z_streamp);
            if (len <= 0) continue;
            this.out.limit(len).position(0);
            this.channel.write(this.out);
        } while (Zip.availIn(this.z_streamp) > 0 || flush && ret != 1);
    }

    private void reset() {
        Zip.deflateReset(this.z_streamp);
        this.crc = 0;
        this.total = 0L;
        this.flushed = false;
    }
}

