/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.MPSequence;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SCSequence;
import com.questdb.mp.Sequence;
import com.questdb.mp.SynchronizedJob;
import com.questdb.net.Context;
import com.questdb.net.ContextFactory;
import com.questdb.net.DisconnectReason;
import com.questdb.net.Dispatcher;
import com.questdb.net.Event;
import com.questdb.net.Kqueue;
import com.questdb.std.LongMatrix;
import com.questdb.std.Misc;
import com.questdb.std.Net;
import com.questdb.std.ObjectFactory;
import com.questdb.std.ex.NetworkError;
import com.questdb.std.time.MillisecondClock;
import java.io.IOException;

public class KQueueDispatcher<C extends Context>
extends SynchronizedJob
implements Dispatcher<C> {
    private static final Log LOG = LogFactory.getLog(KQueueDispatcher.class);
    private final long socketFd;
    private final RingQueue<Event<C>> ioQueue;
    private final Sequence ioSequence;
    private final RingQueue<Event<C>> interestQueue;
    private final MPSequence interestPubSequence;
    private final SCSequence interestSubSequence = new SCSequence();
    private final MillisecondClock clock;
    private final Kqueue kqueue;
    private final int timeout;
    private final LongMatrix<C> pending = new LongMatrix(2);
    private final int maxConnections;
    private final int capacity;
    private final ContextFactory<C> contextFactory;
    private int connectionCount = 0;

    public KQueueDispatcher(CharSequence ip, int port, int maxConnections, int timeout, RingQueue<Event<C>> ioQueue, Sequence ioSequence, MillisecondClock clock, int capacity, ObjectFactory<Event<C>> eventFactory, ContextFactory<C> contextFactory) {
        this.ioQueue = ioQueue;
        this.ioSequence = ioSequence;
        this.interestQueue = new RingQueue<Event<C>>(eventFactory, ioQueue.getCapacity());
        this.interestPubSequence = new MPSequence(this.interestQueue.getCapacity());
        this.interestPubSequence.then(this.interestSubSequence).then(this.interestPubSequence);
        this.clock = clock;
        this.maxConnections = maxConnections;
        this.timeout = timeout;
        this.capacity = capacity;
        this.contextFactory = contextFactory;
        this.kqueue = new Kqueue(capacity);
        this.socketFd = Net.socketTcp(false);
        if (!Net.bindTcp(this.socketFd, ip, port)) {
            throw new NetworkError("Failed to bind socket");
        }
        Net.listen(this.socketFd, 128);
        this.kqueue.listen(this.socketFd);
        LOG.debug().$("Listening socket: ").$(this.socketFd).$();
    }

    @Override
    public void close() throws IOException {
        this.kqueue.close();
        Net.close(this.socketFd);
        int n = this.pending.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.pending.get(i));
        }
        this.pending.zapTop(n);
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount;
    }

    @Override
    public void registerChannel(C context, int channelStatus) {
        long cursor = this.interestPubSequence.nextBully();
        Event<C> evt = this.interestQueue.get(cursor);
        evt.context = context;
        evt.channelStatus = channelStatus;
        LOG.debug().$("Re-queuing ").$(context.getFd()).$();
        this.interestPubSequence.done(cursor);
    }

    private long accept() {
        long _fd = Net.accept(this.socketFd);
        LOG.info().$(" Connected ").$(_fd).$();
        if (_fd < 0L) {
            LOG.error().$("Error in accept: ").$(_fd).$();
            return -1L;
        }
        if (Net.configureNonBlocking(_fd) < 0) {
            LOG.error().$("Cannot make FD non-blocking").$();
            Net.close(_fd);
            return -1L;
        }
        ++this.connectionCount;
        if (this.connectionCount > this.maxConnections) {
            LOG.info().$("Too many connections, kicking out ").$(_fd).$();
            Net.close(_fd);
            --this.connectionCount;
            return -1L;
        }
        return _fd;
    }

    private void addPending(long _fd, long timestamp) {
        int r = this.pending.addRow();
        LOG.debug().$(" Matrix row ").$(r).$(" for ").$(_fd).$();
        this.pending.set(r, 0, timestamp);
        this.pending.set(r, 1, _fd);
        this.pending.set(r, this.contextFactory.newInstance(_fd, this.clock));
    }

    private void disconnect(C context, int disconnectReason) {
        LOG.info().$("Disconnected ").$ip(context.getIp()).$(" [").$(DisconnectReason.nameOf(disconnectReason)).$(']').$();
        context.close();
        --this.connectionCount;
    }

    private void enqueuePending(int watermark) {
        int index = 0;
        int i = watermark;
        int sz = this.pending.size();
        int offset = 0;
        while (i < sz) {
            this.kqueue.setOffset(offset);
            this.kqueue.readFD((int)this.pending.get(i, 1), this.pending.get(i, 0));
            LOG.debug().$("kqueued ").$(this.pending.get(i, 1)).$(" as ").$(index - 1).$();
            if (++index > this.capacity - 1) {
                this.kqueue.register(index);
                index = 0;
            }
            ++i;
            offset += Kqueue.SIZEOF_KEVENT;
        }
        if (index > 0) {
            this.kqueue.register(index);
            LOG.debug().$("Registered ").$(index).$();
        }
    }

    private int findPending(int fd, long ts) {
        int r = this.pending.binarySearch(ts);
        if (r < 0) {
            return r;
        }
        if (this.pending.get(r, 1) == (long)fd) {
            return r;
        }
        return this.scanRow(r + 1, fd, ts);
    }

    private void processIdleConnections(long deadline) {
        int count = 0;
        int i = 0;
        int n = this.pending.size();
        while (i < n && this.pending.get(i, 0) < deadline) {
            this.disconnect((Context)this.pending.get(i), 2);
            ++i;
            ++count;
        }
        this.pending.zapTop(count);
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        int count = 0;
        int offset = 0;
        block6: while ((cursor = this.interestSubSequence.next()) > -1L) {
            useful = true;
            Event<C> evt = this.interestQueue.get(cursor);
            Object context = evt.context;
            int channelStatus = evt.channelStatus;
            this.interestSubSequence.done(cursor);
            int fd = (int)context.getFd();
            LOG.debug().$("Registering ").$(fd).$(" status ").$(channelStatus).$();
            this.kqueue.setOffset(offset);
            offset += Kqueue.SIZEOF_KEVENT;
            ++count;
            switch (channelStatus) {
                case 1: {
                    this.kqueue.readFD(fd, timestamp);
                    break;
                }
                case 4: {
                    this.kqueue.writeFD(fd, timestamp);
                    break;
                }
                case 3: {
                    this.disconnect(context, 3);
                    continue block6;
                }
                case 5: {
                    this.disconnect(context, 1);
                    continue block6;
                }
            }
            int r = this.pending.addRow();
            this.pending.set(r, 0, timestamp);
            this.pending.set(r, 1, fd);
            this.pending.set(r, context);
            if (count <= this.capacity - 1) continue;
            this.kqueue.register(count);
            count = 0;
        }
        if (count > 0) {
            this.kqueue.register(count);
        }
        return useful;
    }

    @Override
    protected boolean runSerially() {
        boolean useful = false;
        int n = this.kqueue.poll();
        int watermark = this.pending.size();
        long timestamp = this.clock.getTicks();
        int offset = 0;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.kqueue.setOffset(offset);
                offset += Kqueue.SIZEOF_KEVENT;
                int fd = this.kqueue.getFd();
                if ((long)fd == this.socketFd) {
                    long _fd = this.accept();
                    if (_fd < 0L) continue;
                    this.addPending(_fd, timestamp);
                    continue;
                }
                int row = this.findPending(fd, this.kqueue.getData());
                if (row < 0) {
                    LOG.error().$("Internal error: unknown FD: ").$(fd).$();
                    continue;
                }
                if (this.kqueue.getFlags() == -32751) {
                    this.disconnect((Context)this.pending.get(row), 1);
                } else {
                    long cursor = this.ioSequence.nextBully();
                    Event<C> evt = this.ioQueue.get(cursor);
                    evt.context = (Context)this.pending.get(row);
                    evt.channelStatus = this.kqueue.getFilter() == Kqueue.EVFILT_READ ? 1 : 4;
                    this.ioSequence.done(cursor);
                    LOG.debug().$("Queuing ").$(this.kqueue.getFilter()).$(" on ").$(fd).$();
                }
                this.pending.deleteRow(row);
                --watermark;
            }
            if (watermark < this.pending.size()) {
                this.enqueuePending(watermark);
            }
            useful = true;
        }
        long deadline = timestamp - (long)this.timeout;
        if (this.pending.size() > 0 && this.pending.get(0, 0) < deadline) {
            this.processIdleConnections(deadline);
            useful = true;
        }
        return this.processRegistrations(timestamp) || useful;
    }

    private int scanRow(int r, int fd, long ts) {
        int n = this.pending.size();
        for (int i = r; i < n; ++i) {
            if (this.pending.get(i, 0) != ts) {
                return -(i + 1);
            }
            if (this.pending.get(i, 1) != (long)fd) continue;
            return i;
        }
        return -1;
    }
}

