/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.Net;
import com.questdb.std.Unsafe;
import java.io.Closeable;

public final class Kqueue
implements Closeable {
    public static final short EVFILT_READ;
    public static final short SIZEOF_KEVENT;
    public static final int EV_EOF = -32751;
    private static final short EVFILT_WRITE;
    private static final Log LOG;
    private static final short FD_OFFSET;
    private static final short FILTER_OFFSET;
    private static final short FLAGS_OFFSET;
    private static final short DATA_OFFSET;
    private static final short EV_ADD;
    private static final short EV_ONESHOT;
    private final long eventList;
    private final int kq;
    private final int capacity;
    private long _rPtr;

    public Kqueue(int capacity) {
        this.capacity = capacity;
        this.eventList = this._rPtr = Unsafe.malloc((long)SIZEOF_KEVENT * (long)capacity);
        this.kq = Kqueue.kqueue();
    }

    public static native int kevent(int var0, long var1, int var3, long var4, int var6);

    @Override
    public void close() {
        if (Net.close(this.kq) < 0) {
            LOG.error().$("Cannot close kqueue ").$(this.kq).$();
        }
    }

    public long getData() {
        return Unsafe.getUnsafe().getLong(this._rPtr + (long)DATA_OFFSET);
    }

    public int getFd() {
        return (int)Unsafe.getUnsafe().getLong(this._rPtr + (long)FD_OFFSET);
    }

    public int getFilter() {
        return Unsafe.getUnsafe().getShort(this._rPtr + (long)FILTER_OFFSET);
    }

    public int getFlags() {
        return Unsafe.getUnsafe().getShort(this._rPtr + (long)FLAGS_OFFSET);
    }

    public void listen(long sfd) {
        this._rPtr = this.eventList;
        this.commonFd(sfd, 0L);
        Unsafe.getUnsafe().putShort(this._rPtr + (long)FILTER_OFFSET, EVFILT_READ);
        Unsafe.getUnsafe().putShort(this._rPtr + (long)FLAGS_OFFSET, EV_ADD);
        this.register(1);
    }

    public int poll() {
        return Kqueue.kevent(this.kq, 0L, 0, this.eventList, this.capacity);
    }

    public void readFD(int fd, long data) {
        this.commonFd(fd, data);
        Unsafe.getUnsafe().putShort(this._rPtr + (long)FILTER_OFFSET, EVFILT_READ);
        Unsafe.getUnsafe().putShort(this._rPtr + (long)FLAGS_OFFSET, (short)(EV_ADD | EV_ONESHOT));
    }

    public void register(int n) {
        Kqueue.kevent(this.kq, this.eventList, n, 0L, 0);
    }

    public void setOffset(int offset) {
        this._rPtr = this.eventList + (long)offset;
    }

    public void writeFD(int fd, long data) {
        this.commonFd(fd, data);
        Unsafe.getUnsafe().putShort(this._rPtr + (long)FILTER_OFFSET, EVFILT_WRITE);
        Unsafe.getUnsafe().putShort(this._rPtr + (long)FLAGS_OFFSET, (short)(EV_ADD | EV_ONESHOT));
    }

    private static native int kqueue();

    private static native short getEvfiltRead();

    private static native short getEvfiltWrite();

    private static native short getSizeofKevent();

    private static native short getFdOffset();

    private static native short getFilterOffset();

    private static native short getEvAdd();

    private static native short getEvOneshot();

    private static native short getFlagsOffset();

    private static native short getDataOffset();

    private void commonFd(long fd, long data) {
        Unsafe.getUnsafe().putLong(this._rPtr + (long)FD_OFFSET, fd);
        Unsafe.getUnsafe().putLong(this._rPtr + (long)DATA_OFFSET, data);
    }

    static {
        LOG = LogFactory.getLog(Kqueue.class);
        EVFILT_READ = Kqueue.getEvfiltRead();
        EVFILT_WRITE = Kqueue.getEvfiltWrite();
        SIZEOF_KEVENT = Kqueue.getSizeofKevent();
        FD_OFFSET = Kqueue.getFdOffset();
        FILTER_OFFSET = Kqueue.getFilterOffset();
        FLAGS_OFFSET = Kqueue.getFlagsOffset();
        DATA_OFFSET = Kqueue.getDataOffset();
        EV_ADD = Kqueue.getEvAdd();
        EV_ONESHOT = Kqueue.getEvOneshot();
    }
}

