/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.std.ByteBuffers;
import com.questdb.std.Net;
import com.questdb.std.NetworkChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NetworkChannelImpl
implements NetworkChannel {
    private final long fd;
    private final long ip;
    private long totalWritten = 0L;

    public NetworkChannelImpl(long fd) {
        this.fd = fd;
        this.ip = Net.getPeerIP(fd);
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public long getIp() {
        return this.ip;
    }

    @Override
    public long getTotalWrittenAndReset() {
        long r = this.totalWritten;
        this.totalWritten = 0L;
        return r;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
        Net.close(this.fd);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int p = dst.position();
        int read = Net.recv(this.fd, ByteBuffers.getAddress(dst) + (long)p, dst.remaining());
        if (read > 0) {
            dst.position(p + read);
        }
        if (read == 0) {
            Thread.yield();
        }
        return read;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int written = Net.send(this.fd, ByteBuffers.getAddress(src) + (long)src.position(), src.remaining());
        if (written > 0) {
            this.totalWritten += (long)written;
            src.position(src.position() + written);
        }
        return written;
    }
}

