/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.common.JournalRuntimeException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.SslConfig;
import com.questdb.std.ByteBuffers;
import com.questdb.std.NetworkChannel;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.SlowReadableChannelException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class NonBlockingSecureSocketChannel
implements NetworkChannel {
    public static final int READ_CLEAN_CHANNEL = 1;
    public static final int READ_CHANNEL = 2;
    public static final int UNWRAP_DIRECT = 4;
    public static final int UNWRAP_CLEAN_CACHED = 8;
    public static final int UNWRAP_CACHED = 16;
    private static final Log LOG = LogFactory.getLog(NonBlockingSecureSocketChannel.class);
    private final NetworkChannel channel;
    private final SSLEngine engine;
    private final ByteBuffer in;
    private final ByteBuffer out;
    private final int sslDataLimit;
    private final ByteBuffer unwrapped;
    private boolean inData = false;
    private SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
    private int readState = 1;

    public NonBlockingSecureSocketChannel(NetworkChannel channel, SslConfig sslConfig) {
        this.channel = channel;
        SSLContext sslc = sslConfig.getSslContext();
        this.engine = sslc.createSSLEngine();
        this.engine.setEnableSessionCreation(true);
        this.engine.setUseClientMode(sslConfig.isClient());
        this.engine.setNeedClientAuth(sslConfig.isRequireClientAuth());
        SSLSession session = this.engine.getSession();
        this.sslDataLimit = session.getApplicationBufferSize();
        this.in = ByteBuffer.allocateDirect(session.getPacketBufferSize()).order(ByteOrder.BIG_ENDIAN);
        this.out = ByteBuffer.allocateDirect(session.getPacketBufferSize()).order(ByteOrder.BIG_ENDIAN);
        this.unwrapped = ByteBuffer.allocateDirect(this.sslDataLimit * 2).order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public long getFd() {
        return this.channel.getFd();
    }

    @Override
    public long getIp() {
        return this.channel.getIp();
    }

    @Override
    public long getTotalWrittenAndReset() {
        return this.channel.getTotalWrittenAndReset();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        ByteBuffers.release(this.in);
        ByteBuffers.release(this.out);
        ByteBuffers.release(this.unwrapped);
        if (this.engine.isOutboundDone()) {
            this.engine.closeOutbound();
        }
        while (!this.engine.isInboundDone()) {
            try {
                this.engine.closeInbound();
            }
            catch (SSLException sSLException) {}
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshake();
        }
        int p = dst.position();
        int limit = dst.remaining();
        if (limit == 0) {
            return 0;
        }
        if (this.unwrapped.hasRemaining()) {
            ByteBuffers.copy(this.unwrapped, dst);
        }
        block21: while ((limit = dst.remaining()) > 0) {
            switch (this.readState) {
                case 1: {
                    this.in.clear();
                    this.readState = 2;
                }
                case 2: {
                    try {
                        ByteBuffers.copyNonBlocking(this.channel, this.in, 1000);
                        this.in.flip();
                        if (limit < this.sslDataLimit) {
                            this.readState = 8;
                            continue block21;
                        }
                        this.readState = 4;
                        continue block21;
                    }
                    catch (SlowReadableChannelException e) {
                        break block21;
                    }
                }
                case 4: {
                    switch (this.engine.unwrap(this.in, dst).getStatus()) {
                        case BUFFER_OVERFLOW: {
                            this.readState = 8;
                            continue block21;
                        }
                        case OK: {
                            if (this.in.remaining() != 0) continue block21;
                            this.readState = 1;
                            continue block21;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.in.compact();
                            this.readState = 2;
                            continue block21;
                        }
                        case CLOSED: {
                            throw DisconnectedChannelException.INSTANCE;
                        }
                    }
                    continue block21;
                }
                case 8: {
                    this.unwrapped.clear();
                    this.readState = 16;
                }
                case 16: {
                    switch (this.engine.unwrap(this.in, this.unwrapped).getStatus()) {
                        case BUFFER_OVERFLOW: {
                            this.readState = 8;
                            break;
                        }
                        case OK: {
                            if (this.in.remaining() == 0) {
                                this.readState = 1;
                                break;
                            }
                            this.readState = 8;
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.in.compact();
                            this.readState = 2;
                            break;
                        }
                        case CLOSED: {
                            throw DisconnectedChannelException.INSTANCE;
                        }
                    }
                    this.unwrapped.flip();
                    ByteBuffers.copy(this.unwrapped, dst);
                    continue block21;
                }
                default: {
                    continue block21;
                }
            }
        }
        return dst.position() - p;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshake();
        }
        if (this.out.remaining() > 0) {
            ByteBuffers.copyNonBlocking(this.out, this.channel, 1000);
        }
        int r = src.remaining();
        while (src.remaining() > 0) {
            this.out.clear();
            SSLEngineResult result = this.engine.wrap(src, this.out);
            if (result.getStatus() != SSLEngineResult.Status.OK) {
                throw new IOException("Expected OK, got: " + (Object)((Object)result.getStatus()));
            }
            this.out.flip();
            ByteBuffers.copyNonBlocking(this.out, this.channel, 1000);
        }
        return r - src.remaining();
    }

    private void closureOnException() throws IOException {
        SSLEngineResult sslEngineResult;
        this.unwrapped.position(0);
        this.unwrapped.limit(0);
        do {
            this.out.clear();
            sslEngineResult = this.engine.wrap(this.unwrapped, this.out);
            this.out.flip();
            this.channel.write(this.out);
        } while (sslEngineResult.getStatus() != SSLEngineResult.Status.CLOSED && !this.engine.isInboundDone());
        this.engine.closeOutbound();
    }

    private void handshake() throws IOException {
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            return;
        }
        this.engine.beginHandshake();
        block16: while (this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            switch (this.handshakeStatus) {
                case NOT_HANDSHAKING: {
                    throw new IOException("Not handshaking");
                }
                case NEED_WRAP: {
                    this.out.clear();
                    this.unwrapped.clear();
                    try {
                        this.handshakeStatus = this.engine.wrap(this.unwrapped, this.out).getHandshakeStatus();
                    }
                    catch (SSLException e) {
                        LOG.error().$("Server SSL handshake failed: ").$(e.getMessage()).$();
                        this.closureOnException();
                        throw e;
                    }
                    this.out.flip();
                    this.channel.write(this.out);
                    continue block16;
                }
                case NEED_UNWRAP: {
                    if (!this.inData || !this.in.hasRemaining()) {
                        this.in.clear();
                        this.channel.read(this.in);
                        this.in.flip();
                        this.inData = true;
                    }
                    try {
                        SSLEngineResult res = this.engine.unwrap(this.in, this.unwrapped);
                        this.handshakeStatus = res.getHandshakeStatus();
                        switch (res.getStatus()) {
                            case BUFFER_UNDERFLOW: {
                                this.in.compact();
                                this.channel.read(this.in);
                                this.in.flip();
                                break;
                            }
                            case BUFFER_OVERFLOW: {
                                throw new IOException("Did not expect OVERFLOW here");
                            }
                            case OK: {
                                break;
                            }
                            case CLOSED: {
                                throw new IOException("Did not expect CLOSED");
                            }
                        }
                        continue block16;
                    }
                    catch (SSLException e) {
                        LOG.error().$("Client SSL handshake failed: ").$(e.getMessage()).$();
                        throw e;
                    }
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.engine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    this.handshakeStatus = this.engine.getHandshakeStatus();
                    continue block16;
                }
            }
            throw new JournalRuntimeException("Unknown handshake status: %s", new Object[]{this.handshakeStatus});
        }
        this.in.clear();
        this.unwrapped.position(this.unwrapped.limit());
    }
}

