/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.std.ex.NetworkError;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslConfig {
    private static final X509TrustManager[] allowAllTrustManagers = new X509TrustManager[]{new AllowAllTrustManager()};
    private boolean secure = false;
    private boolean requireClientAuth = false;
    private SSLContext sslContext;
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;
    private boolean client = false;
    private boolean trustAll = false;

    public SSLContext getSslContext() {
        if (this.sslContext == null) {
            this.sslContext = this.createSSLContext();
        }
        return this.sslContext;
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public boolean isRequireClientAuth() {
        return this.requireClientAuth;
    }

    public void setRequireClientAuth(boolean requireClientAuth) {
        this.requireClientAuth = requireClientAuth;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public void setKeyStore(InputStream stream, String password) throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.setKeyStore("JKS", stream, password);
    }

    public void setTrustStore(InputStream stream, String password) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.setTrustStore("JKS", stream, password, null);
    }

    private SSLContext createSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            SecureRandom sr = new SecureRandom();
            sr.nextInt();
            sslContext.init(this.keyManagerFactory != null ? this.keyManagerFactory.getKeyManagers() : null, (TrustManager[])(this.trustManagerFactory != null ? this.trustManagerFactory.getTrustManagers() : (this.trustAll ? allowAllTrustManagers : null)), sr);
            return sslContext;
        }
        catch (Exception e) {
            throw new NetworkError(e);
        }
    }

    private KeyStore loadKeyStore(String type, InputStream stream, String password, String alias) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (stream == null) {
            throw new KeyStoreException("NULL key store");
        }
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(stream, password == null ? null : password.toCharArray());
        if (alias != null) {
            ArrayList<String> aliases = new ArrayList<String>();
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                aliases.add(e.nextElement());
            }
            for (int i = 0; i < aliases.size(); ++i) {
                if (((String)aliases.get(i)).equals(alias)) continue;
                keyStore.deleteEntry((String)aliases.get(i));
            }
        }
        return keyStore;
    }

    private void setKeyStore(String type, InputStream stream, String password) throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.setKeyStore(type, stream, password, null, password);
    }

    private void setKeyStore(String type, InputStream stream, String password, String alias, String aliasPassword) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = this.loadKeyStore(type, stream, password, alias);
        this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.keyManagerFactory.init(keyStore, aliasPassword == null ? null : aliasPassword.toCharArray());
    }

    private void setTrustStore(String type, InputStream stream, String password, String alias) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = this.loadKeyStore(type, stream, password, alias);
        this.trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        this.trustManagerFactory.init(keyStore);
    }

    private static final class AllowAllTrustManager
    implements X509TrustManager {
        private AllowAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

