/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class StatsCollectingReadableByteChannel
implements ReadableByteChannel {
    private static final Log LOG = LogFactory.getLog(StatsCollectingReadableByteChannel.class);
    private final SocketAddress socketAddress;
    private ReadableByteChannel delegate;
    private long startTime;
    private long byteCount;
    private long callCount;

    public StatsCollectingReadableByteChannel(SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public void logStats() {
        if (this.byteCount > 10L) {
            long endTime = System.currentTimeMillis();
            LOG.info().$("received ").$(this.byteCount).$(" bytes @ ").$((double)(this.byteCount * 1000L) / (double)(endTime - this.startTime) / 1024.0 / 1024.0).$(" MB/s from: ").$(this.socketAddress.toString()).$(" [").$(this.callCount).$(" calls]").$();
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        ++this.callCount;
        int count = this.delegate.read(dst);
        this.byteCount += (long)count;
        return count;
    }

    public void setDelegate(ReadableByteChannel delegate) {
        this.delegate = delegate;
        this.startTime = System.currentTimeMillis();
        this.byteCount = 0L;
        this.callCount = 0L;
    }
}

