/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.MPSequence;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SCSequence;
import com.questdb.mp.Sequence;
import com.questdb.mp.SynchronizedJob;
import com.questdb.net.Context;
import com.questdb.net.ContextFactory;
import com.questdb.net.DisconnectReason;
import com.questdb.net.Dispatcher;
import com.questdb.net.Event;
import com.questdb.std.LongIntHashMap;
import com.questdb.std.LongMatrix;
import com.questdb.std.Misc;
import com.questdb.std.Net;
import com.questdb.std.ObjectFactory;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.NetworkError;
import com.questdb.std.time.MillisecondClock;
import java.io.IOException;

public class Win32SelectDispatcher<C extends Context>
extends SynchronizedJob
implements Dispatcher<C> {
    private static final int M_TIMESTAMP = 0;
    private static final int M_FD = 1;
    private static final int M_OPERATION = 2;
    private static final Log LOG = LogFactory.getLog(Win32SelectDispatcher.class);
    private static final int COUNT_OFFSET;
    private static final int ARRAY_OFFSET;
    private static final int FD_READ = 1;
    private static final int FD_WRITE = 2;
    private final FDSet readFdSet;
    private final FDSet writeFdSet;
    private final long socketFd;
    private final RingQueue<Event<C>> ioQueue;
    private final Sequence ioSequence;
    private final RingQueue<Event<C>> interestQueue;
    private final MPSequence interestPubSequence;
    private final SCSequence interestSubSequence = new SCSequence();
    private final MillisecondClock clock;
    private final int timeout;
    private final LongMatrix<C> pending = new LongMatrix(4);
    private final int maxConnections;
    private final LongIntHashMap fds = new LongIntHashMap();
    private final ContextFactory<C> contextFactory;
    private int connectionCount = 0;

    public Win32SelectDispatcher(CharSequence ip, int port, int maxConnections, int timeout, RingQueue<Event<C>> ioQueue, Sequence ioSequence, MillisecondClock clock, int capacity, ObjectFactory<Event<C>> eventFactory, ContextFactory<C> contextFactory) {
        this.readFdSet = new FDSet(capacity);
        this.writeFdSet = new FDSet(capacity);
        this.ioQueue = ioQueue;
        this.ioSequence = ioSequence;
        this.interestQueue = new RingQueue<Event<C>>(eventFactory, ioQueue.getCapacity());
        this.interestPubSequence = new MPSequence(this.interestQueue.getCapacity());
        this.interestPubSequence.then(this.interestSubSequence).then(this.interestPubSequence);
        this.clock = clock;
        this.maxConnections = maxConnections;
        this.timeout = timeout;
        this.contextFactory = contextFactory;
        this.socketFd = Net.socketTcp(false);
        if (!Net.bindTcp(this.socketFd, ip, port)) {
            throw new NetworkError("Failed to bind socket. System error " + Os.errno());
        }
        Net.listen(this.socketFd, 128);
        int r = this.pending.addRow();
        this.pending.set(r, 0, System.currentTimeMillis());
        this.pending.set(r, 1, this.socketFd);
        this.pending.set(r, 2, 1L);
        this.readFdSet.add(this.socketFd);
        this.readFdSet.setCount(1);
        this.writeFdSet.setCount(0);
    }

    @Override
    public void close() throws IOException {
        this.readFdSet.close();
        this.writeFdSet.close();
        int n = this.pending.size();
        for (int i = 0; i < n; ++i) {
            Net.close(this.pending.get(i, 1));
            Misc.free(this.pending.get(i));
        }
        this.pending.zapTop(this.pending.size());
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount;
    }

    @Override
    public void registerChannel(C context, int channelStatus) {
        long cursor = this.interestPubSequence.nextBully();
        Event<C> evt = this.interestQueue.get(cursor);
        evt.context = context;
        evt.channelStatus = channelStatus;
        LOG.debug().$("Re-queuing ").$(channelStatus).$(" on ").$(context.getFd()).$();
        this.interestPubSequence.done(cursor);
    }

    private static native int select(long var0, long var2, long var4);

    private static native int countOffset();

    private static native int arrayOffset();

    private void accept(long timestamp) {
        while (true) {
            long _fd;
            if ((_fd = Net.accept(this.socketFd)) < 0L) {
                int err = Os.errno();
                if (err == Net.EWOULDBLOCK || err == 0) break;
                LOG.error().$("Error in accept(): ").$(err).$();
                break;
            }
            LOG.info().$(" Connected ").$(_fd).$();
            if (Net.configureNonBlocking(_fd) < 0) {
                LOG.error().$("Cannot make FD non-blocking").$();
                Net.close(_fd);
                continue;
            }
            ++this.connectionCount;
            if (this.connectionCount > this.maxConnections) {
                LOG.info().$("Too many connections, kicking out ").$(_fd).$();
                Net.close(_fd);
                --this.connectionCount;
                return;
            }
            this.addPending(_fd, timestamp);
        }
    }

    private void addPending(long _fd, long timestamp) {
        int r = this.pending.addRow();
        LOG.debug().$(" Matrix row ").$(r).$(" for ").$(_fd).$();
        this.pending.set(r, 0, timestamp);
        this.pending.set(r, 1, _fd);
        this.pending.set(r, 2, 1L);
        this.pending.set(r, this.contextFactory.newInstance(_fd, this.clock));
    }

    private void disconnect(C context, int disconnectReason) {
        LOG.info().$("Disconnected ").$ip(context.getIp()).$(" [").$(DisconnectReason.nameOf(disconnectReason)).$(']').$();
        context.close();
        --this.connectionCount;
    }

    private void enqueue(C context, int channelStatus) {
        long cursor = this.ioSequence.nextBully();
        Event<C> evt = this.ioQueue.get(cursor);
        evt.context = context;
        evt.channelStatus = channelStatus;
        this.ioSequence.done(cursor);
        LOG.debug().$("Queuing ").$(channelStatus).$(" on ").$(context.getFd()).$();
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        while ((cursor = this.interestSubSequence.next()) > -1L) {
            useful = true;
            Event<C> evt = this.interestQueue.get(cursor);
            Object context = evt.context;
            int channelStatus = evt.channelStatus;
            this.interestSubSequence.done(cursor);
            int r = this.pending.addRow();
            this.pending.set(r, 0, timestamp);
            this.pending.set(r, 1, context.getFd());
            this.pending.set(r, 2, channelStatus);
            this.pending.set(r, context);
        }
        return useful;
    }

    private void queryFdSets(long timestamp) {
        long fd;
        int i;
        int n = this.readFdSet.getCount();
        for (i = 0; i < n; ++i) {
            fd = this.readFdSet.get(i);
            if (fd == this.socketFd) {
                this.accept(timestamp);
                continue;
            }
            this.fds.put(fd, 1);
        }
        n = this.writeFdSet.getCount();
        for (i = 0; i < n; ++i) {
            fd = this.writeFdSet.get(i);
            int op = this.fds.get(fd);
            if (op == -1) {
                this.fds.put(fd, 2);
                continue;
            }
            this.fds.put(fd, 3);
        }
    }

    @Override
    protected boolean runSerially() {
        int count = Win32SelectDispatcher.select(this.readFdSet.address, this.writeFdSet.address, 0L);
        if (count < 0) {
            LOG.error().$("Error in select(): ").$(Os.errno()).$();
            return false;
        }
        long timestamp = this.clock.getTicks();
        boolean useful = false;
        this.fds.clear();
        if (count > 0) {
            this.queryFdSets(timestamp);
            useful = true;
        }
        useful = this.processRegistrations(timestamp) | useful;
        int readFdCount = 0;
        int writeFdCount = 0;
        this.readFdSet.reset();
        this.writeFdSet.reset();
        long deadline = timestamp - (long)this.timeout;
        int i = 0;
        int n = this.pending.size();
        block6: while (i < n) {
            long ts = this.pending.get(i, 0);
            long fd = this.pending.get(i, 1);
            int _new_op = this.fds.get(fd);
            if (_new_op == -1) {
                if (ts < deadline && fd != this.socketFd) {
                    this.disconnect((Context)this.pending.get(i), 2);
                    this.pending.deleteRow(i);
                    --n;
                    useful = true;
                    continue;
                }
                switch ((int)this.pending.get(i, 2)) {
                    case 1: {
                        this.readFdSet.add(fd);
                        ++readFdCount;
                        ++i;
                        continue block6;
                    }
                    case 4: {
                        this.writeFdSet.add(fd);
                        ++writeFdCount;
                        ++i;
                        continue block6;
                    }
                    case 3: {
                        this.disconnect((Context)this.pending.get(i), 3);
                        this.pending.deleteRow(i);
                        --n;
                        useful = true;
                        continue block6;
                    }
                    case 5: {
                        this.disconnect((Context)this.pending.get(i), 1);
                        this.pending.deleteRow(i);
                        --n;
                        useful = true;
                        continue block6;
                    }
                }
                continue;
            }
            Context context = (Context)this.pending.get(i);
            if ((_new_op & 1) > 0) {
                this.enqueue(context, 1);
            }
            if ((_new_op & 2) > 0) {
                this.enqueue(context, 4);
            }
            this.pending.deleteRow(i);
            --n;
        }
        this.readFdSet.setCount(readFdCount);
        this.writeFdSet.setCount(writeFdCount);
        return useful;
    }

    static {
        ARRAY_OFFSET = Win32SelectDispatcher.arrayOffset();
        COUNT_OFFSET = Win32SelectDispatcher.countOffset();
    }

    private static class FDSet {
        private long address;
        private int size;
        private long _wptr;
        private long lim;

        private FDSet(int size) {
            int l = ARRAY_OFFSET + 8 * size;
            this.address = Unsafe.malloc(l);
            this.size = size;
            this._wptr = this.address + (long)ARRAY_OFFSET;
            this.lim = this.address + (long)l;
        }

        private void add(long fd) {
            if (this._wptr == this.lim) {
                this.resize();
            }
            long p = this._wptr;
            Unsafe.getUnsafe().putLong(p, fd);
            this._wptr = p + 8L;
        }

        private void close() {
            if (this.address != 0L) {
                Unsafe.free(this.address, this.lim - this.address);
                this.address = 0L;
            }
        }

        private long get(int index) {
            return Unsafe.getUnsafe().getLong(this.address + (long)ARRAY_OFFSET + (long)index * 8L);
        }

        private int getCount() {
            return Unsafe.getUnsafe().getInt(this.address + (long)COUNT_OFFSET);
        }

        private void setCount(int count) {
            Unsafe.getUnsafe().putInt(this.address + (long)COUNT_OFFSET, count);
        }

        private void reset() {
            this._wptr = this.address + (long)ARRAY_OFFSET;
        }

        private void resize() {
            int sz = this.size * 2;
            int l = ARRAY_OFFSET + 8 * sz;
            long _addr = Unsafe.malloc(l);
            Unsafe.getUnsafe().copyMemory(this.address, _addr, this.lim - this.address);
            Unsafe.free(this.address, this.lim - this.address);
            this.lim = _addr + (long)l;
            this.size = sz;
            this._wptr = _addr + (this._wptr - this.address);
            this.address = _addr;
        }
    }
}

