/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.net.ha.AbstractChannelConsumer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalNetworkException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;

public abstract class AbstractObjectConsumer
extends AbstractChannelConsumer {
    private final ByteBuffer header = ByteBuffer.allocateDirect(4).order(ByteOrder.LITTLE_ENDIAN);
    private final long headerAddress = ByteBuffers.getAddress(this.header);
    private ByteBuffer valueBuffer;

    @Override
    public void free() {
        this.valueBuffer = ByteBuffers.release(this.valueBuffer);
        ByteBuffers.release(this.header);
    }

    @Override
    protected final void doRead(ReadableByteChannel channel) throws JournalNetworkException {
        this.header.position(0);
        ByteBuffers.copy(channel, this.header);
        int bufSz = Unsafe.getUnsafe().getInt(this.headerAddress);
        if (this.valueBuffer == null || this.valueBuffer.capacity() < bufSz) {
            ByteBuffers.release(this.valueBuffer);
            this.valueBuffer = ByteBuffer.allocateDirect(bufSz).order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.valueBuffer.rewind();
        }
        this.valueBuffer.limit(bufSz);
        ByteBuffers.copy(channel, this.valueBuffer, (long)bufSz);
    }

    protected final ByteBuffer getValueBuffer() {
        return this.valueBuffer;
    }
}

